/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdbm.RecordListener;
import jdbm.RecordManager;
import jdbm.Serializer;
import jdbm.SerializerInput;
import jdbm.SerializerOutput;
import jdbm.helper.JdbmBase;
import jdbm.htree.HTreeMap;
import jdbm.htree.HashBucket;
import jdbm.htree.HashDirectory;
import jdbm.htree.HashNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTree<K, V>
implements JdbmBase<K, V> {
    final Serializer SERIALIZER = new Serializer<HashNode>(){

        @Override
        public HashNode deserialize(SerializerInput ds) throws IOException {
            try {
                int i = ds.read();
                if (i == 164) {
                    HashBucket ret = new HashBucket(HTree.this);
                    ret.readExternal(ds);
                    if (ds.available() != 0 && ds.read() != -1) {
                        throw new InternalError("bytes left: " + ds.available());
                    }
                    return ret;
                }
                if (i == 165) {
                    HashDirectory ret = new HashDirectory(HTree.this);
                    ret.readExternal(ds);
                    if (ds.available() != 0 && ds.read() != -1) {
                        throw new InternalError("bytes left: " + ds.available());
                    }
                    return ret;
                }
                throw new InternalError("Wrong HTree header: " + i);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public void serialize(SerializerOutput out, HashNode obj) throws IOException {
            if (obj.getClass() == HashBucket.class) {
                out.write(164);
                HashBucket b = (HashBucket)obj;
                b.writeExternal(out);
            } else {
                out.write(165);
                HashDirectory n = (HashDirectory)obj;
                n.writeExternal(out);
            }
        }
    };
    private HashDirectory<K, V> _root;
    protected List<RecordListener<K, V>> recordListeners = new ArrayList<RecordListener<K, V>>();
    protected Serializer<K> keySerializer;
    protected Serializer<V> valueSerializer;
    transient long hashEqualsIdentityCounter = 0L;

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    HTree() {
    }

    public static <K, V> HTree<K, V> createInstance(RecordManager recman) throws IOException {
        return HTree.createInstance(recman, null, null);
    }

    public static <K, V> HTree<K, V> createInstance(RecordManager recman, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        HTree<K, V> tree = new HTree<K, V>();
        tree.keySerializer = keySerializer;
        tree.valueSerializer = valueSerializer;
        tree._root = new HashDirectory<K, V>(tree, 0);
        long recid = recman.insert(tree._root, tree.SERIALIZER);
        tree._root.setPersistenceContext(recman, recid);
        return tree;
    }

    public static <K, V> HTree<K, V> load(RecordManager recman, long root_recid) throws IOException {
        return HTree.load(recman, root_recid, null, null);
    }

    public static <K, V> HTree<K, V> load(RecordManager recman, long root_recid, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        HTree<K, V> tree = new HTree<K, V>();
        tree.keySerializer = keySerializer;
        tree.valueSerializer = valueSerializer;
        tree._root = (HashDirectory)recman.fetch(root_recid, tree.SERIALIZER);
        tree._root.setPersistenceContext(recman, root_recid);
        return tree;
    }

    public synchronized void put(K key, V value) throws IOException {
        Object oldVal = null;
        if (!this.recordListeners.isEmpty()) {
            oldVal = this.find(key);
        }
        this._root.put(key, value);
        if (oldVal == null) {
            for (RecordListener<K, V> recordListener : this.recordListeners) {
                recordListener.recordInserted(key, value);
            }
        } else {
            for (RecordListener<K, Object> recordListener : this.recordListeners) {
                recordListener.recordUpdated(key, oldVal, value);
            }
        }
    }

    @Override
    public synchronized V find(K key) throws IOException {
        return this._root.get(key);
    }

    public synchronized void remove(K key) throws IOException {
        Object val = null;
        if (!this.recordListeners.isEmpty()) {
            val = this.find(key);
        }
        this._root.remove(key);
        if (val != null) {
            for (RecordListener<K, Object> recordListener : this.recordListeners) {
                recordListener.recordRemoved(key, val);
            }
        }
    }

    public synchronized Iterator<K> keys() throws IOException {
        return this._root.keys();
    }

    public synchronized Iterator<V> values() throws IOException {
        return this._root.values();
    }

    public long getRecid() {
        return this._root.getRecid();
    }

    public HTreeMap<K, V> asMap() {
        return new HTreeMap(this, false);
    }

    @Override
    public void addRecordListener(RecordListener<K, V> listener) {
        this.recordListeners.add(listener);
    }

    @Override
    public void removeRecordListener(RecordListener<K, V> listener) {
        this.recordListeners.remove(listener);
    }

    @Override
    public RecordManager getRecordManager() {
        return this._root.getRecordManager();
    }
}

