/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreeLogicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.PageManager;
import jdbm.recman.RecordFile;
import jdbm.recman.TranslationPage;

final class LogicalRowIdManager {
    private final RecordFile file;
    private final PageManager pageman;
    private final FreeLogicalRowIdPageManager freeman;
    final short ELEMS_PER_PAGE;
    private int blockSize;

    LogicalRowIdManager(RecordFile file, PageManager pageman, FreeLogicalRowIdPageManager freeman) throws IOException {
        this.file = file;
        this.pageman = pageman;
        this.freeman = freeman;
        this.blockSize = file.BLOCK_SIZE;
        this.ELEMS_PER_PAGE = (short)((this.blockSize - 18) / 8);
    }

    long insert(long loc) throws IOException {
        long retval = this.freeman.get();
        if (retval == 0L) {
            long firstPage = this.pageman.allocate((short)2);
            short curOffset = 18;
            int i = 0;
            while (i < this.ELEMS_PER_PAGE) {
                this.freeman.put(Location.toLong(firstPage, curOffset));
                curOffset = (short)(curOffset + 8);
                ++i;
            }
            retval = this.freeman.get();
            if (retval == 0L) {
                throw new Error("couldn't obtain free translation");
            }
        }
        this.update(retval, loc);
        return retval;
    }

    void forceInsert(long logicalRowId, long physLoc) throws IOException {
        long lastBlock = this.pageman.getLast((short)2);
        while (lastBlock != Location.getBlock(logicalRowId)) {
            lastBlock = this.pageman.allocate((short)2);
            if (lastBlock <= Location.getBlock(logicalRowId)) continue;
            throw new Error("outallocated");
        }
        if (this.fetch(logicalRowId) != 0L) {
            throw new Error("can not forceInsert, record already exists: " + logicalRowId);
        }
        this.update(logicalRowId, physLoc);
    }

    void delete(long rowid) throws IOException {
        TranslationPage xlatPage = TranslationPage.getTranslationPageView(this.file.get(Location.getBlock(rowid)), this.blockSize);
        xlatPage.setLocationBlock(Location.getOffset(rowid), 0L);
        xlatPage.setLocationOffset(Location.getOffset(rowid), (short)0);
        this.file.release(Location.getBlock(rowid), true);
        this.freeman.put(rowid);
    }

    void update(long rowid, long loc) throws IOException {
        TranslationPage xlatPage = TranslationPage.getTranslationPageView(this.file.get(Location.getBlock(rowid)), this.blockSize);
        xlatPage.setLocationBlock(Location.getOffset(rowid), Location.getBlock(loc));
        xlatPage.setLocationOffset(Location.getOffset(rowid), Location.getOffset(loc));
        this.file.release(Location.getBlock(rowid), true);
    }

    long fetch(long rowid) throws IOException {
        long block = Location.getBlock(rowid);
        long last = this.pageman.getLast((short)2);
        if (last + 1L < block) {
            return 0L;
        }
        short offset = Location.getOffset(rowid);
        BlockIo bio = this.file.get(block);
        TranslationPage xlatPage = TranslationPage.getTranslationPageView(bio, this.blockSize);
        try {
            long retval;
            long l = retval = Location.toLong(xlatPage.getLocationBlock(offset), xlatPage.getLocationOffset(offset));
            return l;
        }
        finally {
            this.file.release(block, false);
        }
    }

    void commit() throws IOException {
        this.freeman.commit();
    }
}

