/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;

final class RecordHeader {
    private static final short O_CURRENTSIZE = 0;
    private static final short O_AVAILABLESIZE = 2;
    static final int SIZE = 4;
    static final int MAX_SIZE_SPACE = 65534;
    static final int sizeMask = 49152;
    static final int multi0 = 1;
    static final int multi1 = 16;
    static final int multi2 = 256;
    static final int multi3 = 8192;
    static final int base0 = 0;
    static final int base1 = 16382;
    static final int base2 = 278494;
    static final int base3 = 4472286;
    static final int base4 = 138690012;
    static final int MAX_RECORD_SIZE = RecordHeader.roundAvailableSize(137870812);

    RecordHeader() {
    }

    static int getCurrentSize(BlockIo block, short pos) {
        int s = block.readUnsignedshort(pos + 0);
        if (s == 65535) {
            return 0;
        }
        return RecordHeader.getAvailableSize(block, pos) - s;
    }

    static void setCurrentSize(BlockIo block, short pos, int value) {
        if (value == 0) {
            block.writeUnsignedShort(pos + 0, 65535);
            return;
        }
        int availSize = RecordHeader.getAvailableSize(block, pos);
        if (value < availSize - 65534 || value > availSize) {
            throw new IllegalArgumentException("currentSize out of bounds, need to realocate " + value + " - " + availSize);
        }
        block.writeUnsignedShort(pos + 0, availSize - value);
    }

    static int getAvailableSize(BlockIo block, short pos) {
        int val = block.readUnsignedshort(pos + 2);
        return RecordHeader.deconvertAvailSize(val);
    }

    static void setAvailableSize(BlockIo block, short pos, int value) {
        int oldCurrSize = RecordHeader.getCurrentSize(block, pos);
        block.writeUnsignedShort(pos + 2, RecordHeader.convertAvailSize(value));
        RecordHeader.setCurrentSize(block, pos, oldCurrSize);
    }

    private static int convertAvailSize(int recordSize) {
        int multiplyer = 0;
        int counter = 0;
        if (recordSize <= 16382) {
            multiplyer = 0;
            counter = recordSize / 1;
        } else if (recordSize < 278494) {
            multiplyer = 16384;
            int val2 = recordSize - 16382;
            counter = val2 / 16;
            if (val2 % 16 != 0) {
                ++counter;
            }
        } else if (recordSize < 4472286) {
            multiplyer = 32768;
            int val2 = recordSize - 278494;
            counter = val2 / 256;
            if (val2 % 256 != 0) {
                ++counter;
            }
        } else {
            multiplyer = 49152;
            int val2 = recordSize - 4472286;
            counter = val2 / 8192;
            if (val2 % 8192 != 0) {
                ++counter;
            }
        }
        if (counter >= 16384) {
            throw new InternalError("" + recordSize);
        }
        return multiplyer + counter;
    }

    private static int deconvertAvailSize(int recordSize) {
        int multiplier = (recordSize & 0xC000) >> 14;
        int counter = recordSize - (recordSize & 0xC000);
        switch (multiplier) {
            case 0: {
                return counter * 1;
            }
            case 1: {
                return 16382 + counter * 16;
            }
            case 2: {
                return 278494 + counter * 256;
            }
            case 3: {
                return 4472286 + counter * 8192;
            }
        }
        throw new InternalError("error deconverting: " + recordSize);
    }

    static int roundAvailableSize(int value) {
        if (value > MAX_RECORD_SIZE && MAX_RECORD_SIZE != 0) {
            new InternalError("Maximal record size (" + MAX_RECORD_SIZE + ") exceeded: " + value);
        }
        return RecordHeader.deconvertAvailSize(RecordHeader.convertAvailSize(value));
    }
}

