/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.InvalidParseTableException;
import org.spoofax.jsglr.client.ParseException;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.TokenExpectedException;
import org.spoofax.terms.TermFactory;

public class JSGLREntryPoint
implements EntryPoint {
    private void fetchParseTable(String parseTable) {
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, parseTable);
        try {
            builder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    GWT.log((String)"error", (Throwable)exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    JSGLREntryPoint.this.parseAndGo(response.getText());
                }
            });
        }
        catch (RequestException e) {
            GWT.log((String)"error", (Throwable)e);
        }
    }

    public void onModuleLoad() {
        RootPanel.get().add((Widget)new Label("Loading parse table from server"));
        this.fetchParseTable("/Stratego.tbl");
    }

    void parseAndGo(String table) {
        try {
            System.out.println(table.length());
            TermFactory af = new TermFactory();
            IStrategoTerm pt = af.parseFromString(table);
            System.out.println(pt.toString().length());
            SGLR sglr = new SGLR(af, new ParseTable(pt, af));
            long now = System.currentTimeMillis();
            IStrategoTerm r = (IStrategoTerm)sglr.parse(this.strategoSampleCode(), null, null);
            now = System.currentTimeMillis() - now;
            if (r != null) {
                RootPanel.get().add((Widget)new Label(r.toString()));
                RootPanel.get().add((Widget)new Label("Parse time : " + now + " ms"));
            } else {
                RootPanel.get().add((Widget)new Label("Parsing failed"));
            }
        }
        catch (InvalidParseTableException e) {
            JSGLREntryPoint.wrap(e);
        }
        catch (TokenExpectedException e) {
            JSGLREntryPoint.wrap(e);
        }
        catch (BadTokenException e) {
            JSGLREntryPoint.wrap(e);
        }
        catch (ParseException e) {
            JSGLREntryPoint.wrap(e);
        }
        catch (SGLRException e) {
            JSGLREntryPoint.wrap(e);
        }
    }

    private static void wrap(Exception e) {
        System.err.println(e);
        throw new RuntimeException(e);
    }

    private String strategoSampleCode() {
        return "module common\nimports\n  include/Stratify\nstrategies\ncollect-meta-prop =\n         ?Prop(n, v)\n       ; rules(meta-prop : n -> v)\n       ; <debug> (\"registered\", n, \"->\", v)\n       ; <meta-prop> n\n       ; <debug> (\"looked up\", n, \"->\", <id>)\n apply-with-props(s | props) =\n        {meta-props:\n              where(<map(collect-meta-prop)> props)\n          ; s\n        }\n string-join(|c) =\n          <foldl(\\(x,y) -> <concat-strings> [y, c, x]\\)> (<id>, \"\")\n        ; trim-chars(?',')";
    }

    private String booleanSampleCode() {
        return "(T&T|F)&not(F)|Bool293";
    }
}

