/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    public static IStrategoString stringAt(IStrategoTerm t, int i) {
        return (IStrategoString)t.getSubterm(i);
    }

    public static IStrategoAppl applAt(IStrategoTerm t, int i) {
        return (IStrategoAppl)t.getSubterm(i);
    }

    public static IStrategoAppl applAt(IStrategoList t, int i) {
        return (IStrategoAppl)t.getSubterm(i);
    }

    public static IStrategoInt intAt(IStrategoTerm t, int i) {
        return (IStrategoInt)t.getSubterm(i);
    }

    public static IStrategoInt intAt(IStrategoList t, int i) {
        return (IStrategoInt)t.getSubterm(i);
    }

    public static IStrategoList listAt(IStrategoTerm t, int i) {
        return (IStrategoList)t.getSubterm(i);
    }

    public static IStrategoList listAt(IStrategoList t, int i) {
        return (IStrategoList)t.getSubterm(i);
    }

    public static <T extends IStrategoTerm> T termAt(IStrategoTerm t, int i) {
        return (T)t.getSubterm(i);
    }

    public static IStrategoReal realAt(IStrategoList t, int i) {
        return (IStrategoReal)t.getSubterm(i);
    }

    public static IStrategoTerm termAt(IStrategoList t, int i) {
        return t.getSubterm(i);
    }

    public static boolean isCons(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getCons();
    }

    public static boolean isTermString(IStrategoTerm t) {
        return t.getTermType() == 5;
    }

    public static String javaString(IStrategoTerm t) {
        return ((IStrategoString)t).stringValue();
    }

    public static boolean isTermList(IStrategoTerm t) {
        return t.getTermType() == 2;
    }

    public static boolean isNil(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getNil();
    }

    public static boolean isSDefT(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getSDefT();
    }

    public static boolean isExtSDef(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getExtSDef();
    }

    public static boolean isTermInt(IStrategoTerm t) {
        return t.getTermType() == 3;
    }

    public static boolean isAnno(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getAnno();
    }

    public static boolean isOp(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getOp();
    }

    public static boolean isStr(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getStr();
    }

    public static boolean isVar(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getVar();
    }

    public static boolean isExplode(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getExplode();
    }

    public static boolean isWld(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getWld();
    }

    public static boolean isAs(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getAs();
    }

    public static boolean isReal(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getReal();
    }

    public static boolean isInt(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getInt();
    }

    public static boolean isTermReal(IStrategoTerm t) {
        return t.getTermType() == 4;
    }

    public static boolean isTermAppl(IStrategoTerm t) {
        return t.getTermType() == 1;
    }

    public static boolean isFunType(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getFunType();
    }

    public static boolean isConstType(IStrategoAppl t, IContext env) {
        return t.getConstructor() == env.getStrategoSignature().getConstType();
    }

    public static String javaStringAt(IStrategoTerm t, int i) {
        return Tools.stringAt(t, i).stringValue();
    }

    public static String javaStringAt(IStrategoAppl t, int i) {
        return Tools.stringAt(t, i).stringValue();
    }

    public static String javaStringAt(IStrategoList t, int i) {
        return Tools.stringAt(t, i).stringValue();
    }

    public static int javaIntAt(IStrategoTerm t, int i) {
        IStrategoInt result = Tools.intAt(t, i);
        return result.intValue();
    }

    public static int javaInt(IStrategoTerm term) {
        return ((IStrategoInt)term).intValue();
    }

    public static boolean hasConstructor(IStrategoAppl t, String ctorName) {
        return t.getConstructor().getName().equals(ctorName);
    }

    public static boolean isTermTuple(IStrategoTerm t) {
        return t.getTermType() == 7;
    }

    public static int asJavaInt(IStrategoTerm term) {
        return ((IStrategoInt)term).intValue();
    }

    public static String asJavaString(IStrategoTerm term) {
        return ((IStrategoString)term).stringValue();
    }
}

