/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.ssl.RandomAccessInputStream;
import org.spoofax.interpreter.library.ssl.RandomAccessOutputStream;

public class IOAgent {
    public static final int CONST_STDIN = 0;
    public static final int CONST_STDOUT = 1;
    public static final int CONST_STDERR = 2;
    private static final String FILE_ENCODING = "UTF-8";
    private static final Charset FILE_CHARSET = Charset.forName("UTF-8");
    private final Map<Integer, FileHandle> openFiles = new HashMap<Integer, FileHandle>();
    private final Writer stdoutWriter = new PrintStreamWriter(System.out);
    private final Writer stderrWriter = new PrintStreamWriter(System.err);
    private final Reader stdinReader = new InputStreamReader(System.in, FILE_CHARSET);
    private final OutputStream stdout = System.out;
    private final OutputStream stderr = System.err;
    private final InputStream stdin = System.in;
    private String workingDir;
    private String definitionDir;
    private int fileCounter = 3;

    public IOAgent() {
        try {
            String dir = System.getProperty("user.dir");
            if (dir == null) {
                dir = ".";
            }
            this.setWorkingDir(dir);
            this.setDefinitionDir(dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getDefinitionDir() {
        return this.definitionDir;
    }

    public String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public void setWorkingDir(String workingDir) throws FileNotFoundException, IOException {
        File workingDirFile = new File(this.getAbsolutePath(this.getWorkingDir(), workingDir));
        if (!workingDirFile.exists() || !workingDirFile.isDirectory()) {
            throw new FileNotFoundException(workingDir);
        }
        this.workingDir = workingDirFile.getCanonicalPath();
    }

    public void setDefinitionDir(String definitionDir) throws FileNotFoundException {
        File definitionDirFile = new File(this.getAbsolutePath(this.getDefinitionDir(), definitionDir));
        if (!definitionDirFile.exists() || !definitionDirFile.isDirectory()) {
            throw new FileNotFoundException(definitionDir);
        }
        this.definitionDir = definitionDirFile.getAbsolutePath();
    }

    @Deprecated
    protected String adaptFilePath(String fn) {
        return this.getAbsolutePath(this.getWorkingDir(), fn);
    }

    protected String getAbsolutePath(String dir, String fn) {
        File f = new File(fn);
        return f.isAbsolute() ? f.getAbsolutePath() : new File(dir, fn).getAbsolutePath();
    }

    public Writer getWriter(int fd) {
        if (fd == 1) {
            return this.stdoutWriter;
        }
        if (fd == 2) {
            return this.stderrWriter;
        }
        FileHandle file = this.openFiles.get(fd);
        if (file.writer == null) {
            assert (file.outputStream == null);
            try {
                file.writer = new BufferedWriter(new OutputStreamWriter(this.internalGetOutputStream(fd), FILE_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return file.writer;
    }

    public OutputStream internalGetOutputStream(int fd) {
        if (fd == 1) {
            return this.stdout;
        }
        if (fd == 2) {
            return this.stderr;
        }
        FileHandle file = this.openFiles.get(fd);
        if (file.outputStream == null) {
            assert (file.writer == null);
            file.outputStream = new RandomAccessOutputStream(file.file);
        }
        return file.outputStream;
    }

    public void writeChar(int fd, int c) throws IOException {
        if (fd == 1 || fd == 2) {
            this.getWriter(fd).append((char)c);
        } else {
            this.getWriter(fd).append((char)c);
        }
    }

    public boolean closeRandomAccessFile(int fd) throws InterpreterException {
        if (fd == 1 || fd == 2 || fd == 0) {
            return true;
        }
        FileHandle file = this.openFiles.remove(fd);
        if (file == null) {
            return true;
        }
        try {
            if (file.writer != null) {
                file.writer.close();
            }
            if (file.outputStream != null) {
                file.outputStream.close();
            }
            file.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void closeAllFiles() {
        for (FileHandle file : this.openFiles.values()) {
            try {
                if (file.writer != null) {
                    file.writer.close();
                }
                if (file.outputStream != null) {
                    file.outputStream.close();
                }
                file.file.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.openFiles.clear();
    }

    public int openRandomAccessFile(String fn, String mode) throws FileNotFoundException, IOException {
        Object file;
        boolean appendMode = mode.indexOf(97) >= 0;
        boolean writeMode = appendMode || mode.indexOf(119) >= 0;
        boolean clearFile = false;
        if (writeMode) {
            file = new File(this.getAbsolutePath(this.getWorkingDir(), fn));
            if (!((File)file).exists()) {
                ((File)file).createNewFile();
            } else if (!appendMode) {
                clearFile = true;
            }
        }
        file = new RandomAccessFile(this.getAbsolutePath(this.getWorkingDir(), fn), writeMode ? "rw" : "r");
        if (clearFile) {
            ((RandomAccessFile)file).setLength(0L);
        }
        this.openFiles.put(this.fileCounter, new FileHandle((RandomAccessFile)file));
        return this.fileCounter++;
    }

    public InputStream internalGetInputStream(int fd) {
        if (fd == 0) {
            return this.stdin;
        }
        FileHandle file = this.openFiles.get(fd);
        if (file.inputStream == null) {
            file.inputStream = new RandomAccessInputStream(file.file);
        }
        return file.inputStream;
    }

    public Reader getReader(int fd) {
        if (fd == 0) {
            return this.stdinReader;
        }
        FileHandle file = this.openFiles.get(fd);
        try {
            if (file.reader == null) {
                file.reader = new BufferedReader(new InputStreamReader(this.internalGetInputStream(fd), FILE_ENCODING));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return file.reader;
    }

    public String readString(int fd) throws IOException {
        char[] buffer = new char[2048];
        StringBuilder result = new StringBuilder();
        Reader reader = this.getReader(fd);
        int read = 0;
        while (read != -1) {
            result.append(buffer, 0, read);
            read = reader.read(buffer);
        }
        return result.toString();
    }

    public InputStream openInputStream(String fn, boolean isDefinitionFile) throws FileNotFoundException {
        String dir = isDefinitionFile ? this.getDefinitionDir() : this.getWorkingDir();
        return new FileInputStream(this.getAbsolutePath(dir, fn));
    }

    public final InputStream openInputStream(String fn) throws FileNotFoundException {
        return this.openInputStream(fn, false);
    }

    public void printError(String error) {
        try {
            this.getWriter(2).write(String.valueOf(error) + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OutputStream openFileOutputStream(String fn) throws FileNotFoundException {
        return new FileOutputStream(this.getAbsolutePath(this.getWorkingDir(), fn));
    }

    public File openFile(String fn) {
        return new File(this.getAbsolutePath(this.getWorkingDir(), fn));
    }

    public String createTempFile(String prefix) throws IOException {
        return File.createTempFile(prefix, null).getPath();
    }

    public String createTempDir(String prefix) throws IOException {
        File result;
        do {
            result = File.createTempFile(prefix, null);
            result.delete();
        } while (!result.mkdir());
        result.deleteOnExit();
        return result.getPath();
    }

    public boolean mkdir(String fn) {
        return this.openFile(fn).mkdir();
    }

    @Deprecated
    public boolean mkDirs(String fn) {
        return this.openFile(fn).mkdirs();
    }

    private static class FileHandle {
        final RandomAccessFile file;
        Reader reader;
        Writer writer;
        InputStream inputStream;
        OutputStream outputStream;

        FileHandle(RandomAccessFile file) {
            this.file = file;
        }
    }

    private static class PrintStreamWriter
    extends Writer {
        private final PrintStream stream;

        PrintStreamWriter(PrintStream stream) {
            this.stream = stream;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off == 0 && len == cbuf.length) {
                this.stream.print(cbuf);
            } else {
                this.stream.append(CharBuffer.wrap(cbuf, off, len));
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.stream.append(str, off, len);
        }
    }
}

