/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.interpreter;

import java.io.IOException;
import org.spoofax.interpreter.ConcreteInterpreter;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.UndefinedStrategyException;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.jsglr.client.ParseException;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.TokenExpectedException;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoTerm;

public class SpoofaxInterpreterTerm
extends StrategoTerm {
    private static final long serialVersionUID = -4810841797754395882L;
    private final ConcreteInterpreter interpreter;
    private String lastError;

    public SpoofaxInterpreterTerm(ITermFactory termFactory, IOAgent ioAgent) {
        super(0);
        this.interpreter = new ConcreteInterpreter(termFactory);
        this.interpreter.setIOAgent(ioAgent);
    }

    public void setLastError(String err) {
        this.lastError = err;
    }

    public String getLastError() {
        return this.lastError;
    }

    public IStrategoTerm current() {
        return this.interpreter.current();
    }

    public boolean eval(String line) {
        String err;
        IOAgent ioAgent;
        block11: {
            ioAgent = this.interpreter.getIOAgent();
            err = null;
            this.setLastError(null);
            if (!this.interpreter.parseAndInvoke(line)) break block11;
            return true;
        }
        try {
            err = "command failed";
        }
        catch (TokenExpectedException e) {
            err = e.getMessage();
        }
        catch (InterpreterErrorExit e) {
            err = e.getMessage();
        }
        catch (BadTokenException e) {
            err = e.getMessage();
        }
        catch (ParseException e) {
            err = e.getMessage();
        }
        catch (InterpreterExit e) {
            err = e.getMessage();
        }
        catch (UndefinedStrategyException e) {
            err = e.getMessage();
        }
        catch (SGLRException e) {
            err = e.getMessage();
        }
        catch (InterpreterException e) {
            err = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
        }
        if (err != null) {
            ioAgent.printError(err);
            this.setLastError(err);
        }
        return false;
    }

    public int getSubtermCount() {
        return 0;
    }

    public IStrategoTerm getSubterm(int index) {
        throw new UnsupportedOperationException();
    }

    public IStrategoTerm[] getAllSubterms() {
        return AbstractTermFactory.EMPTY;
    }

    public int getTermType() {
        return 9;
    }

    public void prettyPrint(ITermPrinter pp) {
        pp.print(this.toString());
    }

    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.getClass().getName());
    }

    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        return second == this;
    }

    protected int hashFunction() {
        return System.identityHashCode(this);
    }
}

