/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.java;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractStrategoOperatorRegistry;
import org.spoofax.interpreter.library.java.GenericWrappedTerm;
import org.spoofax.interpreter.library.java.JFF_chmod_0_0;
import org.spoofax.interpreter.library.java.JFF_close_file_channel_0_0;
import org.spoofax.interpreter.library.java.JFF_find_class;
import org.spoofax.interpreter.library.java.JFF_find_primitive_type;
import org.spoofax.interpreter.library.java.JFF_flip_byte_buffer_0_0;
import org.spoofax.interpreter.library.java.JFF_get_constructor;
import org.spoofax.interpreter.library.java.JFF_get_method;
import org.spoofax.interpreter.library.java.JFF_invoke_method;
import org.spoofax.interpreter.library.java.JFF_make_byte_buffer_0_0;
import org.spoofax.interpreter.library.java.JFF_new_instance;
import org.spoofax.interpreter.library.java.JFF_open_file_channel_0_0;
import org.spoofax.interpreter.library.java.JFF_read_from_file_channel_0_0;
import org.spoofax.interpreter.library.java.JFF_write_to_file_channel_0_0;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.Term;

public class JFFLibrary
extends AbstractStrategoOperatorRegistry {
    public static final String REGISTRY_NAME = "JFI";
    private final ITermFactory termFactory;
    private final Map<Integer, Object> objectWrappers = new HashMap<Integer, Object>();
    private int objectCounter;
    private IStrategoConstructor objWrapCtor;

    public JFFLibrary(ITermFactory termFactory) {
        this.termFactory = termFactory;
        this.add(new JFF_close_file_channel_0_0());
        this.add(new JFF_flip_byte_buffer_0_0());
        this.add(new JFF_make_byte_buffer_0_0());
        this.add(new JFF_open_file_channel_0_0());
        this.add(new JFF_read_from_file_channel_0_0());
        this.add(new JFF_write_to_file_channel_0_0());
        this.add(new JFF_find_class());
        this.add(new JFF_find_primitive_type());
        this.add(new JFF_get_constructor());
        this.add(new JFF_get_method());
        this.add(new JFF_invoke_method());
        this.add(new JFF_new_instance());
        this.add(new JFF_chmod_0_0());
        this.init();
    }

    @Override
    public String getOperatorRegistryName() {
        return REGISTRY_NAME;
    }

    public static boolean invokeExceptionHandler(IContext ctx, Exception e) {
        throw new NotImplementedException();
    }

    public static <T> T fromTupleWrapped(IStrategoTerm current, int index, Class<T> clazz) {
        if (!(current instanceof IStrategoTuple)) {
            return null;
        }
        IStrategoTuple tuple = (IStrategoTuple)current;
        if (index >= tuple.getSubtermCount()) {
            return null;
        }
        if (!(tuple.get(index) instanceof GenericWrappedTerm)) {
            return null;
        }
        GenericWrappedTerm wrapper = (GenericWrappedTerm)tuple.get(index);
        if (wrapper.getWrappee().getClass().equals(clazz)) {
            return null;
        }
        return (T)wrapper.getWrappee();
    }

    public void init() {
        this.objectCounter = 0;
        this.objectWrappers.clear();
        this.objWrapCtor = this.termFactory.makeConstructor("ObjWrap", 1);
    }

    public static JFFLibrary instance(IContext env) {
        return (JFFLibrary)env.getOperatorRegistry(REGISTRY_NAME);
    }

    public IStrategoTerm wrapObject(Object obj) {
        int idx = this.objectCounter++;
        this.objectWrappers.put(idx, obj);
        return this.termFactory.makeAppl(this.objWrapCtor, this.termFactory.makeInt(idx));
    }

    public Object unwrapObject(IStrategoAppl term) {
        IStrategoTerm t = term.getSubterm(0);
        if (!Term.isTermInt(t)) {
            return null;
        }
        return this.objectWrappers.get(((IStrategoInt)t).intValue());
    }

    public Object unpackTerm(IStrategoTerm term) {
        switch (term.getTermType()) {
            case 3: {
                return ((IStrategoInt)term).intValue();
            }
            case 4: {
                return ((IStrategoReal)term).realValue();
            }
            case 5: {
                return ((IStrategoString)term).stringValue();
            }
            case 1: {
                return this.unwrapObject((IStrategoAppl)term);
            }
        }
        return null;
    }

    public static <T> T unwrap(IStrategoTerm[] tvars, int index, Class<T> clazz) {
        if (index >= tvars.length) {
            return null;
        }
        if (!(tvars[index] instanceof GenericWrappedTerm)) {
            return null;
        }
        GenericWrappedTerm t = (GenericWrappedTerm)tvars[index];
        if (!t.getWrappee().getClass().equals(clazz)) {
            return null;
        }
        return (T)t.getWrappee();
    }

    public static void attach(Interpreter intp) throws IOException, InterpreterException {
        JFFLibrary.attach(intp, new JFFLibrary(intp.getFactory()), "/share/jff-library.ctree");
    }
}

