/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractStrategoOperatorRegistry;
import org.spoofax.interpreter.library.jsglr.AbstractFilterSetting;
import org.spoofax.interpreter.library.jsglr.STRSGLR_anno_location;
import org.spoofax.interpreter.library.jsglr.STRSGLR_clear_parse_error;
import org.spoofax.interpreter.library.jsglr.STRSGLR_close_parse_table;
import org.spoofax.interpreter.library.jsglr.STRSGLR_get_parse_error;
import org.spoofax.interpreter.library.jsglr.STRSGLR_open_parse_table;
import org.spoofax.interpreter.library.jsglr.STRSGLR_parse_stream_pt;
import org.spoofax.interpreter.library.jsglr.STRSGLR_parse_string;
import org.spoofax.interpreter.library.jsglr.STRSGLR_parse_string_pt;
import org.spoofax.interpreter.library.jsglr.STRSGLR_recover_parse_string;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.Disambiguator;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.io.ParseTableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSGLRLibrary
extends AbstractStrategoOperatorRegistry {
    public static final String REGISTRY_NAME = "JSGLR";
    private ParseTableManager parseTableManager;
    private final Map<Integer, ParseTable> parseTables = new HashMap<Integer, ParseTable>();
    private final Map<IStrategoTerm, IStrategoInt> parseTableCache = new WeakHashMap<IStrategoTerm, IStrategoInt>();
    private final Disambiguator filterSettings = new Disambiguator();
    private final AtomicBoolean recoveryEnabled = new AtomicBoolean(false);

    public Disambiguator getFilterSettings() {
        return this.filterSettings;
    }

    public AtomicBoolean getRecoveryEnabledSetting() {
        return this.recoveryEnabled;
    }

    public JSGLRLibrary() {
        this.add(new STRSGLR_open_parse_table());
        this.add(new STRSGLR_parse_string_pt(this.filterSettings, this.recoveryEnabled));
        this.add(new STRSGLR_parse_string(this.filterSettings, this.recoveryEnabled));
        this.add(new STRSGLR_parse_stream_pt());
        this.add(new STRSGLR_recover_parse_string());
        this.add(new STRSGLR_get_parse_error());
        this.add(new STRSGLR_clear_parse_error());
        this.add(new STRSGLR_anno_location());
        this.add(new STRSGLR_close_parse_table());
        this.initFilterSettings();
    }

    private void initFilterSettings() {
        this.filterSettings.setFilterAny(true);
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_direct_eagernes_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterDirectPreference(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_direct_eagernes_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterDirectPreference(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_direct_eagernes"){

            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterDirectPreference();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_eagernes_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPreferenceCount(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_eagernes_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPreferenceCount(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_eagernes"){

            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterPreferenceCount();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_injection_count_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterInjectionCount(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_injection_count_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterInjectionCount(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_injection_count"){

            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterInjectionCount();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_priority_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPriorities(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_priority_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterPriorities(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_priority"){

            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterPriorities();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_reject_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterReject(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filter_reject_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterReject(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_filter_reject"){

            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getFilterReject();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_default_filters"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setDefaultFilters();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_recovery_on"){

            public void set() {
                JSGLRLibrary.this.recoveryEnabled.set(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_recovery_off"){

            public void set() {
                JSGLRLibrary.this.recoveryEnabled.set(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_recovery"){

            public boolean get() {
                return JSGLRLibrary.this.recoveryEnabled.get();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_default_config"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setDefaultFilters();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_ambiguity_error_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setAmbiguityIsError(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_ambiguity_error_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setAmbiguityIsError(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_ambiguity_error"){

            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getAmbiguityIsError();
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filtering_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterAny(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_filtering_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setFilterAny(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_log_statistics_on"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setLogStatistics(true);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_set_log_statistics_off"){

            public void set() {
                JSGLRLibrary.this.filterSettings.setLogStatistics(false);
            }
        });
        this.add(new AbstractFilterSetting(this.filterSettings, "STRSGLR_get_log_statistics"){

            public boolean get() {
                return JSGLRLibrary.this.filterSettings.getLogStatistics();
            }
        });
    }

    @Override
    public String getOperatorRegistryName() {
        return REGISTRY_NAME;
    }

    ParseTableManager getParseTableManager(ITermFactory factory) {
        if (this.parseTableManager == null) {
            this.parseTableManager = new ParseTableManager(factory);
        }
        return this.parseTableManager;
    }

    int addParseTable(ParseTable pt) {
        int idx = this.parseTables.size();
        this.parseTables.put(idx, pt);
        return idx;
    }

    ParseTable getParseTable(int idx) {
        return this.parseTables.get(idx);
    }

    Map<IStrategoTerm, IStrategoInt> getParseTableCache() {
        return this.parseTableCache;
    }

    public static void attach(Interpreter intp) throws IOException, InterpreterException {
        JSGLRLibrary.attach(intp, new JSGLRLibrary(), "share/libstratego-jsglr.ctree");
    }

    public void removeParseTable(int index) {
        this.parseTables.remove(index);
    }
}

