/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.util.Date;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.language.LANG_index_get_all_files;
import org.spoofax.interpreter.library.language.SemanticIndex;
import org.spoofax.interpreter.library.language.SemanticIndexFile;
import org.spoofax.interpreter.library.language.SemanticIndexManager;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class LANG_index_get_files_newer_than
extends AbstractPrimitive {
    private static String NAME = "LANG_index_get_files_newer_than";
    private final SemanticIndexManager index;

    public LANG_index_get_files_newer_than(SemanticIndexManager index) {
        super(NAME, 0, 1);
        this.index = index;
    }

    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        SemanticIndex ind = this.index.getCurrent();
        SemanticIndexFile file = ind.getFile(tvars[0]);
        if (file == null || file.getTime() == null) {
            env.setCurrent(LANG_index_get_all_files.getAllFiles(this.index.getCurrent(), env.getFactory()));
        } else {
            Date time = file.getTime();
            env.setCurrent(LANG_index_get_files_newer_than.getFilesAfter(env.getFactory(), ind, time));
        }
        return true;
    }

    private static IStrategoList getFilesAfter(ITermFactory factory, SemanticIndex ind, Date time) {
        IStrategoList results = factory.makeList();
        for (SemanticIndexFile file : ind.getAllFiles()) {
            if (file.getTime() == null || file.getTime().before(time)) continue;
            results = factory.makeListCons(file.toTerm(factory), results);
        }
        return results;
    }
}

