/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.library.language.INotificationService;

public class NotificationCenter {
    private static Map<ObserverDescription, INotificationService> asyncObservers = new HashMap<ObserverDescription, INotificationService>();

    public static synchronized void notifyFileChanges(URI file, String subfile) {
        assert (file.isAbsolute());
        for (INotificationService observer : asyncObservers.values()) {
            observer.notifyFileChanges(file, subfile);
        }
    }

    public static synchronized void notifyFileChanges(INotificationService.FileSubfile[] files) {
        if (files.length == 1) {
            INotificationService.FileSubfile file = files[0];
            NotificationCenter.notifyFileChanges(file.file, file.subfile);
            return;
        }
        INotificationService.FileSubfile[] fileSubfileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            INotificationService.FileSubfile file = fileSubfileArray[n2];
            assert (file.file.isAbsolute());
            ++n2;
        }
        for (INotificationService observer : asyncObservers.values()) {
            observer.notifyFileChanges(files);
        }
    }

    public static synchronized void notifyNewProject(URI project) {
        for (INotificationService observer : asyncObservers.values()) {
            observer.notifyNewProject(project);
        }
    }

    public static synchronized void putObserver(String language, String serviceName, INotificationService service) {
        asyncObservers.put(new ObserverDescription(language, serviceName), service);
    }

    public static synchronized boolean removeObserver(String language, String service) {
        return asyncObservers.remove(new ObserverDescription(language, service)) != null;
    }

    private static class ObserverDescription {
        final String language;
        final String service;

        public ObserverDescription(String language, String service) {
            this.language = language;
            this.service = service;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ObserverDescription)) {
                return false;
            }
            ObserverDescription other = (ObserverDescription)obj;
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            return !(this.service == null ? other.service != null : !this.service.equals(other.service));
        }
    }
}

