/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.SemanticIndexEntry;
import org.spoofax.interpreter.library.language.SemanticIndexEntryFactory;
import org.spoofax.interpreter.library.language.SemanticIndexEntryParent;
import org.spoofax.interpreter.library.language.SemanticIndexFile;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.Term;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.attachments.TermAttachmentSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticIndex {
    private final Map<SemanticIndexEntry, SemanticIndexEntry> table = new HashMap<SemanticIndexEntry, SemanticIndexEntry>();
    private final Map<SemanticIndexFile, SemanticIndexFile> files = new HashMap<SemanticIndexFile, SemanticIndexFile>();
    private static final IStrategoConstructor FILE_ENTRIES_CON = new TermFactory().makeConstructor("FileEntries", 2);
    private IOAgent agent;
    private AtomicLong revisionProvider;
    private ITermFactory termFactory;
    private SemanticIndexEntryFactory factory;
    private SemanticIndexEntry entryTemplate;

    public void initialize(ITermFactory factory, IOAgent agent, AtomicLong revisionProvider) {
        this.agent = agent;
        this.factory = new SemanticIndexEntryFactory(factory);
        this.termFactory = factory;
        this.revisionProvider = revisionProvider;
        this.entryTemplate = new SemanticIndexEntry(factory.makeConstructor("template", 0), factory.makeList(), factory.makeList(), null, null, null);
    }

    public void ensureInitialized() {
        if (this.factory == null) {
            throw new IllegalStateException("Semantic index not initialized");
        }
    }

    public SemanticIndexEntryFactory getFactory() {
        return this.factory;
    }

    public void add(IStrategoAppl entry, SemanticIndexFile file) {
        assert (this.getFile(file) == file) : "Files must be maximally shared: use getFile() to get a shared File reference";
        this.ensureInitialized();
        IStrategoTerm contentsType = this.factory.getEntryContentsType(entry);
        IStrategoList id = this.factory.getEntryId(entry);
        IStrategoTerm namespace = this.factory.getEntryNamespace(entry);
        IStrategoTerm contents = this.factory.getEntryContents(entry);
        SemanticIndexEntryParent parent = this.getEntryParentAbove(namespace, id, true);
        this.add(this.factory.createEntry(entry.getConstructor(), namespace, id, contentsType, contents, parent, file), parent);
    }

    public void addAll(IStrategoList entries, SemanticIndexFile file) {
        while (!entries.isEmpty()) {
            this.add((IStrategoAppl)entries.head(), file);
            entries = entries.tail();
        }
    }

    public void add(SemanticIndexEntry entry) {
        this.ensureInitialized();
        this.add(entry, this.getEntryParentAbove(entry.getNamespace(), entry.getId(), true));
    }

    private void add(SemanticIndexEntry entry, SemanticIndexEntryParent parent) {
        SemanticIndexEntry existing;
        if (parent != null) {
            parent.add(entry);
        }
        if ((existing = this.table.get(entry)) == null) {
            this.table.put(entry, entry);
            if (entry.getFile() != null) {
                entry.getFile().addEntry(entry);
            }
        } else {
            assert (!entry.isParent() && existing != entry);
            assert (!existing.isReferenceInTail(entry));
            existing.getLast().setNext(entry);
            if (entry.getFile() != null) {
                entry.getFile().addEntry(entry);
            }
        }
        if (entry.getFile() != null) {
            entry.getFile().setTimeRevision(new Date(), this.revisionProvider.incrementAndGet());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void remove(SemanticIndexEntry entry) {
        block10: {
            existing = this.table.get(entry);
            if (existing == null) {
                return;
            }
            if (existing != entry) ** GOTO lbl12
            this.table.remove(entry);
            if (entry.getNext() == null) break block10;
            this.table.put(entry.getNext(), entry.getNext());
            break block10;
lbl-1000:
            // 1 sources

            {
                existing = existing.getNext();
lbl12:
                // 2 sources

                ** while (existing != null && existing.getNext() != entry)
            }
lbl13:
            // 1 sources

            if (existing == null) {
                if (!SemanticIndex.$assertionsDisabled) {
                    throw new AssertionError();
                }
                return;
            }
            existing.setNext(entry.getNext());
            if (!SemanticIndex.$assertionsDisabled && existing.isReferenceInTail(entry)) {
                throw new AssertionError();
            }
        }
        if ((parent = this.getEntryParentAbove(entry.getNamespace(), entry.getId(), false)) != null) {
            parent.remove(entry);
        }
        if ((file = entry.getFile()) != null) {
            file.removeEntry(entry);
            entry.getFile().setTimeRevision(new Date(), this.revisionProvider.incrementAndGet());
        }
    }

    public SemanticIndexFile getFile(IStrategoTerm fileTerm) {
        return this.getFile(SemanticIndexFile.fromTerm(this.agent, fileTerm));
    }

    private SemanticIndexFile getFile(SemanticIndexFile file) {
        SemanticIndexFile result = this.files.get(file);
        if (result == null) {
            result = file;
            this.files.put(file, file);
        }
        return result;
    }

    public SemanticIndexEntry getEntries(IStrategoAppl template) {
        this.ensureInitialized();
        return this.getEntries(template.getConstructor(), this.factory.getEntryNamespace(template), this.factory.getEntryId(template), this.factory.getEntryContentsType(template));
    }

    private SemanticIndexEntry getEntries(IStrategoConstructor constructor, IStrategoTerm namespace, IStrategoList id, IStrategoTerm contentsType) {
        this.entryTemplate.internalReinit(constructor, namespace, id, contentsType);
        return this.table.get(this.entryTemplate);
    }

    public IStrategoList getEntryChildTerms(IStrategoAppl template) {
        this.ensureInitialized();
        IStrategoConstructor constructor = template.getConstructor();
        IStrategoTerm namespace = this.factory.getEntryNamespace(template);
        SemanticIndexEntryParent parent = this.getEntryParentAt(namespace, this.factory.getEntryId(template));
        if (parent == null) {
            return this.termFactory.makeList();
        }
        if (constructor == this.factory.getDefCon() && parent.getAllDefsCached() != null) {
            return parent.getAllDefsCached();
        }
        IStrategoList results = this.termFactory.makeList();
        for (SemanticIndexEntry entry : parent.getChildren()) {
            if (entry.getConstructor() != constructor) continue;
            assert (!entry.isParent());
            assert (entry.getNamespace().match(namespace));
            results = this.termFactory.makeListCons(entry.toTerm(this.factory.getTermFactory()), results);
        }
        if (constructor == this.factory.getDefCon()) {
            parent.setAllDefsCached(results);
        }
        return results;
    }

    public IStrategoList getEntryDescendantTerms(IStrategoAppl template) {
        this.ensureInitialized();
        IStrategoConstructor constructor = template.getConstructor();
        IStrategoTerm namespace = this.factory.getEntryNamespace(template);
        SemanticIndexEntryParent parent = this.getEntryParentAt(namespace, this.factory.getEntryId(template));
        return this.collectEntryDescendentTerms(parent, constructor, namespace, this.termFactory.makeList());
    }

    private IStrategoList collectEntryDescendentTerms(SemanticIndexEntryParent parent, IStrategoConstructor constructor, IStrategoTerm namespace, IStrategoList results) {
        for (SemanticIndexEntry entry : parent.getChildren()) {
            if (entry.getConstructor() == constructor) {
                assert (!entry.isParent());
                assert (entry.getNamespace().match(namespace));
                results = this.termFactory.makeListCons(entry.toTerm(this.factory.getTermFactory()), results);
                continue;
            }
            if (!entry.isParent()) continue;
            results = this.collectEntryDescendentTerms((SemanticIndexEntryParent)entry, constructor, namespace, results);
        }
        return results;
    }

    private SemanticIndexEntryParent getEntryParentAbove(IStrategoTerm namespace, IStrategoList id, boolean createNonExistant) {
        if (id.isEmpty()) {
            return null;
        }
        SemanticIndexEntryParent result = this.getEntryParentAt(namespace, id = id.tail());
        if (result == null && createNonExistant) {
            result = this.factory.createEntryParent(namespace, id, this.getEntryParentAbove(namespace, id, true));
            this.add(result);
        }
        return result;
    }

    private SemanticIndexEntryParent getEntryParentAt(IStrategoTerm namespace, IStrategoList id) {
        return (SemanticIndexEntryParent)this.getEntries(SemanticIndexEntryParent.CONSTRUCTOR, namespace, id, null);
    }

    public void clear() {
        this.table.clear();
        this.files.clear();
    }

    public IStrategoTerm toTerm(boolean includePositions) {
        ITermFactory terms = this.factory.getTermFactory();
        IStrategoList results = terms.makeList();
        for (SemanticIndexFile file : this.files.keySet()) {
            IStrategoList fileResults = SemanticIndexEntry.toTerms(terms, file.getEntries(), false);
            IStrategoAppl result = terms.makeAppl(FILE_ENTRIES_CON, file.toTerm(terms), fileResults);
            results = terms.makeListCons(result, results);
        }
        if (includePositions) {
            TermFactory simpleFactory = new TermFactory();
            TermAttachmentSerializer serializer = new TermAttachmentSerializer(simpleFactory);
            results = (IStrategoList)serializer.toAnnotations(results);
        }
        return results;
    }

    public static SemanticIndex fromTerm(IStrategoTerm term, ITermFactory factory, IOAgent agent, boolean extractPositions) throws IOException {
        if (extractPositions) {
            TermAttachmentSerializer serializer = new TermAttachmentSerializer(factory);
            term = (IStrategoList)serializer.fromAnnotations(term, false);
        }
        if (Tools.isTermList(term)) {
            SemanticIndex result = new SemanticIndex();
            result.initialize(factory, agent, new AtomicLong());
            IStrategoList list = (IStrategoList)term;
            while (!list.isEmpty()) {
                result.loadFileEntriesTerm(list.head());
                list = list.tail();
            }
            return result;
        }
        throw new IOException("Expected list of " + FILE_ENTRIES_CON.getName());
    }

    private void loadFileEntriesTerm(IStrategoTerm fileEntries) throws IOException {
        if (Term.tryGetConstructor(fileEntries) == FILE_ENTRIES_CON) {
            try {
                SemanticIndexFile file = this.getFile((IStrategoTerm)Term.termAt(fileEntries, 0));
                this.addAll((IStrategoList)Term.termAt(fileEntries, 1), file);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e);
            }
            catch (RuntimeException e) {
                throw new IOException("Unexpected exception reading index: " + e);
            }
        } else {
            throw new IOException("Illegal index entry: " + fileEntries);
        }
    }

    public void clear(SemanticIndexFile file) {
        SemanticIndexEntry[] copy;
        assert (this.files.get(file) == null || this.files.get(file) == file);
        List<SemanticIndexEntry> entries = file.getEntries();
        if (entries.isEmpty()) {
            return;
        }
        SemanticIndexEntry[] semanticIndexEntryArray = copy = entries.toArray(new SemanticIndexEntry[entries.size()]);
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticIndexEntry entry = semanticIndexEntryArray[n2];
            assert (this.table.get(entry) != null);
            this.remove(entry);
            ++n2;
        }
        assert (file.getEntries().isEmpty());
    }

    public Collection<SemanticIndexFile> getAllFiles() {
        return this.files.values();
    }

    public String toString() {
        return this.files.keySet().toString();
    }
}

