/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import org.spoofax.interpreter.library.language.SemanticIndexEntryParent;
import org.spoofax.interpreter.library.language.SemanticIndexFile;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticIndexEntry {
    private IStrategoConstructor constructor;
    private IStrategoTerm namespace;
    private IStrategoList id;
    private IStrategoTerm contentsType;
    private IStrategoTerm contents;
    private SemanticIndexFile file;
    private SemanticIndexEntry next = null;
    private transient IStrategoAppl term;

    protected SemanticIndexEntry(IStrategoConstructor constructor, IStrategoTerm namespace, IStrategoList id, IStrategoTerm contentsType, IStrategoTerm contents, SemanticIndexFile file) {
        this.constructor = constructor;
        this.id = id;
        this.namespace = namespace;
        this.contentsType = contentsType;
        this.contents = contents;
        this.file = file;
        assert (constructor != null && id != null && namespace != null);
        assert (contents != null || constructor.getArity() < 2) : "Contents can't be null for Use/2 or DefData/3";
        assert (contentsType == null || "DefData".equals(constructor.getName())) : "Contents type only expected for DefData";
        assert (constructor != SemanticIndexEntryParent.CONSTRUCTOR || this instanceof SemanticIndexEntryParent);
    }

    public IStrategoConstructor getConstructor() {
        return this.constructor;
    }

    public IStrategoTerm getType() {
        return this.contentsType;
    }

    public IStrategoList getId() {
        return this.id;
    }

    public IStrategoTerm getNamespace() {
        return this.namespace;
    }

    public IStrategoTerm getContents() {
        return this.contents;
    }

    public SemanticIndexFile getFile() {
        return this.file;
    }

    public SemanticIndexEntry getNext() {
        return this.next;
    }

    public final SemanticIndexEntry getLast() {
        SemanticIndexEntry result = this;
        while (result.getNext() != null) {
            result = result.getNext();
        }
        return result;
    }

    public boolean isParent() {
        return this.constructor == SemanticIndexEntryParent.CONSTRUCTOR;
    }

    public void setNext(SemanticIndexEntry next) {
        this.next = next;
    }

    boolean isReferenceInTail(SemanticIndexEntry entry) {
        SemanticIndexEntry tail = this;
        while (tail != null) {
            if (entry == tail) {
                return true;
            }
            tail = tail.getNext();
        }
        return false;
    }

    protected void internalReinit(IStrategoConstructor constructor, IStrategoTerm namespace, IStrategoList id, IStrategoTerm contentsType) {
        this.constructor = constructor;
        this.contentsType = contentsType;
        this.namespace = namespace;
        this.id = id;
    }

    public IStrategoAppl toTerm(ITermFactory factory) {
        if (this.term != null) {
            return this.term;
        }
        IStrategoList namespaceId = factory.makeListCons(this.namespace, this.id);
        this.term = this.constructor.getArity() == 3 ? factory.makeAppl(this.constructor, namespaceId, this.contentsType, this.contents) : (this.constructor.getArity() == 2 ? factory.makeAppl(this.constructor, namespaceId, this.contents) : factory.makeAppl(this.constructor, namespaceId));
        return this.forceImploderAttachment(this.term);
    }

    public final IStrategoList toTerms(ITermFactory factory) {
        IStrategoList results = factory.makeList();
        return this.toTerms(factory, results, true);
    }

    protected IStrategoList toTerms(ITermFactory factory, IStrategoList results, boolean lookAtNext) {
        SemanticIndexEntry entry = this;
        while (entry != null) {
            IStrategoAppl result = entry.toTerm(factory);
            if (result != null) {
                results = factory.makeListCons(result, results);
            }
            if (!lookAtNext) break;
            entry = entry.getNext();
        }
        return results;
    }

    public static IStrategoList toTerms(ITermFactory factory, Iterable<SemanticIndexEntry> entries, boolean lookAtNext) {
        IStrategoList results = factory.makeList();
        for (SemanticIndexEntry entry : entries) {
            results = entry.toTerms(factory, results, lookAtNext);
        }
        return results;
    }

    private IStrategoAppl forceImploderAttachment(IStrategoAppl term) {
        ImploderAttachment attach = ImploderAttachment.get(this.id);
        if (attach != null) {
            ImploderAttachment.putImploderAttachment(term, false, attach.getSort(), attach.getLeftToken(), attach.getRightToken());
        } else {
            String fn = this.file == null ? null : this.file.getURI().getPath();
            attach = ImploderAttachment.createCompactPositionAttachment(fn, 0, 0, 0, -1);
            term.putAttachment(attach);
        }
        return term;
    }

    public String toString() {
        String result = String.valueOf(this.constructor.getName()) + "([" + this.namespace + "|" + this.id + "]";
        if (this.contentsType != null) {
            result = String.valueOf(result) + "," + this.contentsType;
        }
        if (this.contents != null) {
            result = String.valueOf(result) + "," + this.contents;
        }
        return String.valueOf(result) + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.contentsType == null ? 0 : this.contentsType.hashCode());
        result = 31 * result + this.namespace.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticIndexEntry)) {
            return false;
        }
        SemanticIndexEntry other = (SemanticIndexEntry)obj;
        if (this.constructor != other.constructor && !this.constructor.match(other.constructor)) {
            return false;
        }
        if (this.namespace != other.namespace && !this.namespace.match(other.namespace)) {
            return false;
        }
        if (this.contentsType != other.contentsType && this.contentsType != null && !this.contentsType.match(other.contentsType)) {
            return false;
        }
        return this.id == other.id || this.id.match(other.id);
    }
}

