/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.language.SemanticIndexEntry;
import org.spoofax.interpreter.library.language.SemanticIndexEntryParent;
import org.spoofax.interpreter.library.language.SemanticIndexFile;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.attachments.TermAttachmentStripper;

public class SemanticIndexEntryFactory {
    private static final int DEFDATA_URI = 0;
    private static final int DEFDATA_TYPE = 1;
    private static final int DEFDATA_CONTENTS = 2;
    private final ITermFactory termFactory;
    private final TermAttachmentStripper stripper;
    private final IStrategoConstructor defCon;
    private final IStrategoConstructor defDataCon;

    public SemanticIndexEntryFactory(ITermFactory termFactory) {
        this.termFactory = termFactory;
        this.stripper = new TermAttachmentStripper(termFactory);
        this.defCon = termFactory.makeConstructor("Def", 1);
        this.defDataCon = termFactory.makeConstructor("DefData", 3);
    }

    public ITermFactory getTermFactory() {
        return this.termFactory;
    }

    public IStrategoConstructor getDefDataCon() {
        return this.defDataCon;
    }

    public IStrategoConstructor getDefCon() {
        return this.defCon;
    }

    public SemanticIndexEntry createEntry(IStrategoConstructor constructor, IStrategoTerm namespace, IStrategoList id, IStrategoTerm contentsType, IStrategoTerm contents, SemanticIndexEntryParent parent, SemanticIndexFile file) {
        ImploderAttachment idAttachment = ImploderAttachment.getCompactPositionAttachment(id, true);
        ImploderAttachment dataAttachment = contents == null ? null : ImploderAttachment.getCompactPositionAttachment(contents, false);
        id = this.createSanitizedId(id, parent);
        contents = this.stripper.strip(contents);
        contentsType = this.stripper.strip(contentsType);
        assert (namespace == this.stripper.strip(namespace));
        id.putAttachment(idAttachment);
        if (contents != null) {
            contents.putAttachment(dataAttachment);
        }
        return new SemanticIndexEntry(constructor, namespace, id, contentsType, contents, file);
    }

    private IStrategoList createSanitizedId(IStrategoList id, SemanticIndexEntryParent parent) {
        if (parent != null) {
            return this.termFactory.makeListCons(this.stripper.strip(id.head()), parent.getId());
        }
        return (IStrategoList)this.stripper.strip(id);
    }

    public SemanticIndexEntryParent createEntryParent(IStrategoTerm namespace, IStrategoList id, SemanticIndexEntryParent parent) {
        assert (namespace == this.stripper.strip(namespace));
        id = this.createSanitizedId(id, parent);
        return new SemanticIndexEntryParent(namespace, id);
    }

    public IStrategoTerm getEntryContentsType(IStrategoAppl entry) {
        IStrategoConstructor type = entry.getConstructor();
        if (type == this.defDataCon) {
            return entry.getSubterm(1);
        }
        return null;
    }

    public IStrategoList getEntryId(IStrategoAppl entry) {
        IStrategoTerm result = entry.getSubterm(0);
        if (Tools.isTermList(result)) {
            IStrategoList full = (IStrategoList)result;
            return full.isEmpty() ? full : full.tail();
        }
        throw new IllegalArgumentException("Illegal index entry: " + entry);
    }

    public IStrategoTerm getEntryNamespace(IStrategoAppl entry) {
        IStrategoTerm result = entry.getSubterm(0);
        if (Tools.isTermList(result)) {
            IStrategoList full = (IStrategoList)result;
            return this.stripper.strip(full.isEmpty() ? full : full.head());
        }
        throw new IllegalArgumentException("Illegal index entry: " + entry);
    }

    public IStrategoTerm getEntryContents(IStrategoAppl entry) {
        if (entry.getSubtermCount() == 3) {
            return entry.getSubterm(2);
        }
        if (entry.getSubtermCount() == 2) {
            return entry.getSubterm(1);
        }
        assert (entry.getSubtermCount() < 3);
        return null;
    }
}

