/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.SemanticIndexEntry;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticIndexFile {
    private final List<SemanticIndexEntry> entries = new ArrayList<SemanticIndexEntry>();
    private final URI uri;
    private final String descriptor;
    private Date time;
    private long revision;

    public URI getURI() {
        return this.uri;
    }

    public Date getTime() {
        return this.time;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public List<SemanticIndexEntry> getEntries() {
        boolean assertionsOn = false;
        if (!$assertionsDisabled) {
            assertionsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionsOn) {
            return Collections.unmodifiableList(this.entries);
        }
        return this.entries;
    }

    public void addEntry(SemanticIndexEntry entry) {
        this.entries.add(entry);
    }

    public void removeEntry(SemanticIndexEntry entry) {
        int i = 0;
        while (i < this.entries.size()) {
            if (this.entries.get(i) == entry) {
                this.entries.remove(i);
                return;
            }
            ++i;
        }
    }

    public void setTimeRevision(Date time, long revision) {
        this.time = time;
    }

    protected SemanticIndexFile(URI uri, String descriptor, Date time) {
        this.uri = uri;
        this.descriptor = "".equals(descriptor) ? null : descriptor;
        this.time = time;
    }

    public static SemanticIndexFile fromTerm(IOAgent agent, IStrategoTerm term) {
        String descriptor;
        String name;
        if (Tools.isTermTuple(term)) {
            name = Tools.asJavaString(term.getSubterm(0));
            descriptor = Tools.asJavaString(term.getSubterm(1));
        } else {
            name = Tools.asJavaString(term);
            descriptor = null;
        }
        File file = new File(name);
        if (!file.isAbsolute() && agent != null) {
            file = new File(agent.getWorkingDir(), name);
        }
        return new SemanticIndexFile(file.toURI(), descriptor, null);
    }

    public String toString() {
        return "file".equals(this.uri.getScheme()) ? new File(this.uri).getAbsolutePath().replace("\\", "/") : this.uri.toString();
    }

    public IStrategoTerm toTerm(ITermFactory factory) {
        IStrategoString uriString = factory.makeString(this.toString());
        IStrategoString descriptorName = factory.makeString(this.descriptor == null ? "" : this.descriptor);
        return factory.makeTuple(uriString, descriptorName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SemanticIndexFile) {
            if (obj == this) {
                return true;
            }
            SemanticIndexFile other = (SemanticIndexFile)obj;
            return other.uri.equals(this.uri) && (this.descriptor == null ? other.descriptor == null : this.descriptor.equals(other.descriptor));
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }
}

