/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.NotificationCenter;
import org.spoofax.interpreter.library.language.SemanticIndex;
import org.spoofax.interpreter.library.language.SemanticIndexFile;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.io.binary.TermReader;

public class SemanticIndexManager {
    private final AtomicLong revisionProvider = new AtomicLong();
    private SemanticIndex current;
    private URI currentProject;
    private String currentLanguage;
    private SemanticIndexFile currentFile;
    private static Map<String, Map<URI, WeakReference<SemanticIndex>>> asyncIndexCache = new HashMap<String, Map<URI, WeakReference<SemanticIndex>>>();

    public SemanticIndex getCurrent() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("No semantic index has been set-up, use index-setup(|language, project-paths) to set up the index before use.");
        }
        return this.current;
    }

    public SemanticIndexFile getCurrentFile() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("No semantic index has been set-up, use index-setup(|language, project-paths) to set up the index before use.");
        }
        return this.currentFile;
    }

    public void setCurrentFile(SemanticIndexFile currentFile) {
        this.currentFile = currentFile;
    }

    private static Object getSyncRoot() {
        return SemanticIndexManager.class;
    }

    public AtomicLong getRevisionProvider() {
        return this.revisionProvider;
    }

    public boolean isInitialized() {
        return this.current != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKnownIndexingLanguage(String language) {
        Object object = SemanticIndexManager.getSyncRoot();
        synchronized (object) {
            return asyncIndexCache.containsKey(language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIndex(String language, URI project, ITermFactory factory, IOAgent agent) {
        Object object = SemanticIndexManager.getSyncRoot();
        synchronized (object) {
            WeakReference<SemanticIndex> indexRef;
            SemanticIndex index;
            Map<URI, WeakReference<SemanticIndex>> indicesByProject = asyncIndexCache.get(language);
            if (indicesByProject == null) {
                indicesByProject = new HashMap<URI, WeakReference<SemanticIndex>>();
                asyncIndexCache.put(language, indicesByProject);
            }
            SemanticIndex semanticIndex = index = (indexRef = indicesByProject.get(project)) == null ? null : (SemanticIndex)indexRef.get();
            if (index == null) {
                index = this.tryReadFromFile(this.getIndexFile(project, language), factory, agent);
            }
            if (index == null) {
                index = new SemanticIndex();
                NotificationCenter.notifyNewProject(project);
            }
            indicesByProject.put(project, new WeakReference<SemanticIndex>(index));
            this.current = index;
            this.currentLanguage = language;
            this.currentProject = project;
        }
    }

    public SemanticIndex tryReadFromFile(File file, ITermFactory factory, IOAgent agent) {
        try {
            IStrategoTerm term = new TermReader(factory).parseFromFile(file.toString());
            return SemanticIndex.fromTerm(term, factory, agent, true);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void storeCurrent() throws IOException {
        File file = this.getIndexFile(this.currentProject, this.currentLanguage);
        IStrategoTerm stored = this.getCurrent().toTerm(true);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            stored.writeAsString(writer, Integer.MAX_VALUE);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private File getIndexFile(URI project, String language) {
        File container = new File(new File(project), ".cache");
        container.mkdirs();
        return new File(container, String.valueOf(language) + ".idx");
    }
}

