/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.library.language.SemanticIndex;
import org.spoofax.interpreter.library.language.SemanticIndexEntry;
import org.spoofax.interpreter.library.language.SemanticIndexFile;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticIndexStatistics {
    private SemanticIndex index;

    public SemanticIndexStatistics(SemanticIndex index) {
        this.index = index;
    }

    private Collection<SemanticIndexFile> files() {
        return this.index.getAllFiles();
    }

    private Collection<SemanticIndexEntry> elements() {
        ArrayList<SemanticIndexEntry> entries = new ArrayList<SemanticIndexEntry>();
        for (SemanticIndexFile file : this.index.getAllFiles()) {
            entries.addAll(file.getEntries());
        }
        return entries;
    }

    public Data stats() {
        Data data = new Data();
        data.files = this.files();
        data.entries = this.elements();
        data.entriesPerConstructor = new HashMap<IStrategoConstructor, Integer>();
        data.entriesPerNamespace = new HashMap<IStrategoTerm, Integer>();
        for (SemanticIndexEntry entry : data.entries) {
            Integer constructorCount = data.entriesPerConstructor.get(entry.getConstructor());
            if (constructorCount == null) {
                data.entriesPerConstructor.put(entry.getConstructor(), 1);
            } else {
                data.entriesPerConstructor.put(entry.getConstructor(), constructorCount + 1);
            }
            Integer namespaceCount = data.entriesPerNamespace.get(entry.getNamespace());
            if (namespaceCount == null) {
                data.entriesPerNamespace.put(entry.getNamespace(), 1);
                continue;
            }
            data.entriesPerNamespace.put(entry.getNamespace(), namespaceCount + 1);
        }
        return data;
    }

    public String statsString() {
        Data data = this.stats();
        StringBuilder b = new StringBuilder();
        b.append("* Number of files: " + data.files.size() + "\n");
        b.append("* Number of elements: " + data.entries.size() + "\n");
        b.append("* Elements per constructor: \n");
        for (Map.Entry<IStrategoConstructor, Integer> entry : data.entriesPerConstructor.entrySet()) {
            b.append("  - " + entry.getKey() + ": " + entry.getValue() + "\n");
        }
        b.append("* Elements per namespace: \n");
        for (Map.Entry<IStrategoTerm, Integer> entry : data.entriesPerNamespace.entrySet()) {
            b.append("  - " + entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return b.toString();
    }

    public void printStats() {
        System.out.println(this.statsString());
    }

    private class Data {
        public Collection<SemanticIndexFile> files;
        public Collection<SemanticIndexEntry> entries;
        public Map<IStrategoConstructor, Integer> entriesPerConstructor;
        public Map<IStrategoTerm, Integer> entriesPerNamespace;

        private Data() {
        }
    }
}

