/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang;

import java.io.File;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndex;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.attachments.OriginAttachment;

public class SPX_symtab_verify_symbols_have_equal_origin
extends AbstractPrimitive {
    private static String NAME = "SPX_symtab_verify_symbols_have_equal_origin";
    private static final int NO_ARGS = 2;

    public SPX_symtab_verify_symbols_have_equal_origin(SpxSemanticIndex index) {
        super(NAME, 0, 2);
    }

    public final boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        IStrategoTerm tvar1 = tvars[0];
        IStrategoTerm tvar2 = tvars[1];
        return SPX_symtab_verify_symbols_have_equal_origin.equal(tvar1, tvar2);
    }

    private static boolean equal(IStrategoTerm t1, IStrategoTerm t2) {
        ImploderAttachment origin1 = ImploderAttachment.get(OriginAttachment.tryGetOrigin(t1));
        if (origin1 == null) {
            return false;
        }
        if (t1 == t2) {
            return true;
        }
        ImploderAttachment origin2 = ImploderAttachment.get(OriginAttachment.tryGetOrigin(t2));
        return SPX_symtab_verify_symbols_have_equal_origin.verifyOriginsAreEqual(origin1, origin2);
    }

    private static boolean verifyOriginsAreEqual(ImploderAttachment attachment, ImploderAttachment otherAttachment) {
        if (attachment == otherAttachment) {
            return true;
        }
        if (attachment == null || otherAttachment == null) {
            return false;
        }
        IToken leftToken = attachment.getLeftToken();
        IToken otherLeftToken = otherAttachment.getLeftToken();
        if (leftToken == null || otherLeftToken == null) {
            return false;
        }
        if (leftToken.getLine() != otherLeftToken.getLine() || leftToken.getColumn() != otherLeftToken.getColumn() || leftToken.getStartOffset() != otherLeftToken.getStartOffset()) {
            return false;
        }
        IToken rightToken = attachment.getRightToken();
        IToken otherRightToken = otherAttachment.getRightToken();
        if (rightToken == null || otherRightToken == null) {
            return false;
        }
        if (rightToken.getEndOffset() != otherRightToken.getEndOffset()) {
            return false;
        }
        String fileLocation = leftToken.getTokenizer().getFilename();
        String otherFileLocation = otherLeftToken.getTokenizer().getFilename();
        if (fileLocation != null ? otherFileLocation == null : otherFileLocation != null) {
            return false;
        }
        if (fileLocation == null && otherFileLocation == null) {
            return false;
        }
        return new File(fileLocation).getAbsolutePath().equalsIgnoreCase(new File(otherFileLocation).getAbsolutePath());
    }
}

