/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndex;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacadeRegistry;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;

public abstract class SpxAbstractPrimitive
extends AbstractPrimitive {
    private static final int PROJECT_PATH_INDEX = 0;
    protected final SpxSemanticIndex index;

    public SpxAbstractPrimitive(SpxSemanticIndex index, String name, int svars, int tvars) {
        super(name, svars, tvars);
        this.index = index;
    }

    protected IStrategoString getProjectPath(IStrategoTerm[] tvars) {
        return (IStrategoString)tvars[0];
    }

    protected SpxPrimitiveValidator validateArguments(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        return SpxPrimitiveValidator.newValidator().validatePrimitive(this.getName()).with(env, tvars).validateArity(this.getTArity()).validateStringTermAt(0);
    }

    protected abstract boolean executePrimitive(IContext var1, Strategy[] var2, IStrategoTerm[] var3) throws Exception;

    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        boolean successStatement = false;
        IOAgent agent = SSLLibrary.instance(env).getIOAgent();
        String projectPath = Tools.asJavaString(this.getProjectPath(tvars));
        try {
            this.validateArguments(env, svars, tvars);
            successStatement = this.executePrimitive(env, svars, tvars);
        }
        catch (Exception ex) {
            if (!(ex instanceof SpxSymbolTableException)) {
                this.logException(projectPath, agent, ex);
            }
            if (ex instanceof IOException || ex instanceof IllegalStateException) {
                this.tryCleanupResources(this.index.getFacadeRegistry(), this.getProjectPath(tvars), agent);
            }
        }
        catch (Error e) {
            this.logException(projectPath, agent, e);
            this.tryCleanupResources(this.index.getFacadeRegistry(), this.getProjectPath(tvars), agent);
            throw e;
        }
        return successStatement;
    }

    void tryCleanupResources(SpxSemanticIndexFacadeRegistry registry, IStrategoTerm projectPath, IOAgent agent) {
        if (registry.containsFacade(projectPath)) {
            SpxSemanticIndexFacade facade = null;
            try {
                facade = registry.getFacade(projectPath);
                if (facade != null) {
                    facade.clearCache();
                    facade.close(false);
                }
            }
            catch (Exception e) {
                this.logMessage(agent, "Cleanup Failed due to error :" + e.getMessage());
            }
            catch (Error e) {
                this.logMessage(agent, "Cleanup Failed due to error :" + e.getMessage());
            }
        }
    }

    void logMessage(IOAgent agent, String message) {
        agent.printError("[" + this.getName() + "] " + message);
    }

    void logException(String projectPath, IOAgent agent, Throwable ex) {
        agent.printError("[" + this.getName() + "]  Invocation failed for following project : " + projectPath + ". " + ex.getClass().getSimpleName() + " | error message: " + ex.getMessage() + " | stack track : " + SpxAbstractPrimitive.getStackTrace(ex));
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        if (aThrowable == null) {
            return "";
        }
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    static class SpxPrimitiveValidator {
        IContext env;
        IStrategoTerm[] tvars;
        String primitiveName;

        static SpxPrimitiveValidator newValidator() {
            return new SpxPrimitiveValidator();
        }

        private SpxPrimitiveValidator() {
        }

        SpxPrimitiveValidator validatePrimitive(String primitiveName) {
            this.primitiveName = primitiveName;
            return this;
        }

        SpxPrimitiveValidator with(IContext env, IStrategoTerm[] tvars) {
            this.env = env;
            this.tvars = tvars;
            return this;
        }

        SpxPrimitiveValidator validateArity(int expectedArity) {
            if (expectedArity != this.tvars.length) {
                this.throwException("Mismatch in argument arity. Expected " + expectedArity + "actual" + this.tvars.length);
            }
            return this;
        }

        SpxPrimitiveValidator validateStringTermAt(int ordinal) {
            if (!Tools.isTermString(this.tvars[ordinal])) {
                this.throwException("Illegal Arugments. Expected IStrategoString [TermString] at ordinal " + ordinal + "actual" + this.tvars[ordinal]);
            }
            return this;
        }

        SpxPrimitiveValidator validateListTermAt(int ordinal) {
            if (!Tools.isTermList(this.tvars[ordinal])) {
                this.throwException("Illegal Arugments. Expected  [TermList] at ordinal : " + ordinal + "actual : " + this.tvars[ordinal]);
            }
            return this;
        }

        SpxPrimitiveValidator validateApplTermAt(int ordinal) {
            if (!Tools.isTermAppl(this.tvars[ordinal])) {
                this.throwException("Illegal Arugments. Expected  [TermAppl] at ordinal : " + ordinal + "actual : " + this.tvars[ordinal]);
            }
            return this;
        }

        SpxPrimitiveValidator validateTupleTermAt(int ordinal) {
            if (!Tools.isTermTuple(this.tvars[ordinal])) {
                this.throwException("Illegal Arugments. Expected  [TermTuple] at ordinal : " + ordinal + "actual : " + this.tvars[ordinal]);
            }
            return this;
        }

        void throwException(String errorMessage) {
            SSLLibrary.instance(this.env).getIOAgent().printError("[" + this.primitiveName + "] " + "Error Occured during Argument Validation : " + errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

