/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespaceResolver;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.NamespaceUri;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolKey;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableEntry;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseNamespace
implements INamespace {
    private static final long serialVersionUID = 2052337390283813190L;
    protected final String src;
    private final NamespaceUri _currentNamespaceId;
    private final NamespaceUri _enclosingNamespaceId;
    protected Map<SpxSymbolKey, List<SpxSymbol>> symbols;

    @Override
    public NamespaceUri namespaceUri() {
        return this._currentNamespaceId;
    }

    @Override
    public NamespaceUri enclosingNamespaceUri() {
        return this._enclosingNamespaceId;
    }

    @Override
    public abstract IStrategoAppl toTypedQualifiedName(SpxSemanticIndexFacade var1);

    protected BaseNamespace(NamespaceUri currentNamespace, IStrategoConstructor type, ISpxPersistenceManager manager, NamespaceUri enclosingNamespace) {
        assert (currentNamespace != null) : "Current Namespace Identifier is null";
        assert (type != null) : "Non-null Type is expected";
        this._currentNamespaceId = currentNamespace;
        this._enclosingNamespaceId = enclosingNamespace;
        this.src = this._enclosingNamespaceId != null ? String.valueOf(type.getName()) + this._currentNamespaceId.id() : type.getName();
        this.symbols = new HashMap<SpxSymbolKey, List<SpxSymbol>>();
    }

    @Override
    public INamespace define(SpxSymbolTableEntry entry, SpxSemanticIndexFacade f) {
        entry.value.setNamespace(this._currentNamespaceId);
        this.defineSymbol(entry);
        return this;
    }

    private void defineSymbol(SpxSymbolTableEntry entry) {
        List<Object> values = new ArrayList<SpxSymbol>();
        if (!this.symbols.containsKey(entry.key)) {
            values.add(entry.value);
        } else {
            values = this.symbols.get(entry.key);
            if (entry.key.isOverridable()) {
                values.add(entry.value);
            } else {
                assert (values.size() == 1);
                values.set(0, entry.value);
            }
        }
        this.symbols.put(entry.key, values);
    }

    @Override
    public Set<SpxSymbol> undefineSymbols(IStrategoTerm searchingFor, IStrategoTerm type, SpxSemanticIndexFacade facade) {
        assert (type instanceof IStrategoConstructor) : "type is expected to be a IStrategoConstructor";
        SpxSymbolKey key = new SpxSymbolKey(searchingFor, (IStrategoConstructor)type);
        HashSet<SpxSymbol> undefinedSymbols = new HashSet<SpxSymbol>();
        if (this.symbols.containsKey(key)) {
            List<SpxSymbol> foundSymbols = this.getMembers().get(key);
            ArrayList<SpxSymbol> symbolsToDelete = new ArrayList<SpxSymbol>();
            for (SpxSymbol s : foundSymbols) {
                symbolsToDelete.add(s);
            }
            for (SpxSymbol s : symbolsToDelete) {
                if (!foundSymbols.remove(s)) continue;
                undefinedSymbols.add(s);
            }
            this.symbols.put(key, foundSymbols);
        }
        return undefinedSymbols;
    }

    private static List<SpxSymbol> appendSymbols(List<SpxSymbol> origin, List<SpxSymbol> symbols) {
        if (symbols != null) {
            origin.addAll(symbols);
        }
        return origin;
    }

    protected static List<SpxSymbol> lookupSymbols(Map<SpxSymbolKey, List<SpxSymbol>> members, IStrategoTerm id, IStrategoTerm type) {
        assert (type instanceof IStrategoConstructor) : "type is expected to be a IStrategoConstructor";
        SpxSymbolKey key = new SpxSymbolKey(id, (IStrategoConstructor)type);
        List<SpxSymbol> resolvedSymbols = new ArrayList<SpxSymbol>();
        if (key.getId().equalsIgnoreCase("\"*\"")) {
            for (Map.Entry<SpxSymbolKey, List<SpxSymbol>> entry : members.entrySet()) {
                if (!SpxSymbolKey.equalSignature((IStrategoConstructor)type, entry.getKey())) continue;
                resolvedSymbols = BaseNamespace.appendSymbols(resolvedSymbols, members.get(entry.getKey()));
            }
        } else {
            resolvedSymbols = BaseNamespace.appendSymbols(resolvedSymbols, members.get(key));
        }
        return resolvedSymbols;
    }

    protected static SpxSymbol lookupSymbol(Map<SpxSymbolKey, List<SpxSymbol>> members, IStrategoTerm id, IStrategoTerm type) {
        assert (type instanceof IStrategoConstructor) : "type is expected to be a IStrategoConstructor";
        List<SpxSymbol> resolvedSymbols = BaseNamespace.lookupSymbols(members, id, type);
        if (resolvedSymbols.size() > 0) {
            return resolvedSymbols.get(resolvedSymbols.size() - 1);
        }
        return null;
    }

    @Override
    public SpxSymbol resolve(IStrategoTerm searchingFor, IStrategoTerm type, INamespace searchedBy, SpxSemanticIndexFacade facade, int lookupDepth) throws SpxSymbolTableException {
        facade.getPersistenceManager().logMessage(this.src, "resolve | Resolving Symbol in " + this.namespaceUri().id() + " . Key :  " + searchingFor + " origin Namespace: " + searchedBy.namespaceUri().id());
        assert (type instanceof IStrategoConstructor) : "Type is expected to be IStrategoConstructor";
        SpxSymbol result = BaseNamespace.lookupSymbol(this.getMembers(), searchingFor, type);
        if (result != null) {
            return result;
        }
        INamespace namespace = this.getEnclosingNamespace(facade.getPersistenceManager().spxSymbolTable());
        if (namespace != null && this.shouldSearchInEnclosingNamespace(searchedBy, lookupDepth)) {
            return namespace.resolve(searchingFor, type, this, facade, lookupDepth - 1);
        }
        return null;
    }

    @Override
    public Collection<SpxSymbol> resolveAll(SpxSemanticIndexFacade facade, IStrategoTerm searchingFor, IStrategoTerm ofType, INamespace searchedBy, int lookupDepth, boolean returnDuplicate) throws SpxSymbolTableException {
        facade.getPersistenceManager().logMessage(this.src, "resolveAll(Base) | Resolving Symbol in " + this.namespaceUri().id() + " . Key :  " + searchingFor + " origin Namespace: " + searchedBy.namespaceUri().id());
        AbstractCollection retResult = null;
        retResult = returnDuplicate ? new ArrayList() : new HashSet();
        List<SpxSymbol> lookupResult = BaseNamespace.lookupSymbols(this.getMembers(), searchingFor, ofType);
        retResult.addAll(lookupResult);
        INamespace namespace = this.getEnclosingNamespace(facade.getPersistenceManager().spxSymbolTable());
        if (namespace != null && !namespace.equals(this) && this.shouldSearchInEnclosingNamespace(searchedBy, lookupDepth)) {
            Collection<SpxSymbol> parentResults = namespace.resolveAll(facade, searchingFor, ofType, this, lookupDepth, false);
            retResult.addAll(parentResults);
        }
        return retResult;
    }

    @Override
    public Collection<SpxSymbol> resolveAll(SpxSemanticIndexFacade spxFacade, IStrategoTerm searchingFor, IStrategoTerm ofType, int lookupDepth, boolean retrunDuplicate) throws SpxSymbolTableException {
        return this.resolveAll(spxFacade, searchingFor, ofType, this, lookupDepth, retrunDuplicate);
    }

    @Override
    public Map<SpxSymbolKey, List<SpxSymbol>> getMembers() {
        if (this.symbols == null) {
            this.symbols = new HashMap<SpxSymbolKey, List<SpxSymbol>>();
        }
        return this.symbols;
    }

    @Override
    public void clear() {
        if (this.symbols != null) {
            this.symbols.clear();
        }
    }

    @Override
    public INamespace getEnclosingNamespace(INamespaceResolver rs) throws SpxSymbolTableException {
        return this._enclosingNamespaceId != null ? this._enclosingNamespaceId.resolve(rs) : null;
    }

    @Override
    public INamespace getCurrentNamespace(INamespaceResolver rs) throws SpxSymbolTableException {
        return this._currentNamespaceId.resolve(rs);
    }

    @Override
    public boolean isInternalNamespace() {
        return false;
    }

    protected boolean shouldSearchInEnclosingNamespace(INamespace searchedBy, int lookupDepth) {
        return !searchedBy.namespaceUri().equals(this.enclosingNamespaceUri()) && this.verifyIsValidForLookup(lookupDepth);
    }

    protected boolean verifyIsValidForLookup(int lookupDepth) {
        return lookupDepth > 0;
    }

    public String toString() {
        return "Namespace { " + this.src + "}";
    }

    @Override
    public String getAbosoluteFilePath() {
        return null;
    }
}

