/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.spoofax.interpreter.library.language.spxlang.index.BaseNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.GlobalNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.ModuleNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPrimarySymbolTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.ModuleDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.NamespaceUri;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PackageNamespace
extends BaseNamespace {
    private static final long serialVersionUID = 7324156752002137217L;
    private static final String INTERNAL_NAMESPACENAME = "__internal";
    transient Set<NamespaceUri> importedNamespaceUris;
    transient Set<NamespaceUri> enclosedNamespaceUris;

    private PackageNamespace(NamespaceUri currentNamespace, IStrategoConstructor type, NamespaceUri enclosingNamespace, ISpxPersistenceManager manager) {
        super(currentNamespace, type, manager, enclosingNamespace);
    }

    @Override
    public void clear() {
        super.clear();
        this.importedNamespaceUris = null;
        this.enclosedNamespaceUris = null;
    }

    void ensureEnclosedNamespaceUrisLoaded(SpxSemanticIndexFacade facade) throws SpxSymbolTableException {
        if (this.enclosedNamespaceUris == null) {
            this.enclosedNamespaceUris = new HashSet<NamespaceUri>();
            this.enclosedNamespaceUris.add(PackageNamespace.packageInternalNamespace(this.namespaceUri(), facade));
            Iterable<ModuleDeclaration> mDecls = facade.getModuleDeclarations(this.namespaceUri().id());
            if (mDecls != null) {
                for (ModuleDeclaration m : mDecls) {
                    this.enclosedNamespaceUris.add(m.getNamespaceUri(facade));
                }
            }
        }
    }

    void ensureImportedNamespaceUrisLoaded(SpxSemanticIndexFacade facade) throws SpxSymbolTableException {
        if (this.importedNamespaceUris == null) {
            this.importedNamespaceUris = new HashSet<NamespaceUri>();
            SpxPrimarySymbolTable symTable = facade.getPersistenceManager().spxSymbolTable();
            PackageDeclaration assiciatedPackageDeclaration = facade.lookupPackageDecl(this.namespaceUri().id());
            Set<IStrategoList> importedIds = assiciatedPackageDeclaration.getImportReferneces();
            for (IStrategoList l : importedIds) {
                this.importedNamespaceUris.add(symTable.toNamespaceUri(l));
            }
        }
    }

    boolean isTransitiveImportLookup(SpxSemanticIndexFacade facade, INamespace searchOrigin) throws SpxSymbolTableException {
        PackageDeclaration assiciatedPackageDeclaration = facade.lookupPackageDecl(this.namespaceUri().id());
        Set<IStrategoList> importedToPackages = facade.getPersistenceManager().spxPackageTable().getImportedToReferencesOf(assiciatedPackageDeclaration.getId());
        return importedToPackages.contains(searchOrigin.namespaceUri().id());
    }

    @Override
    public SpxSymbol resolve(IStrategoTerm id, IStrategoTerm type, INamespace searchedBy, SpxSemanticIndexFacade facade, int lookupDepth) throws SpxSymbolTableException {
        facade.getPersistenceManager().logMessage(this.src, "resolve | Resolving Symbol in " + this.namespaceUri().id() + " . Key :  " + id + " origin Namespace: " + searchedBy.namespaceUri().id());
        this.ensureEnclosedNamespaceUrisLoaded(facade);
        SpxSymbol retSymbol = this.resolveSymbolinNamespaces(this.enclosedNamespaceUris, id, type, searchedBy, facade);
        if (retSymbol == null && (retSymbol = super.resolve(id, type, searchedBy, facade, lookupDepth)) == null && this.shouldSearchInImportedNamespace(facade, searchedBy, lookupDepth)) {
            this.ensureImportedNamespaceUrisLoaded(facade);
            retSymbol = this.resolveSymbolinNamespaces(this.importedNamespaceUris, id, type, searchedBy, facade);
        }
        return retSymbol;
    }

    @Override
    public Collection<SpxSymbol> resolveAll(SpxSemanticIndexFacade facade, IStrategoTerm key, IStrategoTerm type, INamespace originNamespace, int lookupDepth, boolean returnDuplicate) throws SpxSymbolTableException {
        facade.getPersistenceManager().logMessage(this.src, "resolveAll | Resolving Symbol in " + this.namespaceUri().id() + " . Key :  " + key + " origin Namespace: " + originNamespace.namespaceUri().id());
        AbstractCollection retResult = null;
        retResult = returnDuplicate ? new ArrayList() : new HashSet();
        this.ensureEnclosedNamespaceUrisLoaded(facade);
        retResult.addAll(this.resolveAllSymbolsInNamespaces(this.enclosedNamespaceUris, key, type, originNamespace, facade, returnDuplicate));
        retResult.addAll(super.resolveAll(facade, key, type, originNamespace, lookupDepth, returnDuplicate));
        if (this.shouldSearchInImportedNamespace(facade, originNamespace, lookupDepth)) {
            this.ensureImportedNamespaceUrisLoaded(facade);
            retResult.addAll(this.resolveAllSymbolsInNamespaces(this.importedNamespaceUris, key, type, originNamespace, facade, returnDuplicate));
        }
        return retResult;
    }

    protected boolean shouldSearchInImportedNamespace(SpxSemanticIndexFacade facade, INamespace originNamespace, int lookupDepth) throws SpxSymbolTableException {
        return !this.isTransitiveImportLookup(facade, originNamespace) && this.verifyIsValidForLookup(lookupDepth);
    }

    @Override
    protected boolean shouldSearchInEnclosingNamespace(INamespace searchedBy, int lookupDepth) {
        boolean retValue = super.shouldSearchInEnclosingNamespace(searchedBy, lookupDepth);
        if (retValue) {
            retValue = this.enclosedNamespaceUris.contains(searchedBy.namespaceUri());
        }
        return retValue;
    }

    private SpxSymbol resolveSymbolinNamespaces(Iterable<NamespaceUri> resolvableUris, IStrategoTerm key, IStrategoTerm type, INamespace searchedOrigin, SpxSemanticIndexFacade facade) throws SpxSymbolTableException {
        SpxSymbol retSymbol = null;
        SpxPrimarySymbolTable namespaceResolver = facade.getPersistenceManager().spxSymbolTable();
        for (NamespaceUri uri : resolvableUris) {
            INamespace thisNamespace = uri.resolve(namespaceResolver);
            if (!this.disallowLookupIn(thisNamespace, searchedOrigin) && (retSymbol = thisNamespace.resolve(key, type, this, facade, Integer.MAX_VALUE)) != null) break;
        }
        return retSymbol;
    }

    private Collection<SpxSymbol> resolveAllSymbolsInNamespaces(Iterable<NamespaceUri> resolvableUris, IStrategoTerm key, IStrategoTerm ofType, INamespace searchOrigin, SpxSemanticIndexFacade facade, boolean returnDuplicates) throws SpxSymbolTableException {
        AbstractCollection retSymbol = null;
        retSymbol = returnDuplicates ? new ArrayList() : new HashSet();
        SpxPrimarySymbolTable namespaceResolver = facade.getPersistenceManager().spxSymbolTable();
        for (NamespaceUri uri : resolvableUris) {
            INamespace thisNamespace = uri.resolve(namespaceResolver);
            if (this.disallowLookupIn(thisNamespace, searchOrigin)) continue;
            retSymbol.addAll((Set)thisNamespace.resolveAll(facade, key, ofType, this, Integer.MAX_VALUE, false));
        }
        return retSymbol;
    }

    protected boolean shouldSearchInInternalNamespace(INamespace namespaceToSearchIn, INamespace searchedBy) {
        if (namespaceToSearchIn.enclosingNamespaceUri().equals(this.namespaceUri())) {
            return searchedBy.enclosingNamespaceUri().equals(this.namespaceUri()) || searchedBy.namespaceUri().equals(this.namespaceUri());
        }
        return false;
    }

    private boolean disallowLookupIn(INamespace namespaceToSearchIn, INamespace originNamespace) {
        boolean currentNamespaceIsSearchedOrigin;
        boolean resolveInCurrentNamespaceIsNotAllowed = namespaceToSearchIn.isInternalNamespace() && !this.shouldSearchInInternalNamespace(namespaceToSearchIn, originNamespace);
        boolean bl = currentNamespaceIsSearchedOrigin = namespaceToSearchIn.namespaceUri() == originNamespace.namespaceUri();
        return resolveInCurrentNamespaceIsNotAllowed || currentNamespaceIsSearchedOrigin;
    }

    public static Iterable<INamespace> createInstances(IStrategoList id, SpxSemanticIndexFacade facade) {
        SpxPrimarySymbolTable table = facade.getPersistenceManager().spxSymbolTable();
        ArrayList<INamespace> namespaces = new ArrayList<INamespace>();
        INamespace ns = table.resolveNamespace(id);
        if (ns == null) {
            NamespaceUri globalNsUri = table.toNamespaceUri(GlobalNamespace.getGlobalNamespaceId(facade));
            NamespaceUri currentPackageUri = table.toNamespaceUri(id);
            ns = new PackageNamespace(currentPackageUri, facade.getCons().getPackageNamespaceTypeCon(), globalNsUri, facade.getPersistenceManager());
        }
        namespaces.add(ns);
        namespaces.add(PackageNamespace.createInternalNamespace(ns.namespaceUri(), facade));
        return namespaces;
    }

    private static INamespace createInternalNamespace(NamespaceUri enclosingNamespaceId, SpxSemanticIndexFacade facade) {
        NamespaceUri internalNamespaceUri;
        SpxPrimarySymbolTable table = facade.getPersistenceManager().spxSymbolTable();
        INamespace ns = table.resolveNamespace(internalNamespaceUri = PackageNamespace.packageInternalNamespace(enclosingNamespaceId, facade));
        if (ns == null) {
            ns = (ModuleNamespace)ModuleNamespace.createInstance(internalNamespaceUri, enclosingNamespaceId, facade, null);
            ((ModuleNamespace)ns).isInternalNamespace = true;
        }
        return ns;
    }

    public static NamespaceUri packageInternalNamespace(NamespaceUri enclosingNamespaceId, SpxSemanticIndexFacade idxFacade) {
        SpxPrimarySymbolTable table = idxFacade.getPersistenceManager().spxSymbolTable();
        IStrategoList internalModuleID = PackageNamespace.packageInternalModuleId(enclosingNamespaceId.id(), idxFacade);
        NamespaceUri internalModuleUri = table.toNamespaceUri(internalModuleID);
        return internalModuleUri;
    }

    public static IStrategoList packageInternalModuleId(IStrategoList id, SpxSemanticIndexFacade idxFacade) {
        ITermFactory termFactory = idxFacade.getTermFactory();
        ArrayList<IStrategoTerm> subTerms = new ArrayList<IStrategoTerm>();
        IStrategoList spoofaxNamespaceId = id;
        subTerms.addAll(Arrays.asList(spoofaxNamespaceId.getAllSubterms()));
        subTerms.add(termFactory.makeString(INTERNAL_NAMESPACENAME));
        return termFactory.makeList(subTerms);
    }

    @Override
    public IStrategoAppl toTypedQualifiedName(SpxSemanticIndexFacade facade) {
        return PackageDeclaration.toPackageQNameAppl(facade, this.namespaceUri().id());
    }
}

