/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdbm.PrimaryHashMap;
import jdbm.PrimaryStoreMap;
import jdbm.RecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.ICompilationUnitRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexUtils;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxCompilationUnitInfo;
import org.spoofax.interpreter.terms.IStrategoTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpxCompilationUnitTable {
    private final String SRC = this.getClass().getSimpleName();
    private final PrimaryHashMap<String, SpxCompilationUnitInfo> _infoMap;
    private final PrimaryStoreMap<Long, String> _spxUnitStoreMap;
    protected List<RecordListener<String, SpxCompilationUnitInfo>> recordListeners = new ArrayList<RecordListener<String, SpxCompilationUnitInfo>>();

    public SpxCompilationUnitTable(ISpxPersistenceManager manager) {
        String tableName = String.valueOf(this.SRC) + "_" + manager.getIndexId();
        this._infoMap = manager.loadHashMap(String.valueOf(tableName) + "._infomap.idx");
        this._spxUnitStoreMap = manager.loadStoreMap(String.valueOf(tableName) + "._spxUnitStorageMap.idx");
    }

    public void define(SpxSemanticIndexFacade facade, URI absPath, IStrategoTerm compilationUnitRTree) throws IOException {
        String abspathString = SpxIndexUtils.uriToAbsPathString(absPath);
        if (this._infoMap.containsKey(abspathString)) {
            this.update(facade, absPath, compilationUnitRTree);
        } else {
            this.add(facade, absPath, compilationUnitRTree);
        }
    }

    private void add(SpxSemanticIndexFacade facade, URI absPath, IStrategoTerm compilationUnitAST) throws IOException {
        String serializedTerm = SpxIndexUtils.serializeToString(facade.getTermAttachmentSerializer(), compilationUnitAST);
        long resID = this._spxUnitStoreMap.putValue(serializedTerm);
        SpxCompilationUnitInfo newResInfo = new SpxCompilationUnitInfo(absPath, resID);
        String key = newResInfo.getAbsPathString();
        this._infoMap.put(key, newResInfo);
        if (!this.recordListeners.isEmpty()) {
            for (RecordListener<String, SpxCompilationUnitInfo> r : this.recordListeners) {
                r.recordInserted(key, newResInfo);
            }
        }
    }

    private void update(SpxSemanticIndexFacade facade, URI absPath, IStrategoTerm compilationUnitAterm) throws IOException {
        SpxCompilationUnitInfo oldValue = (SpxCompilationUnitInfo)this._infoMap.get(SpxIndexUtils.uriToAbsPathString(absPath));
        SpxCompilationUnitInfo newValue = SpxCompilationUnitInfo.newInstance(oldValue);
        newValue.incrVersion();
        this._infoMap.put(newValue.getAbsPathString(), newValue);
        String serializedTerm = SpxIndexUtils.serializeToString(facade.getTermAttachmentSerializer(), compilationUnitAterm);
        this._spxUnitStoreMap.put(newValue.getRecId(), serializedTerm);
        if (!this.recordListeners.isEmpty()) {
            for (RecordListener<String, SpxCompilationUnitInfo> r : this.recordListeners) {
                r.recordUpdated(SpxIndexUtils.uriToAbsPathString(absPath), oldValue, newValue);
            }
        }
    }

    public void remove(URI absPathUri) throws IOException {
        String key = SpxIndexUtils.uriToAbsPathString(absPathUri);
        this.remove(key);
    }

    public void verifyUriExists(String uri) {
        if (!this._infoMap.containsKey(uri)) {
            throw new IllegalArgumentException("Unknown CompilationUnit Uri: " + uri);
        }
    }

    void remove(String absPathString) throws IOException {
        SpxCompilationUnitInfo removedValue = (SpxCompilationUnitInfo)this._infoMap.remove(absPathString);
        if (removedValue != null && this._spxUnitStoreMap.containsKey(removedValue.getRecId())) {
            this._spxUnitStoreMap.remove(removedValue.getRecId());
        }
        if (!this.recordListeners.isEmpty()) {
            for (RecordListener<String, SpxCompilationUnitInfo> r : this.recordListeners) {
                r.recordRemoved(absPathString, removedValue);
            }
        }
    }

    public IStrategoTerm get(SpxSemanticIndexFacade f, URI absPath) {
        SpxCompilationUnitInfo retUnitData = this.getInfo(f, absPath);
        String serializedString = (String)this._spxUnitStoreMap.get(retUnitData.getRecId());
        IStrategoTerm deserializedTerm = SpxIndexUtils.deserializeToTerm(f.getTermFactory(), f.getTermAttachmentSerializer(), serializedString);
        return deserializedTerm;
    }

    public SpxCompilationUnitInfo getInfo(SpxSemanticIndexFacade f, URI absPath) {
        String key = SpxIndexUtils.uriToAbsPathString(absPath);
        return (SpxCompilationUnitInfo)this._infoMap.get(key);
    }

    public void clear() throws IOException {
        Iterator keyIter = this._infoMap.keySet().iterator();
        if (keyIter != null) {
            while (keyIter.hasNext()) {
                this.remove((String)keyIter.next());
            }
        }
    }

    private void addRecordListener(RecordListener<String, SpxCompilationUnitInfo> listener) {
        this.recordListeners.add(listener);
    }

    private void removeRecordListener(RecordListener<String, SpxCompilationUnitInfo> listener) {
        this.recordListeners.remove(listener);
    }

    public void addRecordListener(ICompilationUnitRecordListener rl) {
        this.addRecordListener(rl.getCompilationUnitRecordListener());
    }

    public void removeRecordListener(ICompilationUnitRecordListener rl) {
        this.removeRecordListener(rl.getCompilationUnitRecordListener());
    }
}

