/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.util.HashMap;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.ITermFactory;

public class SpxConstructors {
    private final HashMap<ConstructorDef, IStrategoConstructor> _knownCons;
    private final ITermFactory _termFactory;

    public SpxConstructors(ITermFactory tf) {
        this._termFactory = tf;
        this._knownCons = new HashMap();
        this.initKnownConstructors();
    }

    private void initKnownConstructors() {
        ConstructorDef.newInstance("ModuleDef", 5).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("ModuleDecl", 3).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("SymbolDef", 5).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("PackageDecl", 2).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("ImportDecl", 2).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("LanguageDescriptor", 5).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("Module", 1).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("Package", 1).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("QName", 1).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("Locals", 1).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("Globals", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("Package", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("Module", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("ToCompile", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("ToCodeGenerate", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("OverridableSymbol", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("UniqueSymbol", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("LookupLocalScope", 0).index(this._knownCons, this._termFactory);
        ConstructorDef.newInstance("LookupAllScope", 0).index(this._knownCons, this._termFactory);
    }

    IStrategoConstructor indexConstructor(IStrategoConstructor ctor) {
        ConstructorDef def = ConstructorDef.newInstance(ctor.getName(), ctor.getArity());
        return def.index(this._knownCons, ctor);
    }

    public IStrategoConstructor getPackageDeclCon() {
        return this.getConstructor("PackageDecl", 2);
    }

    public IStrategoConstructor getModuleDeclCon() {
        return this.getConstructor("ModuleDecl", 3);
    }

    public IStrategoConstructor getModuleDefCon() {
        return this.getConstructor("ModuleDef", 5);
    }

    public IStrategoConstructor getLanguageDescriptorCon() {
        return this.getConstructor("LanguageDescriptor", 5);
    }

    public IStrategoConstructor getModuleQNameCon() {
        return this.getConstructor("Module", 1);
    }

    public IStrategoConstructor getPackageQNameCon() {
        return this.getConstructor("Package", 1);
    }

    public IStrategoConstructor getQNameCon() {
        return this.getConstructor("QName", 1);
    }

    public IStrategoConstructor getImportDeclCon() {
        return this.getConstructor("ImportDecl", 2);
    }

    public IStrategoConstructor getGlobalNamespaceTypeCon() {
        return this.getConstructor("Globals", 0);
    }

    public IStrategoConstructor getPackageNamespaceTypeCon() {
        return this.getConstructor("Package", 0);
    }

    public IStrategoConstructor getModuleNamespaceTypeCon() {
        return this.getConstructor("Module", 0);
    }

    public IStrategoConstructor getOverridableSymbolTypeCon() {
        return this.getConstructor("OverridableSymbol", 0);
    }

    public IStrategoConstructor getUniqueSymbolTypeCon() {
        return this.getConstructor("UniqueSymbol", 0);
    }

    public IStrategoConstructor getSymbolTableEntryDefCon() {
        return this.getConstructor("SymbolDef", 5);
    }

    public IStrategoConstructor getLocalNamespaceTypeCon() {
        return this.getConstructor("Locals", 1);
    }

    public IStrategoConstructor getToCompileCon() {
        return this.getConstructor("ToCompile", 0);
    }

    public IStrategoConstructor getToCodeGenerateCon() {
        return this.getConstructor("ToCodeGenerate", 0);
    }

    public IStrategoConstructor getToLookupTypeAll() {
        return this.getConstructor("LookupAllScope", 0);
    }

    public IStrategoConstructor getToLookupTypeLocal() {
        return this.getConstructor("LookupLocalScope", 0);
    }

    public IStrategoConstructor getConstructor(String symbolTypeCons, int arity) {
        return this._knownCons.get(ConstructorDef.newInstance(symbolTypeCons, arity));
    }

    public boolean hasEqualConstructor(IStrategoAppl actual, IStrategoConstructor expected) {
        return this.isEqualConstructor(actual.getConstructor(), expected);
    }

    public boolean isEqualConstructor(IStrategoConstructor actual, IStrategoConstructor expected) {
        return actual == expected;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstructorDef {
        private String _name;
        private int _arity;

        ConstructorDef(String name, int arity) {
            this._name = name;
            this._arity = arity;
        }

        static ConstructorDef newInstance(String name, int arity) {
            return new ConstructorDef(name, arity);
        }

        private IStrategoConstructor toStrategoConstructor(ITermFactory fac) {
            return fac.makeConstructor(this._name, this._arity);
        }

        IStrategoConstructor index(HashMap<ConstructorDef, IStrategoConstructor> cons, ITermFactory fac) {
            return this.index(cons, this.toStrategoConstructor(fac));
        }

        IStrategoConstructor index(HashMap<ConstructorDef, IStrategoConstructor> cons, IStrategoConstructor ctor) {
            cons.put(this, ctor);
            return ctor;
        }

        public String toString() {
            return "ConstructorDef [_name=" + this._name + ", _arity=" + this._arity + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._arity;
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstructorDef other = (ConstructorDef)obj;
            if (this._arity != other._arity) {
                return false;
            }
            return !(this._name == null ? other._name != null : !this._name.equals(other._name));
        }
    }
}

