/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.spxlang.index.IIndexManageCommand;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndex;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class SpxIndexManager
implements IIndexManageCommand {
    private final SpxSemanticIndex spxSemanticIndex;
    private final IStrategoTerm projectName;
    private final Object[] arguments;

    SpxIndexManager(SpxSemanticIndex spxSemanticIndex, IStrategoTerm projectPath, Object ... args) {
        this.spxSemanticIndex = spxSemanticIndex;
        this.arguments = args;
        this.projectName = projectPath;
    }

    static void ensureFacadeInitialized(SpxSemanticIndexFacade f) throws SpxSymbolTableException {
        if (f == null) {
            throw new RuntimeException("Symbol Table is not initialized for project . Invoke SPX_index_init. ");
        }
    }

    protected void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectName, Object ... objects) throws Exception {
    }

    public void run() throws Exception {
        this.executeCommnad(this.spxSemanticIndex, this.projectName, this.arguments);
    }

    public static IIndexManageCommand getCommandInstance(SpxSemanticIndex spxSemanticIndex, IStrategoString commandName, IStrategoString projectName, Object ... objects) {
        return SpxIndexManager.getCommandInstance(spxSemanticIndex, Tools.asJavaString(commandName), projectName, objects);
    }

    static IIndexManageCommand getCommandInstance(SpxSemanticIndex spxSemanticIndex, String commandName, IStrategoString projectPath, Object ... objects) {
        if (commandName.equalsIgnoreCase("CLEAR")) {
            return SpxIndexManager.clearCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("SAVE")) {
            return SpxIndexManager.saveCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("CLOSE")) {
            return SpxIndexManager.closeCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("INIT")) {
            return SpxIndexManager.initCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("ROLLBACK")) {
            return SpxIndexManager.rollbackCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("INVALIDATE_GLOBAL_CACHE")) {
            return SpxIndexManager.invalidateGlobalCacheCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("ON_INIT_CODEGEN")) {
            return SpxIndexManager.onInitCodeGenrationCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("ON_COMPLETE_CODEGEN")) {
            return SpxIndexManager.onCompleteCodeGenrationCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("ON_INIT_INDEX_UPDATING")) {
            return SpxIndexManager.onInitIndexUpdatingCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        if (commandName.equalsIgnoreCase("ON_INDEX_UPDATING_COMPLETED")) {
            return SpxIndexManager.onIndexUpdatingCompletedCommandInstance(spxSemanticIndex, projectPath, objects);
        }
        throw new IllegalArgumentException("Invalid command name :" + commandName);
    }

    private static IIndexManageCommand onInitIndexUpdatingCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object[] objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade f = idx.getFacadeRegistry().getFacade(projectPath);
                if (f != null) {
                    f.onInitIndexUpdating();
                }
            }
        };
    }

    private static IIndexManageCommand onIndexUpdatingCompletedCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object[] objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade f = idx.getFacadeRegistry().getFacade(projectPath);
                if (f != null) {
                    f.onIndexUpatingCompleted();
                }
            }
        };
    }

    private static IIndexManageCommand onInitCodeGenrationCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object[] objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade f = idx.getFacadeRegistry().getFacade(projectPath);
                if (f != null) {
                    f.onInitCodeGeneration();
                }
            }
        };
    }

    private static IIndexManageCommand onCompleteCodeGenrationCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object[] objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade f = idx.getFacadeRegistry().getFacade(projectPath);
                if (f != null) {
                    f.onCompleteCodeGeneration();
                }
            }
        };
    }

    private static IIndexManageCommand rollbackCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object[] objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade f = idx.getFacadeRegistry().getFacade(projectPath);
                if (f != null) {
                    f.rollbackChanges();
                }
            }
        };
    }

    private static SpxIndexManager clearCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object ... objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade idxFacade = idx.getFacadeRegistry().getFacade(projectPath);
                if (idxFacade == null) {
                    idxFacade = idx.getFacadeRegistry().initFacade(projectPath, (ITermFactory)objects[0], (IOAgent)objects[1]);
                }
                idxFacade.cleanIndexAndSymbolTable();
            }
        };
    }

    private static SpxIndexManager closeCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object ... objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade idxFacade = idx.getFacadeRegistry().getFacade(projectPath);
                if (idxFacade != null) {
                    idxFacade.close(true);
                }
            }
        };
    }

    private static SpxIndexManager initCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object ... objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                idx.getFacadeRegistry().initFacade(projectPath, (ITermFactory)objects[0], (IOAgent)objects[1]);
            }
        };
    }

    private static SpxIndexManager saveCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object ... objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade idxFacade = idx.getFacadeRegistry().getFacade(projectPath);
                if (idxFacade != null) {
                    idxFacade.commitChanges();
                }
            }
        };
    }

    private static IIndexManageCommand invalidateGlobalCacheCommandInstance(SpxSemanticIndex index, IStrategoString projectPath, Object[] objects) {
        return new SpxIndexManager(index, projectPath, objects){

            public void executeCommnad(SpxSemanticIndex idx, IStrategoTerm projectPath, Object ... objects) throws Exception {
                SpxSemanticIndexFacade idxFacade = idx.getFacade(projectPath);
                idxFacade.invalidateGlobalNamespace();
            }
        };
    }
}

