/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.ModuleNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.PackageNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexConfiguration;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.IdentifiableConstruct;
import org.spoofax.interpreter.library.language.spxlang.index.data.NamespaceUri;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolKey;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.attachments.TermAttachmentSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpxIndexUtils {
    public static final String AllWithDuplicates = "**";
    public static final String All = "*";
    public static final String DIRTY = "-";
    public static final String ONLY_ONE = ".";
    public static final String All_SYMBOLS = "\"*\"";

    private SpxIndexUtils() {
    }

    public static <T extends IdentifiableConstruct> IStrategoList toTerm(SpxSemanticIndexFacade idxFacade, Iterable<T> decls) {
        ITermFactory termFactory = idxFacade.getTermFactory();
        IStrategoList result = termFactory.makeList();
        if (decls != null) {
            for (IdentifiableConstruct decl : decls) {
                result = termFactory.makeListCons(decl.toTerm(idxFacade), result);
            }
        }
        return result;
    }

    public static String uriToAbsPathString(URI uri) {
        return new File(uri).getAbsolutePath();
    }

    public static String toAbsPathString(String path) {
        return new File(path).getAbsolutePath();
    }

    public static URI getAbsolutePathUri(String path, IOAgent agent) {
        File file = new File(path);
        return file.isAbsolute() ? file.toURI() : new File(agent.getWorkingDir(), path).toURI();
    }

    public static String getAbsolutePathString(String path, IOAgent agent) {
        return SpxIndexUtils.uriToAbsPathString(SpxIndexUtils.getAbsolutePathUri(path, agent));
    }

    static String now(String dateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(cal.getTime());
    }

    static void tryDeleteSpxIndexDir(File cacheDir) {
        if (cacheDir.exists() && cacheDir.isDirectory()) {
            String[] children = cacheDir.list();
            int i = 0;
            while (i < children.length) {
                SpxIndexUtils.tryDeleteSpxIndexDir(new File(cacheDir, children[i]));
                ++i;
            }
        }
        cacheDir.delete();
    }

    static boolean deleteSpxCacheDir(File cacheDir, boolean isRoot) {
        if (cacheDir.exists() && cacheDir.isDirectory()) {
            String[] children = cacheDir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = SpxIndexUtils.deleteSpxCacheDir(new File(cacheDir, children[i]), false);
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        if (isRoot) {
            return true;
        }
        return cacheDir.delete();
    }

    public static String serializeToString(TermAttachmentSerializer serializer, IStrategoTerm t) throws IOException {
        if (t == null) {
            return null;
        }
        IStrategoTerm annotatedTerm = serializer.toAnnotations(t);
        return SpxIndexUtils.termToString(annotatedTerm);
    }

    public static String termToString(IStrategoTerm t) throws IOException {
        StringBuilder sb = new StringBuilder();
        t.writeAsString(sb, Integer.MAX_VALUE);
        return sb.toString();
    }

    public static IStrategoTerm deserializeToTerm(ITermFactory fac, TermAttachmentSerializer serializer, String termString) {
        if (termString == null) {
            return null;
        }
        IStrategoTerm deserializedAtermWithAnnotation = fac.parseFromString(termString);
        IStrategoTerm deserializedAterm = serializer.fromAnnotations(deserializedAtermWithAnnotation, true);
        return deserializedAterm;
    }

    public static String getCsvFormatted(String text) {
        if (text == null) {
            return "";
        }
        return text.replace(",", SpxIndexConfiguration.getCSVDelimiter());
    }

    static void logEntries(SpxSemanticIndexFacade f, INamespace namespace, BufferedWriter logger) throws IOException, SpxSymbolTableException {
        Map<SpxSymbolKey, List<SpxSymbol>> members = namespace.getMembers();
        if (namespace instanceof PackageNamespace) {
            PackageNamespace ns = (PackageNamespace)namespace;
            ns.ensureEnclosedNamespaceUrisLoaded(f);
            ns.ensureImportedNamespaceUrisLoaded(f);
            logger.write("Enclosed Namespace Uris:\n");
            for (NamespaceUri uri : ns.enclosedNamespaceUris) {
                logger.write(String.valueOf(SpxIndexUtils.getCsvFormatted(uri.toString())) + "\n");
            }
            logger.write("\n");
            logger.write("Imported Namespace Uris:\n");
            for (NamespaceUri uri : ns.importedNamespaceUris) {
                logger.write(String.valueOf(SpxIndexUtils.getCsvFormatted(uri.toString())) + "\n");
            }
            logger.write("\n");
        }
        if (namespace instanceof ModuleNamespace) {
            logger.write("Parent Namespace = " + ((ModuleNamespace)namespace).enclosingNamespaceUri() + "\n");
        }
        logger.write("\n");
        if (members.keySet().size() > 0) {
            logger.write("Key, Type , Symbol\n");
            for (SpxSymbolKey k : members.keySet()) {
                for (SpxSymbol s : members.get(k)) {
                    logger.write(String.valueOf(SpxIndexUtils.getCsvFormatted(k.printSymbolKey())) + ",");
                    logger.write(String.valueOf(s.printSymbol(f)) + "\n");
                }
            }
        } else {
            logger.write("No Symbols\n");
        }
        logger.write("\n");
    }

    static void printSymbolTable(SpxSemanticIndexFacade f, boolean printIfDebug, String stageName) throws IOException {
        ISpxPersistenceManager persistenceManager = f.getPersistenceManager();
        if (printIfDebug) {
            try {
                persistenceManager.spxSymbolTable().printSymbols(f, stageName, f.getProjectPath(), f.getIndexId());
            }
            catch (SpxSymbolTableException spxSymbolTableException) {
                // empty catch block
            }
        }
    }
}

