/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jdbm.PrimaryHashMap;
import jdbm.RecordListener;
import jdbm.SecondaryHashMap;
import jdbm.SecondaryKeyExtractor;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.language.spxlang.index.ICompilationUnitRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.IModuleDeclarationRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.IPackageDeclarationRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexUtils;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.LanguageDescriptor;
import org.spoofax.interpreter.library.language.spxlang.index.data.ModuleDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxCompilationUnitInfo;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpxModuleLookupTable
implements ICompilationUnitRecordListener,
IPackageDeclarationRecordListener {
    private final PrimaryHashMap<IStrategoList, ModuleDeclaration> _moduleLookupMap;
    protected List<RecordListener<IStrategoList, ModuleDeclaration>> recordListeners = new ArrayList<RecordListener<IStrategoList, ModuleDeclaration>>();
    private final PrimaryHashMap<IStrategoList, String> _moduleDefinition;
    private final PrimaryHashMap<IStrategoList, String> _moduleAnalyzedDefinition;
    private final SecondaryHashMap<String, IStrategoList, ModuleDeclaration> _moduleByFileAbsPath;
    private final SecondaryHashMap<IStrategoList, IStrategoList, ModuleDeclaration> _moduleByPackageId;
    private final PrimaryHashMap<IStrategoList, LanguageDescriptor> _languageDescriptors;
    private final SecondaryHashMap<String, IStrategoList, LanguageDescriptor> _modulesByLangaugeName;
    private final ISpxPersistenceManager _manager;
    private final String SRC = this.getClass().getSimpleName();

    public SpxModuleLookupTable(ISpxPersistenceManager manager) {
        String tableName = String.valueOf(this.SRC) + "_" + manager.getIndexId();
        assert (manager != null);
        this._manager = manager;
        this._moduleLookupMap = manager.loadHashMap(String.valueOf(tableName) + "._lookupModuleMap.idx");
        this._moduleByFileAbsPath = this._moduleLookupMap.secondaryHashMap(String.valueOf(tableName) + "._moduleByFileAbsPath.idx", new SecondaryKeyExtractor<String, IStrategoList, ModuleDeclaration>(){

            @Override
            public String extractSecondaryKey(IStrategoList key, ModuleDeclaration value) {
                return value.resourceAbsPath;
            }
        });
        this._moduleByPackageId = this._moduleLookupMap.secondaryHashMap(String.valueOf(tableName) + "._moduleByPackageId.idx", new SecondaryKeyExtractor<IStrategoList, IStrategoList, ModuleDeclaration>(){

            @Override
            public IStrategoList extractSecondaryKey(IStrategoList key, ModuleDeclaration value) {
                return value.enclosingPackageID;
            }
        });
        this._moduleDefinition = manager.loadHashMap(String.valueOf(tableName) + "._moduleDefinition.idx");
        this._moduleAnalyzedDefinition = manager.loadHashMap(String.valueOf(tableName) + "._moduleAnalyzedDefinition.idx");
        this._languageDescriptors = manager.loadHashMap(String.valueOf(tableName) + "._languageDescriptors.idx");
        this._modulesByLangaugeName = this._languageDescriptors.secondaryHashMapManyToOne(String.valueOf(tableName) + "._modulesByLangaugeName.idx", new SecondaryKeyExtractor<Iterable<String>, IStrategoList, LanguageDescriptor>(){

            @Override
            public Iterable<String> extractSecondaryKey(IStrategoList key, LanguageDescriptor value) {
                return value.asLanguageNameStrings();
            }
        });
        this.initRecordListener();
    }

    private void initRecordListener() {
        this._moduleLookupMap.addRecordListener(new RecordListener<IStrategoList, ModuleDeclaration>(){

            @Override
            public void recordInserted(IStrategoList key, ModuleDeclaration value) throws IOException {
            }

            @Override
            public void recordUpdated(IStrategoList key, ModuleDeclaration oldValue, ModuleDeclaration newValue) throws IOException {
            }

            @Override
            public void recordRemoved(IStrategoList key, ModuleDeclaration value) throws IOException {
                SpxModuleLookupTable.this._moduleDefinition.remove(key);
                SpxModuleLookupTable.this._moduleAnalyzedDefinition.remove(key);
                SpxModuleLookupTable.this._languageDescriptors.remove(key);
                if (!SpxModuleLookupTable.this.recordListeners.isEmpty()) {
                    for (RecordListener<IStrategoList, ModuleDeclaration> rl : SpxModuleLookupTable.this.recordListeners) {
                        rl.recordRemoved(key, value);
                    }
                }
            }
        });
    }

    void verifyModuleIDExists(IStrategoList moduleId) {
        if (!this.containsModuleDeclaration(moduleId)) {
            throw new IllegalArgumentException("Unknown Module ID : " + moduleId);
        }
    }

    public int size() {
        assert (this._moduleLookupMap.size() == this._moduleDefinition.size());
        assert (this._moduleLookupMap.size() == this._moduleAnalyzedDefinition.size());
        return this._moduleLookupMap.size();
    }

    public void define(SpxSemanticIndexFacade f, ModuleDeclaration decl, IStrategoAppl originalModuleDefinition, IStrategoAppl analyzedModuleDefinition) throws IOException {
        if (!this._moduleLookupMap.containsKey(decl.getId())) {
            this.define(decl).addModuleDefinition(f, decl.getId(), originalModuleDefinition).addAnalyzedModuleDefinition(f, decl.getId(), analyzedModuleDefinition);
        } else {
            this.addAnalyzedModuleDefinition(f, decl.getId(), analyzedModuleDefinition);
        }
    }

    SpxModuleLookupTable define(ModuleDeclaration decl) {
        this._moduleLookupMap.put(decl.getId(), decl);
        return this;
    }

    private SpxModuleLookupTable addModuleDefinition(SpxSemanticIndexFacade f, IStrategoList id, IStrategoAppl moduleDefinition) throws IOException {
        this._moduleDefinition.put(id, SpxIndexUtils.serializeToString(f.getTermAttachmentSerializer(), moduleDefinition));
        return this;
    }

    private SpxModuleLookupTable addAnalyzedModuleDefinition(SpxSemanticIndexFacade f, IStrategoList id, IStrategoAppl moduleDefinition) throws IOException {
        this._moduleAnalyzedDefinition.put(id, SpxIndexUtils.serializeToString(f.getTermAttachmentSerializer(), moduleDefinition));
        return this;
    }

    public void defineLanguageDescriptor(IStrategoList moduleId, LanguageDescriptor newDesc) {
        if (!this.containsModuleDeclaration(moduleId)) {
            throw new IllegalArgumentException("Unknown Module ID : " + moduleId.toString());
        }
        this._languageDescriptors.put(moduleId, newDesc);
    }

    public LanguageDescriptor getLangaugeDescriptor(IStrategoList id) {
        return (LanguageDescriptor)this._languageDescriptors.get(id);
    }

    public ModuleDeclaration remove(IStrategoList id) {
        this._manager.logMessage(String.valueOf(this.SRC) + ".remove", "Removing following Module : " + id);
        ModuleDeclaration ret = (ModuleDeclaration)this._moduleLookupMap.remove(id);
        if (ret != null) {
            this._manager.logMessage(String.valueOf(this.SRC) + ".remove", "Removed : " + ret);
        } else {
            this._manager.logMessage(String.valueOf(this.SRC) + ".remove", "Could not find : " + ret);
        }
        return ret;
    }

    public ModuleDeclaration getModuleDeclaration(IStrategoList id) {
        return (ModuleDeclaration)this._moduleLookupMap.get(id);
    }

    public boolean containsModuleDeclaration(IStrategoList id) {
        return this._moduleLookupMap.containsKey(id);
    }

    public IStrategoAppl getModuleDefinition(SpxSemanticIndexFacade facade, IStrategoList id) {
        IStrategoTerm deserializedTerm = SpxIndexUtils.deserializeToTerm(facade.getTermFactory(), facade.getTermAttachmentSerializer(), (String)this._moduleDefinition.get(id));
        assert (deserializedTerm instanceof IStrategoAppl) : "Expected IStrategoAppl";
        return (IStrategoAppl)deserializedTerm;
    }

    public IStrategoAppl getAnalyzedModuleDefinition(SpxSemanticIndexFacade f, IStrategoList id) {
        IStrategoTerm deserializedTerm = SpxIndexUtils.deserializeToTerm(f.getTermFactory(), f.getTermAttachmentSerializer(), (String)this._moduleAnalyzedDefinition.get(id));
        assert (deserializedTerm instanceof IStrategoAppl) : "Expected IStrategoAppl";
        return (IStrategoAppl)deserializedTerm;
    }

    public Iterable<ModuleDeclaration> getModuleDeclarationsByUri(String absUri) {
        ArrayList<ModuleDeclaration> ret = new ArrayList<ModuleDeclaration>();
        Iterable foundModuleDecls = (Iterable)this._moduleByFileAbsPath.get(absUri);
        if (foundModuleDecls != null) {
            for (IStrategoList l : foundModuleDecls) {
                ret.add((ModuleDeclaration)this._moduleLookupMap.get(l));
            }
        }
        return ret;
    }

    void verifyUriExists(String uri) {
        if (!this.containsUri(uri)) {
            throw new IllegalArgumentException("Illegal URI argument " + uri);
        }
    }

    private boolean containsUri(String absPath) {
        return this._moduleByFileAbsPath.containsKey(absPath);
    }

    public Iterable<ModuleDeclaration> getModuleDeclarationsByPackageId(IStrategoList packageID) throws SpxSymbolTableException {
        ArrayList<ModuleDeclaration> ret = new ArrayList<ModuleDeclaration>();
        Iterable foundModuleDecls = (Iterable)this._moduleByPackageId.get(packageID);
        if (foundModuleDecls != null) {
            for (IStrategoList l : foundModuleDecls) {
                ret.add(this._moduleByPackageId.getPrimaryValue(l));
            }
        } else {
            throw new SpxSymbolTableException("Unknown Package Id " + packageID.toString());
        }
        return ret;
    }

    private void removeModuleDeclarationByPackageId(IStrategoList packageId) {
        this._manager.logMessage(String.valueOf(this.SRC) + ".removeModuleDeclarationByPackageId", "removing all the enclosed module of package " + packageId);
        ArrayList<IStrategoList> toRemove = new ArrayList<IStrategoList>();
        Iterable foundModuleDecls = (Iterable)this._moduleByPackageId.get(packageId);
        if (foundModuleDecls != null) {
            for (IStrategoList l : foundModuleDecls) {
                toRemove.add(l);
            }
        }
        this._manager.logMessage(String.valueOf(this.SRC) + ".removeModuleDeclarationByPackageId", "removing all the following modules  " + toRemove);
        for (IStrategoList moduleId : toRemove) {
            this.remove(moduleId);
        }
        this._manager.logMessage(String.valueOf(this.SRC) + ".removeModuleDeclarationByPackageId", "operation successful");
    }

    public IStrategoList packageId(IStrategoList moduleId) {
        if (this.containsModuleDeclaration(moduleId)) {
            return this.getModuleDeclaration((IStrategoList)moduleId).enclosingPackageID;
        }
        return null;
    }

    public void removeModuleDeclarationsByUri(String absUri) {
        ArrayList<IStrategoList> delList = new ArrayList<IStrategoList>();
        this._manager.logMessage(String.valueOf(this.SRC) + ".removeModuleDeclarationsByUri", "Removing all the module declared in " + absUri);
        if (this._moduleByFileAbsPath.get(absUri) != null) {
            for (IStrategoList l : (Iterable)this._moduleByFileAbsPath.get(absUri)) {
                delList.add(l);
            }
        }
        this._manager.logMessage(String.valueOf(this.SRC) + ".removeModuleDeclarationsByUri", " Found  " + delList + " to remove from the table.");
        Object[] objectArray = delList.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.remove((IStrategoList)o);
            ++n2;
        }
        this._manager.logMessage(String.valueOf(this.SRC) + ".removeModuleDeclarationsByUri", " removed " + delList + " to remove from the table.");
    }

    public synchronized void clear() {
        this._manager.logMessage(String.valueOf(this.SRC) + ".clear", "Removing " + this.size() + " entries ");
        Iterator keyIter = this._moduleLookupMap.keySet().iterator();
        if (keyIter != null) {
            while (keyIter.hasNext()) {
                this.remove((IStrategoList)keyIter.next());
            }
        }
    }

    @Override
    public RecordListener<String, SpxCompilationUnitInfo> getCompilationUnitRecordListener() {
        return new RecordListener<String, SpxCompilationUnitInfo>(){

            @Override
            public void recordInserted(String key, SpxCompilationUnitInfo value) throws IOException {
            }

            @Override
            public void recordUpdated(String key, SpxCompilationUnitInfo oldValue, SpxCompilationUnitInfo newValue) throws IOException {
                if (oldValue.getVersionNo() != newValue.getVersionNo()) {
                    SpxModuleLookupTable.this.removeModuleDeclarationsByUri(key);
                }
            }

            @Override
            public void recordRemoved(String key, SpxCompilationUnitInfo value) throws IOException {
                SpxModuleLookupTable.this.removeModuleDeclarationsByUri(key);
            }
        };
    }

    public Iterable<ModuleDeclaration> getModuleDeclarations() {
        return this._moduleLookupMap.values();
    }

    @Override
    public RecordListener<IStrategoList, PackageDeclaration> getPackageDeclarationRecordListener() {
        return new RecordListener<IStrategoList, PackageDeclaration>(){

            @Override
            public void recordInserted(IStrategoList packageID, PackageDeclaration value) throws IOException {
            }

            @Override
            public void recordUpdated(IStrategoList packageID, PackageDeclaration oldValue, PackageDeclaration newValue) throws IOException {
            }

            @Override
            public void recordRemoved(IStrategoList packageID, PackageDeclaration value) throws IOException {
                SpxModuleLookupTable.this.removeModuleDeclarationByPackageId(packageID);
            }
        };
    }

    public void addRecordListener(IModuleDeclarationRecordListener rl) {
        this.recordListeners.add(rl.getModuleDeclarationRecordListener());
    }

    public void removeRecordListener(IModuleDeclarationRecordListener rl) {
        this.recordListeners.remove(rl.getModuleDeclarationRecordListener());
    }

    public Iterable<IStrategoList> getModuleIdsByLangaugeName(String langaugeName) {
        HashSet<IStrategoList> mIds = new HashSet<IStrategoList>();
        Iterable<LanguageDescriptor> lDescs = this._modulesByLangaugeName.getPrimaryValues(langaugeName);
        if (lDescs != null) {
            for (LanguageDescriptor l : lDescs) {
                mIds.add(l.getId());
            }
        }
        return mIds;
    }

    public Iterable<IStrategoList> getModuleIdsByLangaugeName(IStrategoString langaugeName) {
        return this.getModuleIdsByLangaugeName(Tools.asJavaString(langaugeName));
    }
}

