/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jdbm.PrimaryHashMap;
import jdbm.RecordListener;
import jdbm.SecondaryHashMap;
import jdbm.SecondaryKeyExtractor;
import org.spoofax.interpreter.library.language.spxlang.index.ICompilationUnitRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.IPackageDeclarationRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxCompilationUnitInfo;
import org.spoofax.interpreter.terms.IStrategoList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpxPackageLookupTable
implements ICompilationUnitRecordListener {
    private final PrimaryHashMap<IStrategoList, PackageDeclaration> _packageLookupTable;
    private final SecondaryHashMap<String, IStrategoList, PackageDeclaration> _uriMap;
    private final SecondaryHashMap<IStrategoList, IStrategoList, PackageDeclaration> _importedToReferences;
    private final String SRC = this.getClass().getSimpleName();
    private final ISpxPersistenceManager _manager;
    protected List<RecordListener<IStrategoList, PackageDeclaration>> recordListeners = new ArrayList<RecordListener<IStrategoList, PackageDeclaration>>();

    public SpxPackageLookupTable(ISpxPersistenceManager manager) {
        assert (manager != null);
        String tableName = String.valueOf(this.SRC) + "_" + manager.getIndexId();
        this._manager = manager;
        this._packageLookupTable = manager.loadHashMap(String.valueOf(manager.getIndexId()) + "._lookupPackageMap.idx");
        this._importedToReferences = this._packageLookupTable.secondaryHashMapManyToOne(String.valueOf(tableName) + "._importedToReferences.idx", new SecondaryKeyExtractor<Iterable<IStrategoList>, IStrategoList, PackageDeclaration>(){

            @Override
            public Iterable<IStrategoList> extractSecondaryKey(IStrategoList key, PackageDeclaration value) {
                HashSet<IStrategoList> values = new HashSet<IStrategoList>();
                values.addAll(value.getImportReferneces());
                return values;
            }
        });
        this._uriMap = this._packageLookupTable.secondaryHashMapManyToOne(String.valueOf(tableName) + "._urimap.idx", new SecondaryKeyExtractor<Iterable<String>, IStrategoList, PackageDeclaration>(){

            @Override
            public Iterable<String> extractSecondaryKey(IStrategoList key, PackageDeclaration value) {
                return value.getAllFilePaths();
            }
        });
        this.initListeners();
    }

    private void initListeners() {
        this._packageLookupTable.addRecordListener(new RecordListener<IStrategoList, PackageDeclaration>(){

            @Override
            public void recordInserted(IStrategoList key, PackageDeclaration value) throws IOException {
            }

            @Override
            public void recordUpdated(IStrategoList key, PackageDeclaration oldValue, PackageDeclaration newValue) throws IOException {
                if (newValue.getAllFilePaths().size() == 0) {
                    SpxPackageLookupTable.this._manager.logMessage(String.valueOf(SpxPackageLookupTable.this.SRC) + ".recordUpdated", "Removing Package " + newValue + " from symbol table as it is not associated with any compunit.");
                    SpxPackageLookupTable.this.remove(key);
                } else if (!SpxPackageLookupTable.this.recordListeners.isEmpty()) {
                    for (RecordListener<IStrategoList, PackageDeclaration> rl : SpxPackageLookupTable.this.recordListeners) {
                        rl.recordUpdated(key, oldValue, newValue);
                    }
                }
            }

            @Override
            public void recordRemoved(IStrategoList key, PackageDeclaration value) throws IOException {
                SpxPackageLookupTable.this._manager.logMessage(String.valueOf(SpxPackageLookupTable.this.SRC) + ".recordUpdated", "Removing Package " + key + ".");
                if (!SpxPackageLookupTable.this.recordListeners.isEmpty()) {
                    for (RecordListener<IStrategoList, PackageDeclaration> rl : SpxPackageLookupTable.this.recordListeners) {
                        rl.recordRemoved(key, value);
                    }
                }
            }
        });
    }

    private boolean containsUri(String absPath) {
        return this._uriMap.containsKey(absPath);
    }

    public int size() {
        return this._packageLookupTable.size();
    }

    public void definePackageDeclaration(PackageDeclaration packageDeclaration) {
        assert (packageDeclaration != null);
        assert (packageDeclaration.getId() != null);
        this._packageLookupTable.put(packageDeclaration.getId(), packageDeclaration);
        this._manager.logMessage(String.valueOf(this.SRC) + ".definePackageDeclaration", "Indexed/Reindexed package declaration : " + packageDeclaration);
    }

    public boolean addPackageDeclarationLocation(IStrategoList packageId, String absPath) {
        assert (packageId != null && absPath != null);
        PackageDeclaration decl = PackageDeclaration.newInstance((PackageDeclaration)this._packageLookupTable.get(packageId));
        if (decl != null) {
            this._manager.logMessage(String.valueOf(this.SRC) + ".addPackageDeclarationLocation", "adding " + absPath + " to following package : " + packageId);
            decl.addFileUri(absPath);
            this.definePackageDeclaration(decl);
            return true;
        }
        return false;
    }

    public void removePackageDeclarationLocation(IStrategoList pId, String absPath) {
        assert (pId != null && absPath != null);
        PackageDeclaration decl = PackageDeclaration.newInstance((PackageDeclaration)this._packageLookupTable.get(pId));
        if (decl == null) {
            throw new IllegalArgumentException("Unknown PackageID : " + pId);
        }
        decl.removeFileUri(absPath);
        this.definePackageDeclaration(decl);
        this._manager.logMessage(String.valueOf(this.SRC) + ".removePackageDeclarationLocation", "removed " + absPath + " from following package : " + decl);
    }

    public PackageDeclaration getPackageDeclaration(IStrategoList id) {
        return (PackageDeclaration)this._packageLookupTable.get(id);
    }

    public Set<PackageDeclaration> getPackageDeclarations() {
        HashSet<PackageDeclaration> declsToReturn = new HashSet<PackageDeclaration>();
        declsToReturn.addAll(this._packageLookupTable.values());
        return declsToReturn;
    }

    public PackageDeclaration remove(IStrategoList id) throws IOException {
        this._manager.logMessage(String.valueOf(this.SRC) + ".remove", "Removing Package " + id + " from symbol table.");
        PackageDeclaration decl = (PackageDeclaration)this._packageLookupTable.remove(id);
        this._manager.logMessage(String.valueOf(this.SRC) + ".remove", "Removed Package " + id + " from symbol table.");
        return decl;
    }

    public Set<PackageDeclaration> packageDeclarationsByUri(String absUri) {
        HashSet<PackageDeclaration> ret = new HashSet<PackageDeclaration>();
        Iterable retList = (Iterable)this._uriMap.get(absUri);
        if (retList != null) {
            for (IStrategoList l : retList) {
                ret.add(this._uriMap.getPrimaryValue(l));
            }
        }
        return ret;
    }

    void verifyUriExists(String uri) {
        if (!this.containsUri(uri)) {
            throw new IllegalArgumentException("Unknown Package Uri " + uri);
        }
    }

    void verifyPackageIDExists(IStrategoList packageId) {
        if (!this.containsPackage(packageId)) {
            throw new IllegalArgumentException("Unknown Package ID : " + packageId);
        }
    }

    public void removePackageDeclarationsByUri(String absUri) {
        this._manager.logMessage(String.valueOf(this.SRC) + ".removePackageDeclarationsByUri", "Removing following Uri for all the package declarations :" + absUri);
        ArrayList<IStrategoList> list = new ArrayList<IStrategoList>();
        Iterable toRemove = (Iterable)this._uriMap.get(absUri);
        if (toRemove != null) {
            for (IStrategoList l : toRemove) {
                list.add(l);
            }
        }
        this._manager.logMessage(String.valueOf(this.SRC) + ".removePackageDeclarationsByUri", "Found entries  " + list + " to update.");
        for (IStrategoList id : list) {
            this.removePackageDeclarationLocation(id, absUri);
        }
    }

    public synchronized void clear() throws IOException {
        this._manager.logMessage(String.valueOf(this.SRC) + ".clear", "Removing " + this.size() + " entries from symbol table ");
        Iterator keyIter = this._packageLookupTable.keySet().iterator();
        if (keyIter != null) {
            while (keyIter.hasNext()) {
                this.remove((IStrategoList)keyIter.next());
            }
        }
    }

    public boolean containsPackage(IStrategoList packageId) {
        return this._packageLookupTable.containsKey(packageId);
    }

    @Override
    public RecordListener<String, SpxCompilationUnitInfo> getCompilationUnitRecordListener() {
        return new RecordListener<String, SpxCompilationUnitInfo>(){

            @Override
            public void recordUpdated(String key, SpxCompilationUnitInfo oldValue, SpxCompilationUnitInfo newValue) throws IOException {
                if (oldValue.getVersionNo() != newValue.getVersionNo()) {
                    this.recordRemoved(key, oldValue);
                }
            }

            @Override
            public void recordRemoved(String key, SpxCompilationUnitInfo value) throws IOException {
                SpxPackageLookupTable.this.removePackageDeclarationsByUri(key);
            }

            @Override
            public void recordInserted(String key, SpxCompilationUnitInfo value) throws IOException {
            }
        };
    }

    public void addRecordListener(IPackageDeclarationRecordListener rl) {
        this.recordListeners.add(rl.getPackageDeclarationRecordListener());
    }

    public void removeRecordListener(IPackageDeclarationRecordListener rl) {
        this.recordListeners.remove(rl.getPackageDeclarationRecordListener());
    }

    public Set<IStrategoList> getImportedToReferencesOf(IStrategoList packageId) {
        HashSet<IStrategoList> pIds = new HashSet<IStrategoList>();
        Iterable<PackageDeclaration> pDecs = this._importedToReferences.getPrimaryValues(packageId);
        if (pDecs != null) {
            for (PackageDeclaration p : pDecs) {
                pIds.add(p.getId());
            }
        }
        return pIds;
    }
}

