/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import jdbm.PrimaryHashMap;
import jdbm.PrimaryStoreMap;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.SpxCompilationUnitTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexConfiguration;
import org.spoofax.interpreter.library.language.spxlang.index.SpxModuleLookupTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPackageLookupTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPrimarySymbolTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpxPersistenceManager
implements ISpxPersistenceManager {
    private static final String SRC = "SpxPersistenceManager";
    private RecordManager _recordManager;
    private final IOAgent _agent;
    private String _indexId;
    private SpxCompilationUnitTable _spxUnitsTable;
    private SpxPackageLookupTable _spxPackageTable;
    private SpxModuleLookupTable _spxModuleTable;
    private SpxPrimarySymbolTable _spxSymbolTable;

    public SpxPersistenceManager(SpxSemanticIndexFacade spxSemanticIndexFacade) throws IOException {
        this(spxSemanticIndexFacade, null);
    }

    private SpxPersistenceManager(SpxSemanticIndexFacade spxSemanticIndexFacade, Properties options) throws IOException {
        assert (spxSemanticIndexFacade != null) : "SpxSemanticIndexFacade is expected to be nonnull";
        this._agent = spxSemanticIndexFacade.getIOAgent();
        this._indexId = spxSemanticIndexFacade.getIndexId();
        if (options == null) {
            options = new Properties();
        }
        options.put("jdbm.index.relativepath", String.valueOf(spxSemanticIndexFacade.getProjectPath()) + "/" + ".spxindex" + "/");
        options.put("jdbm.cache.type", "soft");
        options.put("jdbm.disableTransactions", "false");
        this.tryInitRecordManager(spxSemanticIndexFacade, options);
        this.logMessage("SpxPersistenceManager.ctor", "Instantiation of PersistenceManager is done. Index Directory : [" + BaseRecordManager.DEFAULT_RELATIVE_PATH_INDEX + "] indexid : " + this.getIndexId());
    }

    private void tryInitRecordManager(SpxSemanticIndexFacade spxSemanticIndexFacade, Properties options) throws IOException {
        int noOfTries = 1;
        while (true) {
            try {
                this._recordManager = RecordManagerFactory.createRecordManager(this._indexId, options);
            }
            catch (IOException ex) {
                this.logMessage("SpxPersistenceManager.tryInitRecordManager", "Failed to create recordmanager with arg : " + this._indexId + ". exception : " + ex);
                if (noOfTries == 0) {
                    this.logMessage("SpxPersistenceManager.tryInitRecordManager", "RecordManager creation is failed. Reason : " + ex);
                    throw ex;
                }
                this._indexId = String.valueOf(this._indexId) + "[" + UUID.randomUUID().toString() + "]";
                this.clearCache();
                spxSemanticIndexFacade.tryInvalidatingSpxCacheDirectories();
                --noOfTries;
                continue;
            }
            break;
        }
    }

    @Override
    public void initializeSymbolTables(String projectName, SpxSemanticIndexFacade facade) throws Exception {
        this._spxUnitsTable = new SpxCompilationUnitTable(this);
        this._spxPackageTable = new SpxPackageLookupTable(this);
        this._spxModuleTable = new SpxModuleLookupTable(this);
        this._spxSymbolTable = new SpxPrimarySymbolTable(facade);
        this._spxSymbolTable.addGlobalNamespace(facade);
        this.initListeners();
    }

    private void initListeners() {
        this._spxUnitsTable.addRecordListener(this._spxPackageTable);
        this._spxUnitsTable.addRecordListener(this._spxModuleTable);
        this._spxPackageTable.addRecordListener(this._spxModuleTable);
        this._spxPackageTable.addRecordListener(this._spxSymbolTable);
        this._spxModuleTable.addRecordListener(this._spxSymbolTable);
    }

    @Override
    public <K, V> PrimaryHashMap<K, V> loadHashMap(String mapName) {
        return this._recordManager.hashMap(mapName);
    }

    @Override
    public <V> PrimaryStoreMap<Long, V> loadStoreMap(String storeMapName) {
        return this._recordManager.storeMap(storeMapName);
    }

    @Override
    public void commit() throws IOException {
        this.spxSymbolTable().commitChanges();
        if (!this.isClosed()) {
            this._recordManager.commit();
        }
    }

    @Override
    public void close() throws IOException {
        this.spxSymbolTable().commitChanges();
        if (!this.isClosed()) {
            this._recordManager.close();
        }
        this._spxModuleTable = null;
        this._spxPackageTable = null;
        this._spxUnitsTable = null;
        this._spxSymbolTable = null;
    }

    @Override
    public void commitAndClose() throws IOException {
        this.commit();
        this.close();
    }

    @Override
    public SpxCompilationUnitTable spxCompilcationUnitTable() {
        return this._spxUnitsTable;
    }

    @Override
    public boolean isClosed() {
        return this._recordManager == null ? true : this._recordManager.IsClosed();
    }

    @Override
    public SpxPackageLookupTable spxPackageTable() {
        return this._spxPackageTable;
    }

    @Override
    public SpxModuleLookupTable spxModuleTable() {
        return this._spxModuleTable;
    }

    @Override
    public void clear() throws IOException {
        try {
            this._spxUnitsTable.clear();
            this._spxPackageTable.clear();
            this._spxModuleTable.clear();
            this._spxSymbolTable.clear();
            this.logMessage("SpxPersistenceManager.clearAll", "SymbolTable is cleaned successfully. ");
        }
        catch (IOException ex) {
            this.logMessage("SpxPersistenceManager.clearAll", "Exception occured . " + ex);
            throw ex;
        }
    }

    @Override
    public void logMessage(String origin, String message) {
        if (SpxIndexConfiguration.shouldPrintDebugInfo()) {
            try {
                this._agent.getWriter(1).write("[" + this._indexId + "." + origin + "]   " + message + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getIndexId() {
        return this._indexId;
    }

    @Override
    public SpxPrimarySymbolTable spxSymbolTable() {
        return this._spxSymbolTable;
    }

    @Override
    public void rollback() throws IOException {
        this._recordManager.rollback();
    }

    @Override
    public void clearCache() throws IOException {
        if (this._recordManager instanceof CacheRecordManager) {
            this._recordManager.clearCache();
        }
    }
}

