/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import jdbm.PrimaryMap;
import jdbm.RecordListener;
import jdbm.SecondaryHashMap;
import jdbm.SecondaryKeyExtractor;
import org.spoofax.interpreter.library.language.spxlang.index.GlobalNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.IModuleDeclarationRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespaceResolver;
import org.spoofax.interpreter.library.language.spxlang.index.IPackageDeclarationRecordListener;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.LocalNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.PackageNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexUtils;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.ModuleDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.NamespaceUri;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableEntry;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpxPrimarySymbolTable
implements INamespaceResolver,
IPackageDeclarationRecordListener,
IModuleDeclarationRecordListener {
    private final String SRC = this.getClass().getSimpleName();
    private transient INamespace _activeNamespace;
    private final SpxSemanticIndexFacade _facade;
    private final PrimaryMap<NamespaceUri, INamespace> namespaces;
    private final PrimaryMap<String, Long> timestamps;
    private final SecondaryHashMap<IStrategoList, NamespaceUri, INamespace> namespaceByStrategoId;
    private static final String INITIALIZED_ON_KEY = "INITIALIZED_ON";
    private static final String LAST_CODEGEN_ON_KEY = "LAST_CODEGEN_ON";

    public SpxPrimarySymbolTable(SpxSemanticIndexFacade facade) throws SecurityException, IOException {
        assert (facade != null) : "SpxSemanticIndexFacade  is expected to non-null";
        this._facade = facade;
        String tableName = String.valueOf(facade.getPersistenceManager().getIndexId()) + "primary_symbol_table.idx";
        this.timestamps = facade.getPersistenceManager().loadHashMap(String.valueOf(tableName) + "timestamps.idx");
        this.namespaces = facade.getPersistenceManager().loadHashMap(String.valueOf(tableName) + "namespaces.idx");
        this.namespaceByStrategoId = this.namespaces.secondaryHashMap(String.valueOf(tableName) + ".namespaceByStrategoId.idx", new SecondaryKeyExtractor<IStrategoList, NamespaceUri, INamespace>(){

            @Override
            public IStrategoList extractSecondaryKey(NamespaceUri k, INamespace v) {
                return k.id();
            }
        });
    }

    private ISpxPersistenceManager persistenceManager() {
        return this._facade.getPersistenceManager();
    }

    public void addGlobalNamespace(SpxSemanticIndexFacade facade) {
        this.defineNamespace(GlobalNamespace.createInstance(facade));
    }

    public void defineNamespace(INamespace namespace) {
        if (!this.containsNamespace(namespace)) {
            this.namespaces.put(namespace.namespaceUri(), namespace);
        }
    }

    public NamespaceUri toNamespaceUri(IStrategoList spoofaxId) {
        NamespaceUri uri = this.getNamespaceUri(spoofaxId);
        if (uri == null) {
            uri = new NamespaceUri(spoofaxId);
        }
        return uri;
    }

    @Override
    public INamespace resolveNamespace(IStrategoList id) {
        if (this._activeNamespace != null && this._activeNamespace.namespaceUri().equalSpoofaxId(id)) {
            return this._activeNamespace;
        }
        boolean alreadyFoundNamespace = false;
        int foundNamespaces = 0;
        INamespace toReturn = null;
        Iterable<INamespace> resolvedNamespaces = this.namespaceByStrategoId.getPrimaryValues(id);
        if (resolvedNamespaces != null) {
            for (INamespace n : resolvedNamespaces) {
                if (!alreadyFoundNamespace) {
                    alreadyFoundNamespace = true;
                    toReturn = n;
                }
                ++foundNamespaces;
            }
            if (foundNamespaces > 1) {
                throw new IllegalStateException(String.format("More than one Namespace found with the following spoofax Id : %s", id.toString()));
            }
        }
        return toReturn;
    }

    @Override
    public INamespace resolveNamespace(NamespaceUri id) {
        if (this._activeNamespace != null && this._activeNamespace.namespaceUri().equals(id)) {
            return this._activeNamespace;
        }
        return (INamespace)this.namespaces.get(id);
    }

    private INamespace removeNamespace(INamespace nsToRemove) {
        if (nsToRemove != null) {
            if (nsToRemove instanceof PackageNamespace) {
                NamespaceUri internalNamespaceUri = PackageNamespace.packageInternalNamespace(nsToRemove.namespaceUri(), this._facade);
                INamespace internalNS = (INamespace)this.namespaces.remove(internalNamespaceUri);
                if (internalNS != null) {
                    this.persistenceManager().logMessage(this.SRC, "removenamespace | removed internal namespace: " + internalNS);
                } else {
                    this.persistenceManager().logMessage(this.SRC, "removenamespace | could not find internal namespace");
                }
            }
            this.persistenceManager().logMessage(this.SRC, "removenamespace | removing following namespace : " + nsToRemove);
            INamespace retNs = (INamespace)this.namespaces.remove(nsToRemove.namespaceUri());
            if (retNs != null) {
                this.persistenceManager().logMessage(this.SRC, "removenamespace | removed namespace: " + retNs);
            } else {
                this.persistenceManager().logMessage(this.SRC, "removenamespace | could not find namespace");
            }
        }
        return nsToRemove;
    }

    private INamespace removeNamespaceByUri(NamespaceUri id) {
        INamespace nsToRemove = this.resolveNamespace(id);
        return this.removeNamespace(nsToRemove);
    }

    public INamespace removeNamespaceById(IStrategoList id) {
        INamespace nsToRemove = this.resolveNamespace(id);
        return this.removeNamespace(nsToRemove);
    }

    public NamespaceUri getNamespaceUri(IStrategoList id) {
        Iterator iterator;
        Iterable uriIterator = (Iterable)this.namespaceByStrategoId.get(id);
        if (uriIterator != null && (iterator = uriIterator.iterator()).hasNext()) {
            NamespaceUri uri = (NamespaceUri)iterator.next();
            return uri;
        }
        return null;
    }

    @Override
    public boolean containsNamespace(IStrategoList id) {
        return this.namespaceByStrategoId.containsKey(id);
    }

    public boolean containsNamespace(NamespaceUri namespaceId) {
        return this.namespaces.containsKey(namespaceId);
    }

    public boolean containsNamespace(INamespace namespace) {
        return this.containsNamespace(namespace.namespaceUri());
    }

    public void clear() {
        Set keys = this.namespaces.keySet();
        ArrayList<NamespaceUri> namespacesToRemove = new ArrayList<NamespaceUri>();
        for (NamespaceUri u : keys) {
            namespacesToRemove.add(u);
        }
        for (NamespaceUri uriToRemove : namespacesToRemove) {
            this.removeNamespaceByUri(uriToRemove);
        }
        this.ensureActiveNamespaceUnloaded(this._activeNamespace);
        this.timestamps.clear();
    }

    public int size() {
        return this.namespaces.size();
    }

    public String toString() {
        return "SpxPrimarySymbolTable ( defined namespaces : " + this.namespaces.keySet() + ")";
    }

    @Override
    public Set<NamespaceUri> getAllNamespaces() {
        return this.namespaces.keySet();
    }

    public void defineSymbol(IStrategoList namespaceId, SpxSymbolTableEntry symTableEntry) throws SpxSymbolTableException {
        INamespace currentNamespace = this.activateNamespace(namespaceId);
        this.persistenceManager().logMessage(this.SRC, "defineSymbol (Thread Id :" + Thread.currentThread().getId() + ")| defining symbols with the following criteria :  namespace " + namespaceId + " with Key : " + symTableEntry.key + " Value : " + symTableEntry.value);
        currentNamespace.define(symTableEntry, this._facade);
    }

    public Set<SpxSymbol> undefineSymbols(IStrategoList namespaceId, IStrategoTerm symbolId, IStrategoConstructor symbolType) throws SpxSymbolTableException {
        this.persistenceManager().logMessage(this.SRC, "undefineSymbol | undefineSymbol symbol with the following criteria :  search origin " + namespaceId + " with Key : " + symbolId + "of Type : " + symbolType.getName());
        INamespace currentNamespace = this.activateNamespace(namespaceId);
        Set<SpxSymbol> undefinedSymbols = currentNamespace.undefineSymbols(symbolId, symbolType, this._facade);
        this.persistenceManager().logMessage(this.SRC, "undefineSymbol | undefineSymbol Symbols : " + undefinedSymbols);
        return undefinedSymbols;
    }

    public Collection<SpxSymbol> resolveSymbols(IStrategoList namespaceId, IStrategoTerm symbolId, IStrategoConstructor symbolType, int lookupDepth, boolean returnDuplicates) throws SpxSymbolTableException {
        this.persistenceManager().logMessage(this.SRC, "resolveSymbols | Resolving symbols with the following criteria :  search origin " + namespaceId + " with Key : " + symbolId + " of Type : " + symbolType.getName());
        INamespace namespace = this.activateNamespace(namespaceId);
        Collection<SpxSymbol> resolvedSymbols = namespace.resolveAll(this._facade, symbolId, symbolType, lookupDepth, returnDuplicates);
        this.persistenceManager().logMessage(this.SRC, "resolveSymbols | Resolved Symbols : " + resolvedSymbols);
        return resolvedSymbols;
    }

    public SpxSymbol resolveSymbol(IStrategoList namespaceId, IStrategoTerm symbolId, IStrategoConstructor symbolType, int lookupDepth) throws SpxSymbolTableException {
        this.persistenceManager().logMessage(this.SRC, "resolveSymbol | Resolving symbol with the following criteria :  search origin " + namespaceId + " with Key : " + symbolId + "of Type : " + symbolType.getName());
        INamespace namespace = this.activateNamespace(namespaceId);
        SpxSymbol resolvedSymbol = namespace.resolve(symbolId, symbolType, this._activeNamespace, this._facade, lookupDepth);
        this.persistenceManager().logMessage(this.SRC, "resolveSymbol | Resolved Symbol : " + resolvedSymbol);
        return resolvedSymbol;
    }

    public INamespace newAnonymousNamespace(IStrategoList enclosingNamespaceId) throws SpxSymbolTableException {
        this.persistenceManager().logMessage(this.SRC, "newAnonymousNamespace | Inserting a Anonymous Namespace in following enclosing namespace : " + enclosingNamespaceId);
        INamespace currentNamespace = this.activateNamespace(enclosingNamespaceId);
        INamespace localNamespace = LocalNamespace.createInstance(this._facade, currentNamespace);
        this.defineNamespace(localNamespace);
        this.commitChanges();
        this.persistenceManager().logMessage(this.SRC, "newAnonymousNamespace | Folloiwng namesapce is created : " + localNamespace);
        return localNamespace;
    }

    public INamespace destroyNamespace(IStrategoList namespaceId) throws SpxSymbolTableException {
        this.persistenceManager().logMessage(this.SRC, "destroyNamespace | Removing the following namespace : " + namespaceId);
        INamespace ns = this.removeNamespaceById(namespaceId);
        this.ensureActiveNamespaceUnloaded(namespaceId);
        this.persistenceManager().logMessage(this.SRC, "destroyNamespace | Folloiwng namesapce is removed : " + ns);
        return ns;
    }

    @Override
    public RecordListener<IStrategoList, PackageDeclaration> getPackageDeclarationRecordListener() {
        return new RecordListener<IStrategoList, PackageDeclaration>(){

            @Override
            public void recordInserted(IStrategoList packageID, PackageDeclaration value) throws IOException {
            }

            @Override
            public void recordUpdated(IStrategoList packageID, PackageDeclaration oldValue, PackageDeclaration newValue) throws IOException {
            }

            @Override
            public void recordRemoved(IStrategoList packageID, PackageDeclaration value) throws IOException {
                SpxPrimarySymbolTable.this.removeNamespaceById(packageID);
            }
        };
    }

    @Override
    public RecordListener<IStrategoList, ModuleDeclaration> getModuleDeclarationRecordListener() {
        return new RecordListener<IStrategoList, ModuleDeclaration>(){

            @Override
            public void recordInserted(IStrategoList key, ModuleDeclaration value) throws IOException {
            }

            @Override
            public void recordUpdated(IStrategoList key, ModuleDeclaration oldValue, ModuleDeclaration newValue) throws IOException {
            }

            @Override
            public void recordRemoved(IStrategoList moduleId, ModuleDeclaration value) throws IOException {
                SpxPrimarySymbolTable.this.removeNamespaceById(moduleId);
            }
        };
    }

    public void cleanGlobalNamespace(SpxSemanticIndexFacade spxSemanticIndexFacade) {
        this.persistenceManager().logMessage(this.SRC, "clearGlobalNamespce | Remove all the entries stored currently in GlobalNamespace");
        IStrategoList gnsId = GlobalNamespace.getGlobalNamespaceId(spxSemanticIndexFacade);
        INamespace gns = this.resolveNamespace(gnsId);
        if (gns != null) {
            gns.clear();
        }
        this.namespaces.put(gns.namespaceUri(), gns);
        this.persistenceManager().logMessage(this.SRC, "clearGlobalNamespce | Successfully removed all the entries.");
    }

    public synchronized void commitChanges() {
        if (this._activeNamespace != null) {
            this.namespaces.put(this._activeNamespace.namespaceUri(), this._activeNamespace);
        }
    }

    private void ensureActiveNamespaceUnloaded(INamespace namespace) {
        if (namespace != null) {
            this.ensureActiveNamespaceUnloaded(namespace.namespaceUri().id());
        }
    }

    private synchronized void ensureActiveNamespaceUnloaded(IStrategoList namespaceId) {
        if (this._activeNamespace != null && this._activeNamespace.namespaceUri().equalSpoofaxId(namespaceId)) {
            this._activeNamespace = null;
        }
    }

    private synchronized INamespace activateNamespace(IStrategoList namespaceId) throws SpxSymbolTableException {
        if (this._activeNamespace == null || !this._activeNamespace.namespaceUri().equalSpoofaxId(namespaceId)) {
            this.commitChanges();
            this._activeNamespace = this.resolveNamespace(namespaceId);
            if (this._activeNamespace == null) {
                throw new RuntimeException("Unknown namespaceId: " + namespaceId + ". Namespace can not be resolved from symbol-table");
            }
        }
        return this._activeNamespace;
    }

    long getIndexLastInitializedOn() {
        Long initializedOn = (Long)this.timestamps.get(INITIALIZED_ON_KEY);
        if (initializedOn == null) {
            return 0L;
        }
        return initializedOn;
    }

    void setIndexUpdatedOn(long timestamp) {
        this.timestamps.put(INITIALIZED_ON_KEY, timestamp);
    }

    long getLastCodeGeneratedOn() {
        Long lastCodeGenOn = (Long)this.timestamps.get(LAST_CODEGEN_ON_KEY);
        if (lastCodeGenOn == null) {
            return 0L;
        }
        return lastCodeGenOn;
    }

    void setLastCodeGeneratedOn(long timestamp) {
        this.timestamps.put(LAST_CODEGEN_ON_KEY, timestamp);
    }

    public void printSymbols(SpxSemanticIndexFacade f, String state, String projectPath, String indexId) throws IOException, SpxSymbolTableException {
        new File(String.valueOf(projectPath) + "/" + ".spxindex" + "/.log").mkdirs();
        FileWriter fstream = new FileWriter(String.valueOf(projectPath) + "/" + ".spxindex" + "/.log/" + indexId + "_symbols_" + SpxIndexUtils.now("yyyy-MM-dd HH.mm.ss.SSS") + ".csv", true);
        BufferedWriter out = new BufferedWriter(fstream);
        out.write(", , ,------------- Logging [" + state + "] state of Symbol-Table at :" + SpxIndexUtils.now("yyyy-MM-dd HH.mm.ss") + "-------------\n");
        try {
            try {
                if (this.namespaces != null) {
                    for (INamespace ns : this.namespaces.values()) {
                        out.write("\n, --- " + SpxIndexUtils.getCsvFormatted(ns.toString()) + "--- \n");
                        SpxIndexUtils.logEntries(f, ns, out);
                    }
                }
            }
            catch (IOException iOException) {
                out.close();
            }
        }
        finally {
            out.close();
        }
    }
}

