/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexManager;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacadeRegistry;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;

public class SpxSemanticIndex {
    private final SpxSemanticIndexFacadeRegistry _facadeRegistry = new SpxSemanticIndexFacadeRegistry();

    public SpxSemanticIndexFacadeRegistry getFacadeRegistry() {
        return this._facadeRegistry;
    }

    public boolean indexImportReferences(IStrategoString projectPath, final IStrategoAppl importReferences) throws Exception {
        SpxIndexer idx = new SpxIndexer(){

            public void index(IStrategoString projectPath, IStrategoAppl appl) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                idxFacade.indexImportReferences(importReferences);
            }
        };
        return idx.executeIndexer(projectPath, importReferences);
    }

    public boolean indexSymbolDefinition(IStrategoString projectPath, final IStrategoAppl symbolDef) throws Exception {
        SpxIndexer idx = new SpxIndexer(){

            public void index(IStrategoString projectPath, IStrategoAppl appl) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                idxFacade.indexSymbol(symbolDef);
            }
        };
        return idx.executeIndexer(projectPath, symbolDef);
    }

    public boolean indexModuleDefinition(IStrategoString projectPath, final IStrategoAppl moduleDefinition) throws Exception {
        SpxIndexer idx = new SpxIndexer(){

            public void index(IStrategoString projectPath, IStrategoAppl appl) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                idxFacade.indexModuleDefinition(moduleDefinition);
            }
        };
        return idx.executeIndexer(projectPath, moduleDefinition);
    }

    public boolean indexPackageDeclaration(IStrategoString projectPath, final IStrategoAppl packageDecl) throws Exception {
        SpxIndexer idx = new SpxIndexer(){

            public void index(IStrategoString projectPath, IStrategoAppl appl) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                idxFacade.indexPackageDeclaration(packageDecl);
            }
        };
        return idx.executeIndexer(projectPath, packageDecl);
    }

    public boolean indexLanguageDescriptor(IStrategoString projectPath, final IStrategoAppl languageDescriptor) throws Exception {
        return new SpxIndexer(){

            public void index(IStrategoString projectPath, IStrategoAppl appl) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                idxFacade.indexLanguageDescriptor(languageDescriptor);
            }
        }.executeIndexer(projectPath, languageDescriptor);
    }

    public boolean indexCompilationUnit(IStrategoString projectPath, IStrategoString spxCompilationUnitPath, IStrategoAppl spxCompilationUnitAST) throws IllegalStateException, Exception {
        SpxSemanticIndexFacade idxFacade = this.getFacade(projectPath);
        idxFacade.indexCompilationUnit(spxCompilationUnitPath, spxCompilationUnitAST);
        return true;
    }

    public IStrategoTerm getCompilationUnit(IStrategoString projectPath, IStrategoString spxCompilationUnitPath) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm term) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getCompilationUnit((IStrategoString)term);
            }
        }.executeWith(projectPath, spxCompilationUnitPath);
    }

    public IStrategoTerm getPackageDeclaration(IStrategoString projectPath, IStrategoAppl packageTypedQname) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm term) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getPackageDeclaration((IStrategoAppl)term);
            }
        }.executeWith(projectPath, packageTypedQname);
    }

    public IStrategoTerm getRelatedFilesOfPackages(IStrategoString projectPath, IStrategoList packageList) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm term) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getRelatedFilesOfPackages((IStrategoList)term);
            }
        }.executeWith(projectPath, packageList);
    }

    public IStrategoTerm getPackageDeclarationsByUri(IStrategoString projectPath, IStrategoString compilationUnitUri) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm term) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getPackageDeclarations((IStrategoString)term);
            }
        }.executeWith(projectPath, compilationUnitUri);
    }

    public IStrategoTerm getPackageDeclarationsByLanguageName(IStrategoString projectPath, IStrategoString compilationUnitUri) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm term) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getPackageDeclarationsByLanguageName((IStrategoString)term);
            }
        }.executeWith(projectPath, compilationUnitUri);
    }

    public IStrategoTerm getModuleDeclaration(IStrategoString projectPath, IStrategoAppl moduleTypedQname) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm qname) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getModuleDeclaration((IStrategoAppl)qname);
            }
        }.executeWith(projectPath, moduleTypedQname);
    }

    public IStrategoTerm getImports(IStrategoString projectPath, IStrategoAppl namespaceID) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm namespaceID) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getImportReferences((IStrategoAppl)namespaceID);
            }
        }.executeWith(projectPath, namespaceID);
    }

    public IStrategoTerm getImportedToReferences(IStrategoString projectPath, IStrategoAppl namespaceID) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm namespaceID) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getImportedToReferences((IStrategoAppl)namespaceID);
            }
        }.executeWith(projectPath, namespaceID);
    }

    public IStrategoTerm getModuleDeclarations(IStrategoString projectPath, IStrategoTerm searchQuery) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm res) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getModuleDeclarationsOf((IStrategoTuple)res);
            }
        }.executeWith(projectPath, searchQuery);
    }

    public IStrategoTerm insertNewScope(IStrategoString projectPath, IStrategoAppl namespaceAppl) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm ns) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.insertNewScope((IStrategoAppl)ns);
            }
        }.executeWith(projectPath, namespaceAppl);
    }

    public IStrategoTerm destroyScope(IStrategoString projectPath, IStrategoAppl namespaceAppl) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm ns) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.destroyScope((IStrategoAppl)ns);
            }
        }.executeWith(projectPath, namespaceAppl);
    }

    public IStrategoTerm getModuleDefinition(IStrategoString projectPath, IStrategoAppl moduleTypedQname) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm qname) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getModuleDefinition((IStrategoAppl)qname);
            }
        }.executeWith(projectPath, moduleTypedQname);
    }

    public IStrategoTerm getLanguageDescriptor(IStrategoString projectPath, IStrategoAppl packageTypedQname) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm qname) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.getLanguageDescriptor((IStrategoAppl)qname);
            }
        }.executeWith(projectPath, packageTypedQname);
    }

    public IStrategoTerm resolveSymbols(IStrategoString projectPath, IStrategoTuple searchCriteria) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm qname) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.resolveSymbols((IStrategoTuple)qname);
            }
        }.executeWith(projectPath, searchCriteria);
    }

    public SpxSymbol verifySymbolExists(IStrategoString projectPath, final IStrategoTuple searchCriteria) throws Exception {
        return (SpxSymbol)new SpxResolver(){

            public SpxSymbol resolve(IStrategoString projectPath, IStrategoTerm qnamesearchCriteria) throws Exception {
                SpxSemanticIndexFacade idxFacade = SpxSemanticIndex.this.getFacade(projectPath);
                return idxFacade.verifySymbolExists(searchCriteria);
            }
        }.executeWith(projectPath, searchCriteria);
    }

    public IStrategoTerm undefineSymbols(IStrategoString projectPath, IStrategoTuple searchCriteria) throws Exception {
        return (IStrategoTerm)new SpxResolver(){

            public IStrategoTerm resolve(IStrategoString projectPath, IStrategoTerm searchCriteria) throws Exception {
                SpxSemanticIndexFacade f = SpxSemanticIndex.this.getFacade(projectPath);
                return f.undefineSymbols((IStrategoTuple)searchCriteria);
            }
        }.executeWith(projectPath, searchCriteria);
    }

    public boolean removeCompilationUnit(IStrategoString projectPath, IStrategoString spxCompilationUnitPath) throws Exception {
        SpxSemanticIndexFacade idxFacade = this.getFacade(projectPath);
        idxFacade.removeCompilationUnit(spxCompilationUnitPath);
        return true;
    }

    SpxSemanticIndexFacade getFacade(IStrategoTerm projectPath) throws Exception {
        SpxSemanticIndexFacade f = this._facadeRegistry.getFacade(projectPath);
        SpxIndexManager.ensureFacadeInitialized(f);
        return f;
    }

    private abstract class SpxIndexer {
        private SpxIndexer() {
        }

        public boolean executeIndexer(IStrategoString projectPath, IStrategoAppl appl) throws Exception {
            this.index(projectPath, appl);
            return true;
        }

        public abstract void index(IStrategoString var1, IStrategoAppl var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SpxResolver {
        private SpxResolver() {
        }

        public <U> U executeWith(IStrategoString projectPath, IStrategoTerm term) throws Exception {
            return this.resolve(projectPath, term);
        }

        public abstract <U> U resolve(IStrategoString var1, IStrategoTerm var2) throws Exception;
    }
}

