/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.spxlang.index.GlobalNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespaceFactory;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.LocalNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxCompilationUnitTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxConstructors;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexConfiguration;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexUtils;
import org.spoofax.interpreter.library.language.spxlang.index.SpxModuleLookupTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPackageLookupTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPrimarySymbolTable;
import org.spoofax.interpreter.library.language.spxlang.index.data.IdentifiableConstruct;
import org.spoofax.interpreter.library.language.spxlang.index.data.LanguageDescriptor;
import org.spoofax.interpreter.library.language.spxlang.index.data.ModuleDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.ModuleDefinition;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxCompilationUnitInfo;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableEntry;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermConverter;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.attachments.TermAttachmentSerializer;
import org.spoofax.terms.attachments.TermAttachmentStripper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpxSemanticIndexFacade {
    private ISpxPersistenceManager _persistenceManager;
    private final SpxConstructors _spxConstructors;
    private String _indexId;
    private final String _projectPath;
    private long _currentCodeGenerationStratedOn;
    private long _currentIndexUpdatingStartedOn;
    private final ITermFactory _termFactory;
    private final IOAgent _agent;
    private final TermAttachmentStripper _stripper;
    private final TermAttachmentSerializer _termAttachmentSerializer;
    private final TermConverter _converter;

    public SpxSemanticIndexFacade(IStrategoTerm projectPath, ITermFactory termFactory, IOAgent agent) {
        this._projectPath = Tools.asJavaString(projectPath);
        this._indexId = String.valueOf(this.getProjectName());
        this._termFactory = termFactory;
        this._agent = agent;
        this._stripper = new TermAttachmentStripper(this._termFactory);
        this._converter = new TermConverter(this._termFactory);
        this._converter.setOriginEnabled(true);
        this._termAttachmentSerializer = new TermAttachmentSerializer(this._termFactory);
        this._spxConstructors = new SpxConstructors(this._termFactory);
    }

    public synchronized void initializePersistenceManager() throws Exception {
        this._persistenceManager = new SpxPersistenceManager(this);
        this._persistenceManager.initializeSymbolTables(this._projectPath, this);
        this._indexId = this._persistenceManager.getIndexId();
    }

    protected void finalize() throws Throwable {
        try {
            try {
                this.close(true);
            }
            catch (Exception exception) {
                super.finalize();
            }
        }
        finally {
            super.finalize();
        }
    }

    public SpxConstructors getCons() {
        return this._spxConstructors;
    }

    public TermAttachmentSerializer getTermAttachmentSerializer() {
        return this._termAttachmentSerializer;
    }

    public String getIndexId() {
        return this._indexId;
    }

    public ITermFactory getTermFactory() {
        return this._termFactory;
    }

    public TermConverter getTermConverter() {
        return this._converter;
    }

    public String getProjectPath() {
        return SpxIndexUtils.toAbsPathString(this._projectPath);
    }

    public String getProjectName() {
        return new File(this._projectPath).getName();
    }

    public ISpxPersistenceManager getPersistenceManager() {
        return this._persistenceManager;
    }

    synchronized void onInitIndexUpdating() {
        this._currentIndexUpdatingStartedOn = System.currentTimeMillis();
    }

    synchronized void onIndexUpatingCompleted() {
        ISpxPersistenceManager manager = this.getPersistenceManager();
        manager.spxSymbolTable().setIndexUpdatedOn(this._currentIndexUpdatingStartedOn);
    }

    synchronized void onInitCodeGeneration() {
        this._currentCodeGenerationStratedOn = System.currentTimeMillis();
    }

    synchronized void onCompleteCodeGeneration() {
        ISpxPersistenceManager manager = this.getPersistenceManager();
        manager.spxSymbolTable().setLastCodeGeneratedOn(this._currentCodeGenerationStratedOn);
    }

    public IStrategoTerm getCompilationUnit(IStrategoString spxCompilationUnitPath) {
        IStrategoAppl retTerm = null;
        URI resUri = this.toFileURI(spxCompilationUnitPath);
        this.logMessage("SpxSemanticIndexFacade.getCompilationUnit . Arguments : " + spxCompilationUnitPath);
        SpxCompilationUnitTable table = this.getPersistenceManager().spxCompilcationUnitTable();
        IStrategoAppl term = (IStrategoAppl)table.get(this, resUri);
        if (term != null) {
            retTerm = SpxSemanticIndexFacade.forceImploderAttachment(term, resUri);
        }
        this.logMessage("SpxSemanticIndexFacade.getCompilationUnit :  Returning Following APPL for uri " + resUri + " : " + retTerm);
        return retTerm;
    }

    public SpxCompilationUnitInfo getCompilationUnitInfo(String absUriPath) {
        URI resUri = SpxIndexUtils.getAbsolutePathUri(absUriPath, this._agent);
        SpxCompilationUnitTable table = this.getPersistenceManager().spxCompilcationUnitTable();
        return table.getInfo(this, resUri);
    }

    public void removeCompilationUnit(IStrategoString spxCompilationUnitPath) throws IOException {
        URI resUri = this.toFileURI(spxCompilationUnitPath);
        SpxCompilationUnitTable table = this.getPersistenceManager().spxCompilcationUnitTable();
        table.remove(resUri);
    }

    public void indexCompilationUnit(IStrategoString spxCompilationUnitPath, IStrategoAppl spxCompilationUnitAST) throws IOException {
        URI resUri = this.toFileURI(spxCompilationUnitPath);
        IStrategoTerm astTerm = this.toCompactPositionInfo(spxCompilationUnitAST);
        SpxCompilationUnitTable table = this.getPersistenceManager().spxCompilcationUnitTable();
        this.logMessage("Storing following compilation unit. Path : [" + spxCompilationUnitPath + "]");
        table.define(this, resUri, astTerm);
    }

    public void indexModuleDefinition(IStrategoAppl moduleDefinition) throws IllegalArgumentException, IOException {
        this.verifyConstructor(moduleDefinition.getConstructor(), this.getCons().getModuleDefCon(), "Illegal Module Definition");
        this.indexModuleDefinition(Tools.applAt(moduleDefinition, 0), Tools.stringAt(moduleDefinition, 1), Tools.applAt(moduleDefinition, 2), Tools.applAt(moduleDefinition, 3), Tools.applAt(moduleDefinition, 4));
    }

    public void indexModuleDefinition(IStrategoAppl moduleQName, IStrategoString spxCompilationUnitPath, IStrategoAppl packageQName, IStrategoAppl ast, IStrategoAppl analyzedAst) throws IOException {
        SpxModuleLookupTable table = this.getPersistenceManager().spxModuleTable();
        IStrategoList moduleId = ModuleDeclaration.getModuleId(this, moduleQName);
        IStrategoList packageId = PackageDeclaration.getPackageId(this, packageQName);
        this.getPersistenceManager().spxPackageTable().verifyPackageIDExists(packageId);
        moduleId = (IStrategoList)this.strip(moduleId);
        packageId = (IStrategoList)this.strip(packageId);
        SpxCompilationUnitInfo info = this.getCompilationUnitInfo(this.toAbsulatePath(spxCompilationUnitPath));
        if (info == null) {
            throw new IllegalStateException("Related compilation unit is no longer exists in symbols table ");
        }
        ModuleDeclaration mDecl = new ModuleDeclaration(info.getAbsPathString(), moduleId, packageId);
        mDecl.setLastModifiedOn(info.getLastModifiedOn());
        table.define(this, mDecl, ast, analyzedAst);
        this.defineNamespace(mDecl);
    }

    public void indexPackageDeclaration(IStrategoAppl packageDeclaration) {
        this.verifyConstructor(packageDeclaration.getConstructor(), this.getCons().getPackageDeclCon(), "Illegal PackageDeclaration");
        this.indexPackageDeclaration((IStrategoAppl)packageDeclaration.getSubterm(0), (IStrategoString)packageDeclaration.getSubterm(1));
    }

    public void indexPackageDeclaration(IStrategoAppl packageIdAppl, IStrategoString spxCompilationUnitPath) {
        SpxPackageLookupTable table = this.getPersistenceManager().spxPackageTable();
        SpxCompilationUnitTable spxTable = this.getPersistenceManager().spxCompilcationUnitTable();
        IStrategoList packageId = PackageDeclaration.getPackageId(this, packageIdAppl);
        spxCompilationUnitPath = (IStrategoString)this.toCompactPositionInfo(spxCompilationUnitPath);
        String absFilePath = this.toAbsulatePath(spxCompilationUnitPath);
        spxTable.verifyUriExists(absFilePath);
        packageId = (IStrategoList)this.toCompactPositionInfo(packageId);
        if (table.containsPackage(packageId)) {
            table.addPackageDeclarationLocation(packageId, absFilePath);
        } else {
            PackageDeclaration pDecl = new PackageDeclaration(absFilePath, packageId);
            table.definePackageDeclaration(pDecl);
            this.defineNamespace(pDecl);
        }
    }

    public IStrategoTerm insertNewScope(IStrategoAppl namespaceAppl) throws SpxSymbolTableException {
        IStrategoList parentId = this.getNamespaceId(namespaceAppl);
        SpxPrimarySymbolTable symbolTable = this.getPersistenceManager().spxSymbolTable();
        INamespace ns = symbolTable.newAnonymousNamespace(parentId);
        return this.getTermFactory().makeAppl(this.getCons().getLocalNamespaceTypeCon(), ns.namespaceUri().id());
    }

    public IStrategoTerm destroyScope(IStrategoAppl namespaceAppl) throws SpxSymbolTableException {
        this.verifyConstructor(namespaceAppl.getConstructor(), this.getCons().getLocalNamespaceTypeCon(), "Expected LocalNamespace. This operation has not been implementated for other type of Namespace.");
        IStrategoList id = this.getNamespaceId(namespaceAppl);
        SpxPrimarySymbolTable symbolTable = this.getPersistenceManager().spxSymbolTable();
        INamespace deletedLocalNs = symbolTable.destroyNamespace(id);
        return this._termFactory.makeAppl(this.getCons().getLocalNamespaceTypeCon(), deletedLocalNs.namespaceUri().id());
    }

    public void indexSymbol(IStrategoAppl symbolDefinition) throws SpxSymbolTableException, IOException {
        boolean NAMESPACE_ID_INDEX = false;
        this.verifyConstructor(symbolDefinition.getConstructor(), this.getCons().getSymbolTableEntryDefCon(), "Illegal SymbolDefinition argument");
        IStrategoConstructor typeCtor = null;
        try {
            typeCtor = this.verifyKnownContructorExists((IStrategoAppl)symbolDefinition.getSubterm(2));
        }
        catch (IllegalArgumentException ex) {
            IStrategoConstructor ctor = ((IStrategoAppl)symbolDefinition.getSubterm(2)).getConstructor();
            typeCtor = this._spxConstructors.indexConstructor(ctor);
        }
        SpxSymbolTableEntry.EntryBuilder entryBuilder = SpxSymbolTableEntry.newEntry().with(this.strip(symbolDefinition.getSubterm(1))).instanceOf(typeCtor).uses(this._termAttachmentSerializer).data(symbolDefinition.getSubterm(3));
        IStrategoConstructor symbolSort = ((IStrategoAppl)symbolDefinition.getSubterm(4)).getConstructor();
        if (symbolSort == this.getCons().getUniqueSymbolTypeCon()) {
            entryBuilder = entryBuilder.isUnique();
        }
        SpxSymbolTableEntry entry = entryBuilder.build();
        SpxPrimarySymbolTable symbolTable = this.getPersistenceManager().spxSymbolTable();
        symbolTable.defineSymbol(this.getNamespaceId((IStrategoAppl)symbolDefinition.getSubterm(0)), entry);
    }

    public SpxSymbol verifySymbolExists(IStrategoTuple searchCriteria) throws SpxSymbolTableException {
        if (searchCriteria.getSubtermCount() != 3) {
            throw new IllegalArgumentException(" verifySymbolExists | Illegal symbolLookupTerm Argument ; expected 4 subterms. Found : " + searchCriteria.getSubtermCount());
        }
        IStrategoAppl typeAppl = (IStrategoAppl)searchCriteria.getSubterm(2);
        IStrategoConstructor typeCtor = this.getVerifiedStrategoConstructor(typeAppl);
        IStrategoList namespaceID = this.getNamespaceId((IStrategoAppl)searchCriteria.get(0));
        SpxPrimarySymbolTable symbolTable = this.getPersistenceManager().spxSymbolTable();
        return symbolTable.resolveSymbol(namespaceID, this.strip(searchCriteria.get(1)), typeCtor, Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStrategoTerm resolveSymbols(IStrategoTuple searchCriteria) throws SpxSymbolTableException {
        if (searchCriteria.getSubtermCount() != 4) {
            throw new IllegalArgumentException(" resolveSymbols | Illegal symbolLookupTerm Argument ; expected 4 subterms. Found : " + searchCriteria.getSubtermCount());
        }
        IStrategoTuple lookupConfiguration = (IStrategoTuple)searchCriteria.get(3);
        IStrategoAppl lookupType = (IStrategoAppl)lookupConfiguration.getSubterm(0);
        IStrategoConstructor lookupTypeCtor = this.getVerifiedStrategoConstructor(lookupType);
        String searchMode = Tools.asJavaString(lookupConfiguration.getSubterm(1)).trim();
        IStrategoAppl typeAppl = (IStrategoAppl)searchCriteria.getSubterm(2);
        IStrategoConstructor typeCtor = this.getVerifiedStrategoConstructor(typeAppl);
        int lookupDepth = Integer.MAX_VALUE;
        if (this._spxConstructors.isEqualConstructor(lookupTypeCtor, this._spxConstructors.getToLookupTypeLocal())) {
            lookupDepth = 0;
        }
        Collection<SpxSymbol> spxSymbols = null;
        if (typeCtor != null) {
            if (searchMode.equalsIgnoreCase("**")) {
                spxSymbols = this.resolveSymbols((IStrategoAppl)searchCriteria.get(0), searchCriteria.get(1), typeCtor, lookupDepth, true);
                return SpxSymbol.toTerms(this, spxSymbols);
            } else if (searchMode.equalsIgnoreCase("*")) {
                spxSymbols = this.resolveSymbols((IStrategoAppl)searchCriteria.get(0), searchCriteria.get(1), typeCtor, lookupDepth, false);
                return SpxSymbol.toTerms(this, spxSymbols);
            } else {
                if (!searchMode.equalsIgnoreCase(".")) throw new IllegalArgumentException(" Illegal symbolLookupTerm searchMode Argument ; expected * or . . Found : " + searchMode);
                spxSymbols = this.resolveSymbol((IStrategoAppl)searchCriteria.get(0), searchCriteria.get(1), typeCtor, lookupDepth);
            }
            return SpxSymbol.toTerms(this, spxSymbols);
        } else {
            this.logMessage("resolve symbols. Unknown Type Contructor " + typeAppl.getConstructor().getName());
        }
        return SpxSymbol.toTerms(this, spxSymbols);
    }

    private IStrategoConstructor getVerifiedStrategoConstructor(IStrategoAppl typeAppl) {
        IStrategoConstructor typeCtor = null;
        try {
            typeCtor = this.verifyKnownContructorExists(typeAppl);
        }
        catch (IllegalArgumentException ex) {
            IStrategoConstructor ctor = typeAppl.getConstructor();
            typeCtor = this._spxConstructors.indexConstructor(ctor);
        }
        return typeCtor;
    }

    public IStrategoTerm undefineSymbols(IStrategoTuple searchCriteria) throws SpxSymbolTableException {
        if (searchCriteria.getSubtermCount() != 3) {
            throw new IllegalArgumentException(" undefineSymbols| Illegal symbolLookupTerm Argument ; expected 3 subterms. Found : " + searchCriteria.getSubtermCount());
        }
        IStrategoList namespaceID = this.getNamespaceId(Tools.applAt(searchCriteria, 0));
        Object symbolID = Tools.termAt(searchCriteria, 1);
        IStrategoAppl typeAppl = Tools.applAt(searchCriteria, 2);
        IStrategoConstructor typeCtor = this.getVerifiedStrategoConstructor(typeAppl);
        Set<SpxSymbol> spxSymbols = this.getPersistenceManager().spxSymbolTable().undefineSymbols(namespaceID, (IStrategoTerm)symbolID, typeCtor);
        return SpxSymbol.toTerms(this, spxSymbols);
    }

    public void invalidateGlobalNamespace() {
        SpxPrimarySymbolTable symbolTable = this.getPersistenceManager().spxSymbolTable();
        symbolTable.cleanGlobalNamespace(this);
    }

    public Collection<SpxSymbol> resolveSymbols(IStrategoAppl namespaceToStartSearchWith, IStrategoTerm symbolId, IStrategoConstructor symbolType, int lookupDepth, boolean returnDuplicates) throws SpxSymbolTableException {
        IStrategoList namespaceID = this.getNamespaceId(namespaceToStartSearchWith);
        SpxPrimarySymbolTable symbolTable = this.getPersistenceManager().spxSymbolTable();
        Collection<SpxSymbol> resolvedSymbols = symbolTable.resolveSymbols(namespaceID, this.strip(symbolId), symbolType, lookupDepth, returnDuplicates);
        return resolvedSymbols;
    }

    public Set<SpxSymbol> resolveSymbol(IStrategoAppl namespaceToStartSearchWith, IStrategoTerm symbolId, IStrategoConstructor symbolType, int lookupDepth) throws SpxSymbolTableException {
        HashSet<SpxSymbol> resolvedSymbols = new HashSet<SpxSymbol>();
        IStrategoList namespaceID = this.getNamespaceId(namespaceToStartSearchWith);
        SpxPrimarySymbolTable symbolTable = this.getPersistenceManager().spxSymbolTable();
        SpxSymbol sym = symbolTable.resolveSymbol(namespaceID, this.strip(symbolId), symbolType, lookupDepth);
        if (sym != null) {
            resolvedSymbols.add(sym);
        }
        return resolvedSymbols;
    }

    private IStrategoConstructor verifyKnownContructorExists(IStrategoAppl symbolType) throws IllegalArgumentException {
        IStrategoConstructor typeCtor = this.getCons().getConstructor(symbolType.getConstructor().getName(), symbolType.getConstructor().getArity());
        if (typeCtor == null) {
            throw new IllegalArgumentException("Illegal Argument . Unknown Symbol Type. Found " + symbolType.getConstructor());
        }
        return typeCtor;
    }

    private IStrategoList getNamespaceId(IStrategoAppl namespaceTypedQname) throws SpxSymbolTableException {
        IStrategoList namespaceId;
        if (namespaceTypedQname.getConstructor() == this.getCons().getModuleQNameCon() || namespaceTypedQname.getConstructor() == this.getCons().getPackageQNameCon()) {
            namespaceId = IdentifiableConstruct.getID(this, (IStrategoAppl)namespaceTypedQname.getSubterm(0));
        } else if (namespaceTypedQname.getConstructor() == this.getCons().getGlobalNamespaceTypeCon()) {
            namespaceId = GlobalNamespace.getGlobalNamespaceId(this);
        } else if (namespaceTypedQname.getConstructor() == this.getCons().getLocalNamespaceTypeCon()) {
            namespaceId = LocalNamespace.getLocalNamespaceId(namespaceTypedQname.getSubterm(0));
        } else {
            throw new SpxSymbolTableException("Unknown namespace uri : " + namespaceTypedQname);
        }
        return namespaceId;
    }

    public void indexLanguageDescriptor(IStrategoAppl languageDescriptor) {
        this.verifyConstructor(languageDescriptor.getConstructor(), this.getCons().getLanguageDescriptorCon(), "Invalid LanguageDescriptor argument : " + languageDescriptor.toString());
        IStrategoList moduleId = ModuleDeclaration.getModuleId(this, (IStrategoAppl)languageDescriptor.getSubterm(0));
        SpxModuleLookupTable table = this.getPersistenceManager().spxModuleTable();
        table.verifyModuleIDExists(moduleId);
        moduleId = (IStrategoList)this.toCompactPositionInfo(moduleId);
        IStrategoList lNames = (IStrategoList)this.strip(languageDescriptor.getSubterm(1));
        IStrategoList lIds = (IStrategoList)this.strip(languageDescriptor.getSubterm(2));
        IStrategoList lEsvStartSymbols = (IStrategoList)this.strip(languageDescriptor.getSubterm(3));
        IStrategoList lSdfStartSymbols = (IStrategoList)this.strip(languageDescriptor.getSubterm(4));
        LanguageDescriptor current = LanguageDescriptor.newInstance(this.getTermFactory(), moduleId, lIds, lNames, lSdfStartSymbols, lEsvStartSymbols);
        table.defineLanguageDescriptor(moduleId, current);
    }

    public void indexImportReferences(IStrategoAppl importReferences) throws SpxSymbolTableException {
        IStrategoList packageId;
        this.verifyConstructor(importReferences.getConstructor(), this.getCons().getImportDeclCon(), "Illegal ImportDeclaration Constructor encountered.");
        ISpxPersistenceManager manager = this.getPersistenceManager();
        IStrategoAppl namespaceId = (IStrategoAppl)importReferences.getSubterm(0);
        IStrategoList imports = (IStrategoList)importReferences.getSubterm(1);
        if (namespaceId.getConstructor() == this.getCons().getModuleQNameCon()) {
            packageId = manager.spxModuleTable().packageId(ModuleDeclaration.getModuleId(this, namespaceId));
        } else if (namespaceId.getConstructor() == this.getCons().getPackageQNameCon()) {
            packageId = PackageDeclaration.getPackageId(this, namespaceId);
        } else {
            throw new IllegalArgumentException("Unknown Namespace " + namespaceId.toString());
        }
        PackageDeclaration packageDeclaration = this.lookupPackageDecl(packageId);
        PackageDeclaration newDecl = PackageDeclaration.newInstance(packageDeclaration);
        newDecl.addImportRefernces(this, imports);
        manager.spxPackageTable().definePackageDeclaration(newDecl);
    }

    private void defineNamespace(INamespaceFactory nsFactory) {
        SpxPrimarySymbolTable symTable = this.getPersistenceManager().spxSymbolTable();
        for (INamespace ns : nsFactory.newNamespaces(this)) {
            symTable.defineNamespace(ns);
        }
    }

    public IStrategoTerm getImportReferences(IStrategoAppl namespaceId) throws SpxSymbolTableException {
        PackageDeclaration ns;
        if (namespaceId.getConstructor() == this.getCons().getModuleQNameCon()) {
            IStrategoList packageId = this.getPersistenceManager().spxModuleTable().packageId(ModuleDeclaration.getModuleId(this, namespaceId));
            ns = this.lookupPackageDecl(packageId);
        } else if (namespaceId.getConstructor() == this.getCons().getPackageQNameCon()) {
            ns = this.lookupPackageDecl(namespaceId);
        } else {
            throw new IllegalArgumentException("Unknown Namespace " + namespaceId.toString());
        }
        return ns.getImports(this);
    }

    public IStrategoTerm getImportedToReferences(IStrategoAppl namespaceId) throws SpxSymbolTableException {
        PackageDeclaration ns;
        ISpxPersistenceManager manager = this.getPersistenceManager();
        if (namespaceId.getConstructor() == this.getCons().getModuleQNameCon()) {
            IStrategoList packageId = manager.spxModuleTable().packageId(ModuleDeclaration.getModuleId(this, namespaceId));
            ns = this.lookupPackageDecl(packageId);
        } else if (namespaceId.getConstructor() == this.getCons().getPackageQNameCon()) {
            ns = this.lookupPackageDecl(namespaceId);
        } else {
            throw new IllegalArgumentException("Unknown Namespace " + namespaceId.toString());
        }
        Set<IStrategoList> importedTos = manager.spxPackageTable().getImportedToReferencesOf(ns.getId());
        IStrategoList result = this.getTermFactory().makeList();
        for (IStrategoTerm iStrategoTerm : importedTos) {
            result = this.getTermFactory().makeListCons(PackageDeclaration.tranformToSpxImport(this, iStrategoTerm), result);
        }
        return result;
    }

    public IStrategoTerm getPackageDeclaration(IStrategoAppl packageTypedQName) throws SpxSymbolTableException {
        PackageDeclaration decl = this.lookupPackageDecl(packageTypedQName);
        return decl.toTerm(this);
    }

    public PackageDeclaration lookupPackageDecl(IStrategoAppl packageTypedQName) throws SpxSymbolTableException {
        IStrategoList packageId = PackageDeclaration.getPackageId(this, packageTypedQName);
        return this.lookupPackageDecl(packageId);
    }

    public IStrategoTerm getRelatedFilesOfPackages(IStrategoList packageList) {
        this.logMessage("getRelatedFilesOfPackages | Arguments : " + packageList);
        HashSet<String> resourcePaths = new HashSet<String>();
        SpxPackageLookupTable table = this.getPersistenceManager().spxPackageTable();
        for (IStrategoTerm packageName : StrategoListIterator.iterable(packageList)) {
            IStrategoAppl packageTypedQName = (IStrategoAppl)packageName;
            IStrategoList packageId = PackageDeclaration.getPackageId(this, packageTypedQName);
            PackageDeclaration decl = table.getPackageDeclaration(packageId);
            if (decl == null) continue;
            resourcePaths.addAll(decl.getAllFilePaths());
        }
        this.logMessage("getRelatedFilesOfPackages | Found : " + resourcePaths);
        IStrategoList result = this.getTermFactory().makeList();
        for (String s : resourcePaths) {
            result = this.getTermFactory().makeListCons(this.getTermFactory().makeString(s), result);
        }
        return result;
    }

    public IStrategoList getPackageDeclarations(IStrategoString filePath) {
        Set<PackageDeclaration> decls;
        this.logMessage("getPackageDeclarationsByUri | Arguments : " + filePath);
        SpxPackageLookupTable table = this.getPersistenceManager().spxPackageTable();
        String filepathString = Tools.asJavaString(filePath);
        if ("*" == filepathString) {
            decls = table.getPackageDeclarations();
        } else {
            String absFilePath = this.toAbsulatePath(filePath);
            table.verifyUriExists(absFilePath);
            decls = table.packageDeclarationsByUri(absFilePath);
        }
        IStrategoList result = SpxIndexUtils.toTerm(this, decls);
        this.logMessage("getPackageDeclarationsByUri | Returning IStrategoList : " + result);
        return result;
    }

    public IStrategoList getPackageDeclarationsByLanguageName(IStrategoString langName) {
        this.logMessage("getPackageDeclarationsByLanguageName | Arguments : " + langName);
        SpxModuleLookupTable table = this.getPersistenceManager().spxModuleTable();
        HashSet<IStrategoList> decls = new HashSet<IStrategoList>();
        Iterable<IStrategoList> mdecls = table.getModuleIdsByLangaugeName(langName);
        for (IStrategoList mId : mdecls) {
            decls.add(table.getModuleDeclaration((IStrategoList)mId).enclosingPackageID);
        }
        IStrategoList result = this.getTermFactory().makeList();
        for (IStrategoList pId : decls) {
            result = this.getTermFactory().makeListCons(PackageDeclaration.toPackageQNameAppl(this, pId), result);
        }
        this.logMessage("getPackageDeclarationsByLanguageName | Returning IStrategoList : " + result);
        return result;
    }

    public IStrategoTerm getModuleDeclaration(IStrategoAppl moduleTypeQName) throws IllegalArgumentException, SpxSymbolTableException {
        ModuleDeclaration decl = this.lookupModuleDecl(moduleTypeQName);
        return decl.toTerm(this);
    }

    public ModuleDeclaration lookupModuleDecl(IStrategoAppl moduleTypeQName) throws SpxSymbolTableException {
        IStrategoList moduleId;
        SpxModuleLookupTable table = this.getPersistenceManager().spxModuleTable();
        ModuleDeclaration decl = table.getModuleDeclaration(moduleId = ModuleDeclaration.getModuleId(this, moduleTypeQName));
        if (decl == null) {
            throw new SpxSymbolTableException("Unknown Module Id " + moduleTypeQName.toString());
        }
        return decl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStrategoTerm getModuleDeclarationsOf(IStrategoTuple searchQueryTuple) throws SpxSymbolTableException {
        IStrategoTerm res = searchQueryTuple.getSubterm(0);
        IStrategoString queryType = (IStrategoString)searchQueryTuple.getSubterm(1);
        if (Tools.isTermAppl(res)) {
            if ("-" == Tools.asJavaString(queryType)) {
                return this.getDirtyModuleDeclarations((IStrategoAppl)res, (IStrategoAppl)searchQueryTuple.getSubterm(2));
            }
            if ("*" != Tools.asJavaString(queryType)) throw new IllegalArgumentException("Unknown queryType argument in getModuleDeclarationOf: " + queryType);
            return this.getModuleDeclarations((IStrategoAppl)res);
        }
        if (!Tools.isTermString(res)) throw new IllegalArgumentException("Unknown argument in getModuleDeclarationOf: " + res);
        return this.getModuleDeclarations((IStrategoString)res);
    }

    public IStrategoList getModuleDeclarations(IStrategoString filePath) {
        Iterable<ModuleDeclaration> decls;
        this.logMessage("getModuleDeclarations | Arguments : " + filePath);
        SpxModuleLookupTable table = this.getPersistenceManager().spxModuleTable();
        String filepathString = Tools.asJavaString(filePath);
        if ("*" == filepathString) {
            decls = table.getModuleDeclarations();
        } else {
            String absFilePath = this.toAbsulatePath(filePath);
            table.verifyUriExists(absFilePath);
            decls = table.getModuleDeclarationsByUri(absFilePath);
        }
        IStrategoList result = SpxIndexUtils.toTerm(this, decls);
        this.logMessage("getModuleDeclarations | Returning IStrategoList : " + result);
        return result;
    }

    public IStrategoList getModuleDeclarations(IStrategoAppl packageQName) throws SpxSymbolTableException {
        this.logMessage("getModuleDeclarations | Arguments : " + packageQName);
        IStrategoList packageID = PackageDeclaration.getPackageId(this, packageQName);
        Iterable<ModuleDeclaration> decls = this.getModuleDeclarations(packageID);
        this.logMessage("getModuleDeclarations | Found following result from SymbolTable : " + decls);
        IStrategoList result = SpxIndexUtils.toTerm(this, decls);
        this.logMessage("getModuleDeclarations | Returning IStrategoList : " + result);
        return result;
    }

    public IStrategoList getDirtyModuleDeclarations(IStrategoAppl packageQName, IStrategoAppl qualifiedFor) throws SpxSymbolTableException {
        this.logMessage("getDirtyModuleDeclarations| Arguments : " + packageQName);
        ArrayList<ModuleDeclaration> dirtyModuleDeclarations = new ArrayList<ModuleDeclaration>();
        IStrategoList packageID = PackageDeclaration.getPackageId(this, packageQName);
        Iterable<ModuleDeclaration> decls = this.getModuleDeclarations(packageID);
        this.logMessage("getDirtyModuleDeclarations | Found following result from SymbolTable : " + decls);
        long ts = 0L;
        if (this.getCons().hasEqualConstructor(qualifiedFor, this.getCons().getToCompileCon())) {
            ts = this.getPersistenceManager().spxSymbolTable().getIndexLastInitializedOn();
        } else if (this.getCons().hasEqualConstructor(qualifiedFor, this.getCons().getToCodeGenerateCon())) {
            ts = this.getPersistenceManager().spxSymbolTable().getLastCodeGeneratedOn();
        } else {
            throw new SpxSymbolTableException("Illegal qualifiedFor constructor at getDirtyModuleDeclarations");
        }
        for (ModuleDeclaration decl : decls) {
            if (decl.getLastModifiedOn() < ts) continue;
            dirtyModuleDeclarations.add(decl);
        }
        IStrategoList result = SpxIndexUtils.toTerm(this, dirtyModuleDeclarations);
        this.logMessage("getDirtyModuleDeclarations | Returning IStrategoList : " + result);
        return result;
    }

    public Iterable<ModuleDeclaration> getModuleDeclarations(IStrategoList pacakgeID) throws SpxSymbolTableException {
        SpxModuleLookupTable table = this.getPersistenceManager().spxModuleTable();
        this.getPersistenceManager().spxPackageTable().verifyPackageIDExists(pacakgeID);
        return table.getModuleDeclarationsByPackageId(pacakgeID);
    }

    public IStrategoTerm getModuleDefinition(IStrategoAppl moduleTypedQName) throws IllegalArgumentException, SpxSymbolTableException {
        ModuleDeclaration decl = this.lookupModuleDecl(moduleTypedQName);
        SpxModuleLookupTable table = this.getPersistenceManager().spxModuleTable();
        IStrategoList qualifiedModuleId = ModuleDeclaration.getModuleId(this, moduleTypedQName);
        IStrategoAppl moduleAterm = table.getModuleDefinition(this, qualifiedModuleId);
        IStrategoAppl moduleAnnotatedAterm = table.getAnalyzedModuleDefinition(this, qualifiedModuleId);
        return new ModuleDefinition(decl, moduleAterm, moduleAnnotatedAterm).toTerm(this);
    }

    public IStrategoTerm getLanguageDescriptor(IStrategoAppl packageTypedQName) throws IllegalArgumentException, Exception {
        IStrategoList packageId = PackageDeclaration.getPackageId(this, packageTypedQName);
        SpxPackageLookupTable packageTable = this.getPersistenceManager().spxPackageTable();
        packageTable.verifyPackageIDExists(packageId);
        LanguageDescriptor desc = this.getLangaugeDescriptorByPackageId(packageId);
        return desc.toTerm(this);
    }

    LanguageDescriptor getLangaugeDescriptorByPackageId(IStrategoList packageId) throws SpxSymbolTableException {
        SpxModuleLookupTable moduleLookupTable = this.getPersistenceManager().spxModuleTable();
        LanguageDescriptor ret = LanguageDescriptor.newInstance(this.getTermFactory(), packageId);
        Iterable<ModuleDeclaration> moduleDeclarations = this.getModuleDeclarations(packageId);
        for (ModuleDeclaration m : moduleDeclarations) {
            LanguageDescriptor moduleLangaugeDescriptor = moduleLookupTable.getLangaugeDescriptor(m.getId());
            ret = LanguageDescriptor.appendLanguageDescriptors(this.getTermFactory(), ret, moduleLangaugeDescriptor);
        }
        return ret;
    }

    public void removePackageDeclaration(IStrategoString spxCompilationUnitPath, IStrategoAppl namespaceID) {
        SpxPackageLookupTable table = this.getPersistenceManager().spxPackageTable();
        spxCompilationUnitPath = (IStrategoString)this.toCompactPositionInfo(spxCompilationUnitPath);
        IStrategoList packageId = (IStrategoList)this.toCompactPositionInfo(PackageDeclaration.getPackageId(this, namespaceID));
        table.verifyPackageIDExists(packageId);
        table.removePackageDeclarationLocation(packageId, this.toAbsulatePath(spxCompilationUnitPath));
    }

    public PackageDeclaration lookupPackageDecl(IStrategoList packageId) throws SpxSymbolTableException {
        SpxPackageLookupTable table = this.getPersistenceManager().spxPackageTable();
        PackageDeclaration decl = table.getPackageDeclaration(packageId);
        if (decl == null) {
            throw new SpxSymbolTableException("Unknown Package Id : " + packageId.toString());
        }
        return decl;
    }

    public void commitChanges() throws IOException {
        ISpxPersistenceManager persistenceManager = this.getPersistenceManager();
        persistenceManager.commit();
        SpxIndexUtils.printSymbolTable(this, SpxIndexConfiguration.shouldLogSymbols(), "commit");
    }

    public void close(boolean shouldCommit) throws IOException {
        if (!this.isPersistenceManagerClosed()) {
            this.logMessage("close | closing underlying persistence manager instance.");
            ISpxPersistenceManager persistenceManager = this.getPersistenceManager();
            if (shouldCommit) {
                this.commitChanges();
            }
            persistenceManager.close();
            persistenceManager = null;
        } else {
            this.logMessage("close | underlying persistence manager is already closed. ");
        }
    }

    public void cleanIndexAndSymbolTable() throws Exception {
        ISpxPersistenceManager manager = this.getPersistenceManager();
        if (!this.isPersistenceManagerClosed()) {
            if (!this.tryInvalidatingSpxCacheDirectories()) {
                throw new RuntimeException("Failed to clean Spx Cache Directories. Please manually clean it");
            }
            manager.clearCache();
            manager.clear();
            manager.commitAndClose();
        }
        this.initializePersistenceManager();
        SpxIndexUtils.printSymbolTable(this, SpxIndexConfiguration.shouldPrintDebugInfo(), "clean");
    }

    boolean tryInvalidatingSpxCacheDirectories() {
        if (SpxIndexUtils.deleteSpxCacheDir(new File(String.valueOf(this._projectPath) + "/" + ".spxcache"), true)) {
            return SpxIndexUtils.deleteSpxCacheDir(new File(String.valueOf(this._projectPath) + "/" + ".shadowdir"), true);
        }
        return false;
    }

    public void rollbackChanges() throws IOException {
        if (!this.isPersistenceManagerClosed()) {
            this.getPersistenceManager().rollback();
        }
    }

    boolean isPersistenceManagerClosed() {
        return this.getPersistenceManager() == null || this.getPersistenceManager().isClosed();
    }

    private IStrategoTerm toCompactPositionInfo(IStrategoTerm term) {
        if (term == null) {
            return term;
        }
        ImploderAttachment astAttachment = ImploderAttachment.getCompactPositionAttachment(term, true);
        IStrategoTerm astTerm = this._stripper.strip(term);
        astTerm.putAttachment(astAttachment);
        return astTerm;
    }

    private IStrategoTerm strip(IStrategoTerm term) {
        return this._stripper.strip(term);
    }

    public String toAbsulatePath(IStrategoString uri) {
        return SpxIndexUtils.uriToAbsPathString(this.toFileURI(uri));
    }

    private URI toFileURI(IStrategoTerm filePath) {
        return SpxIndexUtils.getAbsolutePathUri(Tools.asJavaString(filePath), this._agent);
    }

    public void verifyConstructor(IStrategoConstructor actual, IStrategoConstructor expected, String message) {
        if (actual != expected) {
            throw new IllegalArgumentException(message);
        }
    }

    private void logMessage(String message) {
        this.getPersistenceManager().logMessage("SpxSemanticIndexFacade", message);
    }

    String fromFileURI(URI uri) {
        File file = new File(uri);
        return file.toString();
    }

    IOAgent getIOAgent() {
        return this._agent;
    }

    void printError(String errMessage) {
        this._agent.printError(errMessage);
    }

    public static IStrategoAppl forceImploderAttachment(IStrategoAppl term, URI file) {
        return SpxSemanticIndexFacade.forceImploderAttachment(term, term, file);
    }

    public static IStrategoAppl forceImploderAttachment(IStrategoTerm id, IStrategoAppl term, URI file) {
        ImploderAttachment attach = ImploderAttachment.get(id);
        if (attach != null) {
            ImploderAttachment.putImploderAttachment(term, false, attach.getSort(), attach.getLeftToken(), attach.getRightToken());
        } else {
            String fn = file == null ? null : file.toString();
            term.putAttachment(ImploderAttachment.createCompactPositionAttachment(fn, 0, 0, 0, -1));
        }
        return term;
    }

    public void clearCache() throws IOException {
        this.getPersistenceManager().clearCache();
    }
}

