/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexUtils;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class SpxSemanticIndexFacadeRegistry {
    static final Map<String, SpxSemanticIndexFacade> _registry = Collections.synchronizedMap(new HashMap());

    public synchronized SpxSemanticIndexFacade initFacade(IStrategoTerm projectPath, ITermFactory termFactory, IOAgent agent) throws Exception {
        SpxSemanticIndexFacade fac = null;
        String projectNameString = SpxIndexUtils.toAbsPathString(Tools.asJavaString(projectPath));
        if (!this.containsFacade(projectPath)) {
            fac = new SpxSemanticIndexFacade(projectPath, termFactory, agent);
            fac.initializePersistenceManager();
            fac.cleanIndexAndSymbolTable();
        } else {
            fac = _registry.get(projectNameString);
            if (fac != null && fac.isPersistenceManagerClosed()) {
                fac.initializePersistenceManager();
            } else if (fac == null) {
                fac = new SpxSemanticIndexFacade(projectPath, termFactory, agent);
                fac.initializePersistenceManager();
            }
        }
        if (fac != null) {
            _registry.put(fac.getProjectPath(), fac);
        }
        return fac;
    }

    public SpxSemanticIndexFacade getFacade(IStrategoTerm projectPath) throws Exception {
        String key = SpxIndexUtils.toAbsPathString(Tools.asJavaString(projectPath));
        SpxSemanticIndexFacade facade = _registry.get(key);
        if (facade != null && facade.isPersistenceManagerClosed()) {
            facade.initializePersistenceManager();
        }
        return facade;
    }

    public synchronized void clearAll() throws IOException {
        for (String fname : _registry.keySet()) {
            this.removeFacade(SpxIndexUtils.toAbsPathString(fname));
        }
    }

    private SpxSemanticIndexFacade closePersistenceManager(String projectPath) throws IOException {
        SpxSemanticIndexFacade facade = _registry.get(projectPath);
        if (facade != null && !facade.isPersistenceManagerClosed()) {
            facade.close(false);
        }
        return facade;
    }

    public SpxSemanticIndexFacade closePersistenceManager(IStrategoTerm projectPathTerm) throws IOException {
        return this.closePersistenceManager(SpxIndexUtils.toAbsPathString(Tools.asJavaString(projectPathTerm)));
    }

    private SpxSemanticIndexFacade removeFacade(String projectPath) throws IOException {
        this.closePersistenceManager(projectPath);
        return _registry.remove(projectPath);
    }

    public boolean containsFacade(IStrategoTerm projectPath) {
        String key = SpxIndexUtils.toAbsPathString(Tools.asJavaString(projectPath));
        return _registry.containsKey(key);
    }
}

