/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermConverter;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.StrategoListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdentifiableConstruct
implements Serializable {
    private static final long serialVersionUID = 1055862481052307186L;
    protected final IStrategoList id;
    protected final Set<IStrategoList> importReferences;
    protected final Set<IStrategoTerm> legacyImportReferences;

    public IdentifiableConstruct(IStrategoList id) {
        assert (id != null) : " ID can not be null ";
        this.id = id;
        this.importReferences = new HashSet<IStrategoList>();
        this.legacyImportReferences = new HashSet<IStrategoTerm>();
    }

    public IStrategoList getId() {
        return this.id;
    }

    public abstract IStrategoTerm toTerm(SpxSemanticIndexFacade var1);

    public void addImportRefernces(SpxSemanticIndexFacade idxFacade, IStrategoList imports) throws NotImplementedException, SpxSymbolTableException {
        for (IStrategoTerm i : StrategoListIterator.iterable(imports)) {
            if (i instanceof IStrategoAppl) {
                this.addManagedImport(idxFacade, i);
                continue;
            }
            this.addLegacyImport(i);
        }
    }

    private void addLegacyImport(IStrategoTerm i) {
        this.legacyImportReferences.add(i);
    }

    private void addManagedImport(SpxSemanticIndexFacade idxFacade, IStrategoTerm i) throws SpxSymbolTableException {
        IStrategoAppl packageRef = (IStrategoAppl)i;
        if (packageRef.getConstructor() == idxFacade.getCons().getPackageQNameCon()) {
            IStrategoList id = PackageDeclaration.getPackageId(idxFacade, packageRef);
            if (!SpxSymbol.verifyEquals(this.id, id)) {
                this.importReferences.add(id);
            }
        } else {
            throw new NotImplementedException("Unknown Import Reference. Not implemented for : " + packageRef.toString());
        }
    }

    public static IStrategoTerm tranformToSpxImport(SpxSemanticIndexFacade idxFacade, IStrategoTerm i) {
        IStrategoTerm retTerm = i;
        if (i instanceof IStrategoList) {
            retTerm = PackageDeclaration.toPackageQNameAppl(idxFacade, (IStrategoList)i);
        }
        return retTerm;
    }

    protected Set<IStrategoTerm> getEnclosedImportReferences(SpxSemanticIndexFacade idxFacade) throws SpxSymbolTableException {
        return new HashSet<IStrategoTerm>();
    }

    public Set<IStrategoList> getImportReferneces() {
        return this.importReferences;
    }

    public IStrategoList getImports(SpxSemanticIndexFacade idxFacade) {
        ITermFactory termFactory = idxFacade.getTermFactory();
        TermConverter termConverter = idxFacade.getTermConverter();
        HashSet<IStrategoTerm> allImportRefs = new HashSet<IStrategoTerm>();
        allImportRefs.addAll(this.importReferences);
        allImportRefs.addAll(this.legacyImportReferences);
        IStrategoList result = termFactory.makeList();
        for (IStrategoTerm t : allImportRefs) {
            result = idxFacade.getTermFactory().makeListCons(IdentifiableConstruct.tranformToSpxImport(idxFacade, t), result);
        }
        return termConverter.convert(result);
    }

    protected IStrategoTerm forceImploderAttachment(IStrategoTerm term) {
        ImploderAttachment attach = ImploderAttachment.get(term);
        if (attach != null) {
            ImploderAttachment.putImploderAttachment(term, false, attach.getSort(), attach.getLeftToken(), attach.getRightToken());
        } else {
            String fn = this.getFileLocation();
            term.putAttachment(ImploderAttachment.createCompactPositionAttachment(fn, 0, 0, 0, -1));
        }
        return term;
    }

    protected String getFileLocation() {
        return null;
    }

    static IStrategoAppl toIdTerm(SpxSemanticIndexFacade facade, IStrategoConstructor namespaceCon, IStrategoList id) {
        ITermFactory factory = facade.getTermFactory();
        IStrategoConstructor qnameCons = facade.getCons().getQNameCon();
        IStrategoAppl qnameAppl = factory.makeAppl(qnameCons, id);
        return factory.makeAppl(namespaceCon, qnameAppl);
    }

    public static IStrategoList getID(SpxSemanticIndexFacade facade, IStrategoAppl qName) {
        if (qName.getConstructor() == facade.getCons().getQNameCon()) {
            return (IStrategoList)qName.getSubterm(0);
        }
        throw new IllegalArgumentException("Invalid QName : " + qName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public String toString() {
        return "IdentifiableConstruct [id=" + this.id + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifiableConstruct other = (IdentifiableConstruct)obj;
        return !(this.id == null ? other.id != null : !this.id.match(other.id));
    }
}

