/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.util.HashSet;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.IdentifiableConstruct;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageDescriptor
extends IdentifiableConstruct {
    private static final long serialVersionUID = 7099736990601308645L;
    public static final int LanguageNamesIndex = 1;
    public static final int LanguageIdsIndex = 2;
    public static final int EsvStartSymbolsIndex = 3;
    public static final int SdfStartSymbolsIndex = 4;
    private IStrategoList languageNames;
    private IStrategoList languageIDs;
    private IStrategoList esvDeclaredStartSymbols;
    private IStrategoList sdfDeclaredStartSymbols;

    public LanguageDescriptor(IStrategoList id) {
        super(id);
    }

    public IStrategoList getLanguageNames() {
        return this.languageNames;
    }

    public IStrategoList getLanguageIDs() {
        return this.languageIDs;
    }

    public IStrategoList getEsvDeclaredStartSymbols() {
        return this.esvDeclaredStartSymbols;
    }

    public IStrategoList getSdfDeclaredStartSymbols() {
        return this.sdfDeclaredStartSymbols;
    }

    public void addLanguageNames(ITermFactory fac, IStrategoList langNames) {
        if (this.languageNames == null) {
            this.languageNames = fac.makeList();
        }
        this.languageNames = LanguageDescriptor.prepend(fac, this.languageNames, langNames);
    }

    public void addLanguageIDs(ITermFactory fac, IStrategoList langIds) {
        if (this.languageIDs == null) {
            this.languageIDs = fac.makeList();
        }
        this.languageIDs = LanguageDescriptor.prepend(fac, this.languageIDs, langIds);
    }

    public void addEsvDeclaredStartSymbols(ITermFactory fac, IStrategoList startSymbols) {
        this.esvDeclaredStartSymbols = LanguageDescriptor.prepend(fac, this.esvDeclaredStartSymbols, startSymbols);
    }

    public void addSDFDeclaredStartSymbols(ITermFactory fac, IStrategoList startSymbols) {
        this.sdfDeclaredStartSymbols = LanguageDescriptor.prepend(fac, this.sdfDeclaredStartSymbols, startSymbols);
    }

    public Iterable<String> asLanguageNameStrings() {
        HashSet<String> langNames = new HashSet<String>();
        for (IStrategoTerm lName : StrategoListIterator.iterable(this.languageNames)) {
            langNames.add(Tools.asJavaString(lName));
        }
        return langNames;
    }

    public static LanguageDescriptor appendLanguageDescriptors(ITermFactory f, LanguageDescriptor desc, LanguageDescriptor toAppend) {
        if (toAppend == null) {
            return desc;
        }
        desc.addLanguageIDs(f, toAppend.getLanguageIDs());
        desc.addLanguageNames(f, toAppend.getLanguageNames());
        desc.addSDFDeclaredStartSymbols(f, toAppend.getSdfDeclaredStartSymbols());
        desc.addEsvDeclaredStartSymbols(f, toAppend.getEsvDeclaredStartSymbols());
        return desc;
    }

    public static LanguageDescriptor newInstance(ITermFactory f, IStrategoList id) {
        return LanguageDescriptor.newInstance(f, id, f.makeList(), f.makeList(), f.makeList(), f.makeList());
    }

    public static LanguageDescriptor newInstance(ITermFactory fac, LanguageDescriptor decl) {
        return LanguageDescriptor.newInstance(fac, decl.getId(), decl.languageIDs, decl.languageNames, decl.sdfDeclaredStartSymbols, decl.esvDeclaredStartSymbols);
    }

    public static LanguageDescriptor newInstance(ITermFactory f, IStrategoList id, IStrategoList languageIds, IStrategoList languageNames, IStrategoList sdfStartSymbols, IStrategoList esvStartSymbols) {
        LanguageDescriptor desc = new LanguageDescriptor(id);
        desc.addLanguageIDs(f, languageIds);
        desc.addLanguageNames(f, languageNames);
        desc.addSDFDeclaredStartSymbols(f, sdfStartSymbols);
        desc.addEsvDeclaredStartSymbols(f, esvStartSymbols);
        return desc;
    }

    private static IStrategoList prepend(ITermFactory fac, IStrategoList srcList, IStrategoList toPrepend) {
        if (toPrepend == null) {
            return srcList;
        }
        if (srcList == null) {
            srcList = fac.makeList();
        }
        for (IStrategoTerm result : StrategoListIterator.iterable(toPrepend)) {
            srcList = fac.makeListCons(result, srcList);
        }
        return srcList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.esvDeclaredStartSymbols == null ? 0 : this.esvDeclaredStartSymbols.hashCode());
        result = 31 * result + (this.languageIDs == null ? 0 : this.languageIDs.hashCode());
        result = 31 * result + (this.languageNames == null ? 0 : this.languageNames.hashCode());
        result = 31 * result + (this.sdfDeclaredStartSymbols == null ? 0 : this.sdfDeclaredStartSymbols.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LanguageDescriptor)) {
            return false;
        }
        LanguageDescriptor other = (LanguageDescriptor)obj;
        if (this.esvDeclaredStartSymbols == null ? other.esvDeclaredStartSymbols != null : !this.esvDeclaredStartSymbols.match(other.esvDeclaredStartSymbols)) {
            return false;
        }
        if (this.languageIDs == null ? other.languageIDs != null : !this.languageIDs.match(other.languageIDs)) {
            return false;
        }
        if (this.languageNames == null ? other.languageNames != null : !this.languageNames.match(other.languageNames)) {
            return false;
        }
        return !(this.sdfDeclaredStartSymbols == null ? other.sdfDeclaredStartSymbols != null : !this.sdfDeclaredStartSymbols.match(other.sdfDeclaredStartSymbols));
    }

    @Override
    public String toString() {
        return "LanguageDescriptor [languageNames=" + this.languageNames + ", languageIDs=" + this.languageIDs + ", esvDeclaredStartSymbols=" + this.esvDeclaredStartSymbols + ", sdfDeclaredStartSymbols=" + this.sdfDeclaredStartSymbols + "]";
    }

    @Override
    public IStrategoTerm toTerm(SpxSemanticIndexFacade idxFacade) {
        ITermFactory termFactory = idxFacade.getTermFactory();
        IStrategoConstructor ctr = idxFacade.getCons().getLanguageDescriptorCon();
        IStrategoAppl packageQNameAppl = PackageDeclaration.toPackageQNameAppl(idxFacade, this.getId());
        IStrategoAppl retTerm = termFactory.makeAppl(ctr, packageQNameAppl, this.languageNames, this.languageIDs, this.esvDeclaredStartSymbols, this.sdfDeclaredStartSymbols);
        return idxFacade.getTermConverter().convert((IStrategoTerm)retTerm);
    }
}

