/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.util.ArrayList;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespaceFactory;
import org.spoofax.interpreter.library.language.spxlang.index.ModuleNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPrimarySymbolTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.IdentifiableConstruct;
import org.spoofax.interpreter.library.language.spxlang.index.data.NamespaceUri;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleDeclaration
extends IdentifiableConstruct
implements INamespaceFactory {
    private static final long serialVersionUID = 1989975037160433882L;
    public static final int ModuleTypedQNameIndex = 0;
    public static final int ModulePathIndex = 1;
    public static final int PackageTypedQNameIndex = 2;
    public static final int AstIndex = 3;
    public static final int AnalyzedAstIndex = 4;
    public final String resourceAbsPath;
    public final IStrategoList enclosingPackageID;
    private long lastModifiedOn;

    public ModuleDeclaration(String resourceAbsPath, IStrategoList id, IStrategoList packageID) {
        super(id);
        this.resourceAbsPath = resourceAbsPath;
        this.enclosingPackageID = packageID;
    }

    @Override
    protected String getFileLocation() {
        return this.resourceAbsPath;
    }

    public static IStrategoList getModuleId(SpxSemanticIndexFacade facade, IStrategoAppl moduleQName) {
        IStrategoConstructor moduleCon = facade.getCons().getModuleQNameCon();
        if (moduleCon == moduleQName.getConstructor()) {
            return ModuleDeclaration.getID(facade, (IStrategoAppl)moduleQName.getSubterm(0));
        }
        throw new IllegalArgumentException("Invalid module qname : " + moduleQName.toString());
    }

    public static IStrategoAppl toModuleQNameAppl(SpxSemanticIndexFacade facade, ModuleDeclaration decl) {
        return ModuleDeclaration.toIdTerm(facade, facade.getCons().getModuleQNameCon(), decl.getId());
    }

    public static IStrategoAppl toModuleQNameAppl(SpxSemanticIndexFacade facade, IStrategoList id) {
        return ModuleDeclaration.toIdTerm(facade, facade.getCons().getModuleQNameCon(), id);
    }

    @Override
    public IStrategoTerm toTerm(SpxSemanticIndexFacade idxFacade) {
        ITermFactory termFactory = idxFacade.getTermFactory();
        IStrategoConstructor moduleDeclCons = idxFacade.getCons().getModuleDeclCon();
        IStrategoAppl moduleQNameAppl = ModuleDeclaration.toModuleQNameAppl(idxFacade, this);
        IStrategoString resAbsPathTerm = termFactory.makeString(this.resourceAbsPath);
        IStrategoAppl packageQNameAppl = PackageDeclaration.toPackageQNameAppl(idxFacade, this.enclosingPackageID);
        IStrategoAppl retTerm = termFactory.makeAppl(moduleDeclCons, moduleQNameAppl, resAbsPathTerm, packageQNameAppl);
        return this.forceImploderAttachment(retTerm);
    }

    @Override
    public Iterable<INamespace> newNamespaces(SpxSemanticIndexFacade idxFacade) {
        ArrayList<INamespace> namespaces = new ArrayList<INamespace>();
        SpxPrimarySymbolTable table = idxFacade.getPersistenceManager().spxSymbolTable();
        NamespaceUri namespaceUri = table.toNamespaceUri(this.id);
        NamespaceUri packageUri = table.toNamespaceUri(this.enclosingPackageID);
        namespaces.add(ModuleNamespace.createInstance(namespaceUri, packageUri, idxFacade, this.getFileLocation()));
        return namespaces;
    }

    public NamespaceUri getNamespaceUri(SpxSemanticIndexFacade idxFacade) {
        return idxFacade.getPersistenceManager().spxSymbolTable().toNamespaceUri(this.id);
    }

    public long getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(long lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    @Override
    public String toString() {
        return "ModuleDeclaration [ id= " + this.id + ", packageId =" + this.enclosingPackageID + ", resourceAbsPath= " + this.resourceAbsPath + "]" + "{ lastModifiedOn= " + this.lastModifiedOn + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDeclaration other = (ModuleDeclaration)obj;
        if (this.resourceAbsPath == null ? other.resourceAbsPath != null : !this.resourceAbsPath.equals(other.resourceAbsPath)) {
            return false;
        }
        return !(this.enclosingPackageID == null ? other.enclosingPackageID != null : !this.enclosingPackageID.match(other.enclosingPackageID));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.resourceAbsPath == null ? 0 : this.resourceAbsPath.hashCode());
        result = 31 * result + (this.enclosingPackageID == null ? 0 : this.enclosingPackageID.hashCode());
        return result;
    }
}

