/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.io.Serializable;
import java.util.UUID;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespaceResolver;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoList;

public class NamespaceUri
implements Serializable {
    private static final long serialVersionUID = 7219193145612008432L;
    private final IStrategoList _id;
    private final UUID _uId;

    public NamespaceUri(IStrategoList id, UUID uId) {
        this._id = id;
        this._uId = uId;
    }

    public NamespaceUri(IStrategoList id) {
        this(id, UUID.randomUUID());
    }

    public IStrategoList id() {
        return this._id;
    }

    public String uniqueID() {
        return this._uId.toString();
    }

    public INamespace resolve(INamespaceResolver sTable) throws SpxSymbolTableException {
        INamespace retNamespace = sTable.resolveNamespace(this);
        if (retNamespace == null) {
            throw new SpxSymbolTableException("Unknown Namespace Uri. Namespace can not be resolved from symbol-table");
        }
        return retNamespace;
    }

    public boolean equalSpoofaxId(IStrategoList spoofaxUri) {
        return this._id.equals(spoofaxUri);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._uId == null ? 0 : this._uId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceUri other = (NamespaceUri)obj;
        return !(this._uId == null ? other._uId != null : !this._uId.equals(other._uId));
    }

    public String toString() {
        return "NamespaceId [ID =" + this._id + "]";
    }
}

