/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.util.HashSet;
import java.util.Set;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespaceFactory;
import org.spoofax.interpreter.library.language.spxlang.index.PackageNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.IdentifiableConstruct;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDeclaration
extends IdentifiableConstruct
implements INamespaceFactory {
    private static final long serialVersionUID = -9081890582103567413L;
    public static final int PACKAGE_ID_INDEX = 0;
    public static final int SPX_COMPILATION_UNIT_PATH = 1;
    private final Set<String> resourceAbsPaths = new HashSet<String>();

    public PackageDeclaration(String resourceAbsPath, IStrategoList id) {
        super(id);
        this.resourceAbsPaths.add(resourceAbsPath);
    }

    PackageDeclaration(IStrategoList id) {
        super(id);
    }

    public void addFileUri(String resAbsolutePath) {
        this.resourceAbsPaths.add(resAbsolutePath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageDeclaration other = (PackageDeclaration)obj;
        return !(this.resourceAbsPaths == null ? other.resourceAbsPaths != null : !this.resourceAbsPaths.equals(other.resourceAbsPaths));
    }

    public Set<String> getAllFilePaths() {
        return this.resourceAbsPaths;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.resourceAbsPaths == null ? 0 : this.resourceAbsPaths.hashCode());
        return result;
    }

    public boolean isNotExistedInAnyFile() {
        return this.resourceAbsPaths == null || this.resourceAbsPaths.size() == 0;
    }

    public void removeFileUri(String resAbsolutePath) {
        this.resourceAbsPaths.remove(resAbsolutePath);
    }

    @Override
    public String toString() {
        return "PackageDeclaration [id=" + this.id + ", resourceAbsPaths=" + this.resourceAbsPaths + "]";
    }

    @Override
    public IStrategoTerm toTerm(SpxSemanticIndexFacade idxFacade) {
        ITermFactory termFactory = idxFacade.getTermFactory();
        IStrategoConstructor packageDeclCons = idxFacade.getCons().getPackageDeclCon();
        IStrategoList absPathList = termFactory.makeList();
        for (String resourceAbsPath : this.resourceAbsPaths) {
            IStrategoString absPathTerm = termFactory.makeString(resourceAbsPath);
            absPathList = termFactory.makeListCons(absPathTerm, absPathList);
        }
        IStrategoAppl retTerm = termFactory.makeAppl(packageDeclCons, PackageDeclaration.toPackageIdTerm(idxFacade, this), absPathList);
        return this.forceImploderAttachment(retTerm);
    }

    public static IStrategoList getPackageId(SpxSemanticIndexFacade facade, IStrategoAppl packageQName) {
        IStrategoConstructor packageQNameCon = facade.getCons().getPackageQNameCon();
        if (packageQNameCon == packageQName.getConstructor()) {
            return PackageDeclaration.getID(facade, (IStrategoAppl)packageQName.getSubterm(0));
        }
        throw new IllegalArgumentException("Invalid Package Typed QName : " + packageQName);
    }

    public static PackageDeclaration newInstance(PackageDeclaration decl) {
        if (decl == null) {
            return decl;
        }
        PackageDeclaration newDecl = new PackageDeclaration(decl.getId());
        for (String str : decl.getAllFilePaths()) {
            newDecl.addFileUri(str);
        }
        newDecl.importReferences.addAll(decl.importReferences);
        newDecl.legacyImportReferences.addAll(decl.legacyImportReferences);
        return newDecl;
    }

    public static IStrategoAppl toPackageQNameAppl(SpxSemanticIndexFacade facade, IStrategoList id) {
        return PackageDeclaration.toIdTerm(facade, facade.getCons().getPackageQNameCon(), id);
    }

    public static IStrategoAppl toPackageIdTerm(SpxSemanticIndexFacade facade, PackageDeclaration decl) {
        return PackageDeclaration.toPackageQNameAppl(facade, decl.getId());
    }

    @Override
    public Iterable<INamespace> newNamespaces(SpxSemanticIndexFacade idxFacade) {
        return PackageNamespace.createInstances(this.id, idxFacade);
    }
}

