/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.io.Serializable;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public abstract class SpxBaseSymbol
implements Serializable {
    private static final long serialVersionUID = 3160588874266553126L;
    private transient IStrategoTerm _id;
    private final String _idString;
    private final String _signatureString;
    private final boolean _isOverridable;

    public String getId() {
        return this._idString;
    }

    public String getSignatureString() {
        assert (this._signatureString != null) : "Non-Null Signature is expected. ";
        return this._signatureString;
    }

    public boolean isOverridable() {
        return this._isOverridable;
    }

    public SpxBaseSymbol(IStrategoTerm id, IStrategoConstructor signature, boolean isOveridable) {
        this._id = id;
        this._idString = id.toString(Integer.MAX_VALUE);
        this._signatureString = signature.getName();
        this._isOverridable = isOveridable;
    }

    public IStrategoTerm Id(ITermFactory _fac) {
        if (this._id == null) {
            this._id = _fac.parseFromString(this._idString);
        }
        return this._id;
    }

    public static boolean verifyEquals(IStrategoConstructor ctor1, IStrategoConstructor ctor2) {
        return ctor1.getArity() == ctor2.getArity() && ctor1.getName().equals(ctor2.getName());
    }

    public static boolean verifyEquals(IStrategoTerm current, IStrategoTerm other) {
        boolean retValue = false;
        if (current instanceof IStrategoAppl) {
            if (other instanceof IStrategoAppl) {
                IStrategoAppl currentAppl = (IStrategoAppl)current;
                IStrategoAppl otherAppl = (IStrategoAppl)other;
                if (SpxBaseSymbol.verifyEquals(currentAppl.getConstructor(), otherAppl.getConstructor())) {
                    IStrategoTerm[] currentTerms = currentAppl.getAllSubterms();
                    IStrategoTerm[] otherTerms = currentAppl.getAllSubterms();
                    retValue = SpxBaseSymbol.verifyEquals(currentTerms, otherTerms);
                }
            }
        } else if (current instanceof IStrategoTuple) {
            if (other instanceof IStrategoTuple) {
                retValue = SpxBaseSymbol.verifyEquals(current.getAllSubterms(), other.getAllSubterms());
            }
        } else if (current instanceof IStrategoList) {
            if (other instanceof IStrategoList) {
                retValue = SpxBaseSymbol.verifyEquals(current.getAllSubterms(), other.getAllSubterms());
            }
        } else {
            retValue = current.match(other);
        }
        return retValue;
    }

    public static boolean verifyEquals(IStrategoTerm[] currentTerms, IStrategoTerm[] otherTerms) {
        boolean retValue = false;
        if (currentTerms == null && otherTerms == null) {
            retValue = true;
        } else if (currentTerms.length == otherTerms.length) {
            if (currentTerms.length == 0) {
                retValue = true;
            } else {
                int i = 0;
                while (i < currentTerms.length) {
                    if (!SpxBaseSymbol.verifyEquals(currentTerms[i], otherTerms[i])) {
                        retValue = false;
                        break;
                    }
                    retValue = true;
                    ++i;
                }
            }
        }
        return retValue;
    }

    public static boolean equalSignature(IStrategoConstructor expectedType, SpxBaseSymbol s) {
        return expectedType == null || s.equalSignature(expectedType);
    }

    public boolean equalSignature(IStrategoConstructor term) {
        return this._signatureString.equals(term.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._idString == null ? 0 : this._idString.hashCode());
        result = 31 * result + (this._signatureString == null ? 0 : this._signatureString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpxBaseSymbol other = (SpxBaseSymbol)obj;
        if (this._idString == null ? other._idString != null : !this._idString.equals(other._idString)) {
            return false;
        }
        return !(this._signatureString == null ? other._signatureString != null : !this._signatureString.equals(other._signatureString));
    }
}

