/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.io.File;
import java.io.Serializable;
import java.net.URI;

public class SpxCompilationUnitInfo
implements Serializable {
    private static final long serialVersionUID = 4366484691839493105L;
    private final long _recId;
    private int _version;
    private final URI _absPath;
    private long _lastModifiedOn;

    public SpxCompilationUnitInfo(URI absPath, long recourceId) {
        this(0, absPath, recourceId);
    }

    public SpxCompilationUnitInfo(int versionNo, URI absPath, long recourceId) {
        this._recId = recourceId;
        this._version = versionNo;
        this._absPath = absPath;
        this._lastModifiedOn = System.currentTimeMillis();
    }

    public long getRecId() {
        return this._recId;
    }

    public int getVersionNo() {
        return this._version;
    }

    public long getLastModifiedOn() {
        return this._lastModifiedOn;
    }

    URI getAbsPath() {
        return this._absPath;
    }

    public String getAbsPathString() {
        return new File(this.getAbsPath()).getAbsolutePath();
    }

    public synchronized void incrVersion() {
        this._lastModifiedOn = System.currentTimeMillis();
        ++this._version;
    }

    public String toString() {
        return "SpxComplicationUnitResourceInfo [ResourceId=" + this._recId + ", VersionNo=" + this._version + ", AbsPath=" + this._absPath + ", LastModifiedOn=" + this.getLastModifiedOn() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._absPath == null ? 0 : this._absPath.hashCode());
        result = 31 * result + (int)(this._recId ^ this._recId >>> 32);
        result = 31 * result + this._version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpxCompilationUnitInfo other = (SpxCompilationUnitInfo)obj;
        if (this._absPath == null ? other._absPath != null : !this._absPath.equals(other._absPath)) {
            return false;
        }
        if (this._recId != other._recId) {
            return false;
        }
        return this._version == other._version;
    }

    public static SpxCompilationUnitInfo newInstance(SpxCompilationUnitInfo inf) {
        if (inf == null) {
            return null;
        }
        return new SpxCompilationUnitInfo(inf.getVersionNo(), inf.getAbsPath(), inf.getRecId());
    }
}

