/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxIndexUtils;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.NamespaceUri;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxBaseSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.attachments.TermAttachmentSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpxSymbol
extends SpxBaseSymbol
implements Serializable {
    private static final long serialVersionUID = -5293805213473800423L;
    private String _data;
    private NamespaceUri _namespace;

    public SpxSymbol(IStrategoTerm id, IStrategoConstructor signature, boolean isOverridable) {
        super(id, signature, isOverridable);
    }

    public String getDataString() {
        return this._data;
    }

    public NamespaceUri namespaceUri() {
        return this._namespace;
    }

    IStrategoTerm deserializedDataToTerm(ITermFactory fac, TermAttachmentSerializer serializer) {
        return SpxIndexUtils.deserializeToTerm(fac, serializer, this._data);
    }

    void serializerDataString(TermAttachmentSerializer serializer, IStrategoTerm data) throws IOException {
        this._data = SpxIndexUtils.serializeToString(serializer, data);
    }

    public IStrategoConstructor typeCons(SpxSemanticIndexFacade facade) {
        return facade.getCons().getConstructor(this.getSignatureString(), 0);
    }

    public void setNamespace(NamespaceUri id) {
        this._namespace = id;
    }

    public static List<SpxSymbol> filterByType(IStrategoConstructor expectedType, Iterable<SpxSymbol> symbols) {
        ArrayList<SpxSymbol> retSymbols = new ArrayList<SpxSymbol>();
        if (symbols != null) {
            for (SpxSymbol s : symbols) {
                if (!SpxBaseSymbol.equalSignature(expectedType, s)) continue;
                retSymbols.add(s);
            }
        }
        return retSymbols;
    }

    public IStrategoTerm toTerm(SpxSemanticIndexFacade facade) throws SpxSymbolTableException {
        ITermFactory termFactory = facade.getTermFactory();
        IStrategoConstructor spxTypeCtor = this.typeCons(facade);
        IStrategoAppl spxTypeCtorAppl = termFactory.makeAppl(spxTypeCtor, new IStrategoTerm[0]);
        INamespace symbolNamespace = this.namespaceUri().resolve(facade.getPersistenceManager().spxSymbolTable());
        IStrategoAppl nsQNameAppl = symbolNamespace.toTypedQualifiedName(facade);
        IStrategoTerm deserializedDataToTerm = this.deserializedDataToTerm(termFactory, facade.getTermAttachmentSerializer());
        IStrategoTerm id = this.Id(termFactory);
        IStrategoConstructor symbolSortCtor = this.isOverridable() ? facade.getCons().getOverridableSymbolTypeCon() : facade.getCons().getUniqueSymbolTypeCon();
        return termFactory.makeAppl(facade.getCons().getSymbolTableEntryDefCon(), nsQNameAppl, spxTypeCtorAppl, id, deserializedDataToTerm, termFactory.makeAppl(symbolSortCtor, new IStrategoTerm[0]));
    }

    private IStrategoTerm forceImploderAttachment(IStrategoTerm term, String uri) {
        ImploderAttachment attach = ImploderAttachment.get(term);
        if (attach != null) {
            term.removeAttachment(ImploderAttachment.TYPE);
            ImploderAttachment.putImploderAttachment(term, SpxSymbol.isListOrTuple(term), attach.getSort(), attach.getLeftToken(), attach.getRightToken());
        } else {
            term.putAttachment(ImploderAttachment.createCompactPositionAttachment(uri, 0, 0, 0, -1));
        }
        return term;
    }

    private static boolean isListOrTuple(IStrategoTerm term) {
        return term.isList() || Tools.isTermTuple(term);
    }

    public static IStrategoTerm toTerms(SpxSemanticIndexFacade facade, Collection<SpxSymbol> symbols) throws SpxSymbolTableException {
        IStrategoList result = facade.getTermFactory().makeList();
        if (symbols != null) {
            Object[] arrSymbols = symbols.toArray();
            int i = arrSymbols.length - 1;
            while (i >= 0) {
                result = facade.getTermFactory().makeListCons(((SpxSymbol)arrSymbols[i]).toTerm(facade), result);
                --i;
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._data == null ? 0 : this._data.hashCode());
        result = 31 * result + (this._namespace == null ? 0 : this._namespace.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpxSymbol other = (SpxSymbol)obj;
        if (this._data == null ? other._data != null : !this._data.equals(other._data)) {
            return false;
        }
        return !(this._namespace == null ? other._namespace != null : !this._namespace.equals(other._namespace));
    }

    public String toString() {
        return "SpxSymbol [ Id : " + this.getId() + " Type= " + this.getSignatureString() + ", Namespace=" + this._namespace + "value = " + this._data + "]";
    }

    public String printSymbol(SpxSemanticIndexFacade f) throws IOException {
        return String.valueOf(SpxIndexUtils.getCsvFormatted(this.getSignatureString())) + ", " + SpxIndexUtils.getCsvFormatted(SpxIndexUtils.termToString(this.deserializedDataToTerm(f.getTermFactory(), f.getTermAttachmentSerializer())));
    }
}

