/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.data;

import java.io.IOException;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolKey;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.TermAttachmentSerializer;

public final class SpxSymbolTableEntry {
    public SpxSymbolKey key;
    public SpxSymbol value;
    public static final int SYMBOL_ID_INDEX = 1;
    public static final int TYPE_INDEX = 2;
    public static final int DATA_INDEX = 3;
    public static final int OVERRIDE_PROPERTY_INDEX = 4;

    public SpxSymbolTableEntry(SpxSymbolKey paramK, SpxSymbol paramV) {
        this.key = paramK;
        this.value = paramV;
    }

    public static EntryBuilder newEntry() {
        return new EntryBuilder();
    }

    public static class EntryBuilder {
        private IStrategoTerm _spoofaxkey;
        private IStrategoConstructor _signatureCtr;
        private IStrategoTerm _data;
        private boolean _overridable = true;
        private TermAttachmentSerializer _serializer;

        public EntryBuilder with(IStrategoTerm id) {
            this._spoofaxkey = id;
            return this;
        }

        public EntryBuilder instanceOf(IStrategoConstructor type) {
            this._signatureCtr = type;
            return this;
        }

        public EntryBuilder data(IStrategoTerm data) {
            this._data = data;
            return this;
        }

        public EntryBuilder uses(TermAttachmentSerializer serializer) {
            this._serializer = serializer;
            return this;
        }

        public EntryBuilder isUnique() {
            this._overridable = false;
            return this;
        }

        public SpxSymbolTableEntry build() throws IOException {
            SpxSymbolKey key = new SpxSymbolKey(this._spoofaxkey, this._signatureCtr, this._overridable);
            SpxSymbol symbol = new SpxSymbol(this._spoofaxkey, this._signatureCtr, this._overridable);
            symbol.serializerDataString(this._serializer, this._data);
            return new SpxSymbolTableEntry(key, symbol);
        }
    }
}

