/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.LanguageLibrary;
import org.spoofax.interpreter.library.language.spxlang.index.ISpxPersistenceManager;
import org.spoofax.interpreter.library.language.spxlang.index.SpxModuleLookupTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPackageLookupTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacadeRegistry;
import org.spoofax.interpreter.library.language.spxlang.index.data.LanguageDescriptor;
import org.spoofax.interpreter.library.language.spxlang.index.data.ModuleDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.library.language.spxlang.index.tests.SpxIndexBaseTestCase;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class SpxLookupTableUnitTests
extends SpxIndexBaseTestCase {
    private final String _projectName = "test-sybol-table_2";
    private IStrategoString projectNameTerm;
    private SpxSemanticIndexFacade _facade;
    private SpxSemanticIndexFacadeRegistry _registry;
    private ISpxPersistenceManager manager;
    private SpxPackageLookupTable symtable;
    private SpxModuleLookupTable mSymTable;
    final String absPathString1 = "c:/temp/test.spx";
    final String absPathString2 = "c:/temp/test2.spx";

    private Interpreter interpreter() {
        return this.itp;
    }

    private ITermFactory termFactory() {
        return this.factory;
    }

    private IOAgent ioAgent() {
        return this.itp.getIOAgent();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpreter().addOperatorRegistry(new LanguageLibrary());
        this._registry = new SpxSemanticIndexFacadeRegistry();
        this.projectNameTerm = this.termFactory().makeString(String.valueOf(System.getProperty("user.dir")) + "/" + "test-sybol-table_2");
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        this._facade = this._registry.getFacade(this.projectNameTerm);
        this._facade.cleanIndexAndSymbolTable();
        this.symtable = this._facade.getPersistenceManager().spxPackageTable();
        this.mSymTable = this._facade.getPersistenceManager().spxModuleTable();
        this.manager = this._facade.getPersistenceManager();
        this.mSymTable.clear();
        this.symtable.clear();
    }

    protected void tearDown() throws Exception {
        this.symtable.clear();
        this.mSymTable.clear();
        this._facade.commitChanges();
    }

    public void testShouldReturngPackageDeclarationbyUri() throws IOException {
        this.symtable.clear();
        IStrategoList idp1 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p1"));
        IStrategoList idp2 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p2"));
        PackageDeclaration p1 = new PackageDeclaration("c:/temp/test2.spx", idp1);
        PackageDeclaration p2 = new PackageDeclaration("c:/temp/test2.spx", idp2);
        p2.addFileUri("c:/temp/test.spx");
        this.symtable.definePackageDeclaration(p1);
        this.symtable.definePackageDeclaration(p2);
        try {
            this.manager.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PackageDeclaration expected = p2;
        int expectedPackageDecls = 1;
        int actualPackageDeclaration = 0;
        for (PackageDeclaration actual : this.symtable.packageDeclarationsByUri("c:/temp/test.spx")) {
            ++actualPackageDeclaration;
            SpxLookupTableUnitTests.assertEquals(expected, actual);
            SpxLookupTableUnitTests.assertEquals(2, actual.getAllFilePaths().size());
        }
        SpxLookupTableUnitTests.assertEquals(expectedPackageDecls, actualPackageDeclaration);
    }

    public void testShouldReturnPackageDeclarationByQName() {
        IStrategoList idp1 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p1"));
        IStrategoList idp2 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p2"));
        PackageDeclaration p1 = new PackageDeclaration("c:/temp/test2.spx", idp1);
        PackageDeclaration p2 = new PackageDeclaration("c:/temp/test2.spx", idp2);
        p2.addFileUri("c:/temp/test.spx");
        this.symtable.definePackageDeclaration(p1);
        this.symtable.definePackageDeclaration(p2);
        PackageDeclaration expected = p2;
        PackageDeclaration actual = this.symtable.getPackageDeclaration(idp2);
        SpxLookupTableUnitTests.assertEquals(expected, actual);
    }

    public void testUpdatingFileUrisShouldPersists() throws IOException {
        this.symtable.clear();
        IStrategoList idp1 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p1"));
        IStrategoList idp2 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p2"));
        PackageDeclaration p1 = new PackageDeclaration("c:/temp/test.spx", idp1);
        PackageDeclaration p2 = new PackageDeclaration("c:/temp/test2.spx", idp2);
        this.symtable.definePackageDeclaration(p1);
        this.symtable.definePackageDeclaration(p2);
        this.symtable.addPackageDeclarationLocation(idp2, "c:/temp/test.spx");
        try {
            this.manager.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int expectedPackageDecls = 2;
        Set<PackageDeclaration> decls = this.symtable.packageDeclarationsByUri("c:/temp/test.spx");
        this.symtable.getPackageDeclaration(idp1);
        SpxLookupTableUnitTests.assertEquals(expectedPackageDecls, decls.size());
    }

    public void testRemovePackageDeclarationsByFileUri() throws IOException {
        this.symtable.clear();
        IStrategoList idp1 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p1"));
        IStrategoList idp2 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p2"));
        IStrategoList idp3 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p3"));
        PackageDeclaration p1 = new PackageDeclaration("c:/temp/test.spx", idp1);
        PackageDeclaration p2 = new PackageDeclaration("c:/temp/test.spx", idp2);
        PackageDeclaration p3 = new PackageDeclaration("c:/temp/test2.spx", idp3);
        this.symtable.definePackageDeclaration(p1);
        this.symtable.definePackageDeclaration(p2);
        this.symtable.definePackageDeclaration(p3);
        this.symtable.removePackageDeclarationsByUri("c:/temp/test.spx");
        SpxLookupTableUnitTests.assertEquals(this.symtable.size(), 1);
    }

    public void testNoFileUriShouldRemovePackageDeclaration() throws IOException {
        this.symtable.clear();
        IStrategoList idp1 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p1"));
        IStrategoList idp2 = this.termFactory().makeList(this.termFactory().makeString("test"), this.termFactory().makeString("p2"));
        PackageDeclaration p1 = new PackageDeclaration("c:/temp/test.spx", idp1);
        PackageDeclaration p2 = new PackageDeclaration("c:/temp/test2.spx", idp2);
        this.symtable.definePackageDeclaration(p1);
        this.symtable.definePackageDeclaration(p2);
        try {
            this.manager.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.symtable.removePackageDeclarationLocation(idp1, "c:/temp/test.spx");
        SpxLookupTableUnitTests.assertEquals(null, this.symtable.getPackageDeclaration(idp1));
    }

    public void testLanguageDescriptorIsPersisted() throws IOException {
        this.mSymTable.clear();
        ITermFactory factory = this.termFactory();
        IStrategoList pId2 = factory.makeList(factory.makeString("test2"));
        IStrategoList idm2 = factory.makeList(factory.makeString("test"), factory.makeString("m2"));
        ModuleDeclaration m2 = new ModuleDeclaration("c:/temp/test.spx", idm2, pId2);
        this.mSymTable.define(this._facade, m2, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(factory, "m2"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(factory, "m2"));
        PackageDeclaration p1 = new PackageDeclaration("c:/temp/test.spx", idm2);
        this.symtable.definePackageDeclaration(p1);
        LanguageDescriptor langDescriptor = LanguageDescriptor.newInstance(factory, idm2, factory.makeList(factory.makeString("id1lang"), factory.makeString("id2lang")), factory.makeList(factory.makeString("langname2"), factory.makeString("langname2")), this.asSDFStartSymbols(new String[]{"Start", "Package"}), this.asEsvStartSymbols(new String[]{"Start", "Package"}));
        this.mSymTable.defineLanguageDescriptor(idm2, langDescriptor);
        ArrayList actual = (ArrayList)this.mSymTable.getModuleIdsByLangaugeName("langname2");
        SpxLookupTableUnitTests.assertEquals(actual.size(), 1);
        SpxLookupTableUnitTests.assertEquals(idm2, actual.get(0));
    }

    public void testUpdatingLanguageDescriptorIsPersisted() throws IOException {
        this.mSymTable.clear();
        this.symtable.clear();
        ITermFactory factory = this.termFactory();
        IStrategoList pId2 = factory.makeList(factory.makeString("test2"));
        PackageDeclaration p1 = new PackageDeclaration("c:/temp/test.spx", pId2);
        this.symtable.definePackageDeclaration(p1);
        IStrategoList idm2 = factory.makeList(factory.makeString("test"), factory.makeString("m2"));
        ModuleDeclaration m2 = new ModuleDeclaration("c:/temp/test.spx", idm2, pId2);
        this.mSymTable.define(this._facade, m2, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(factory, "m2"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(factory, "m2"));
        LanguageDescriptor langDescriptor = LanguageDescriptor.newInstance(factory, idm2, factory.makeList(factory.makeString("id1lang"), factory.makeString("id2lang")), factory.makeList(factory.makeString("langname2"), factory.makeString("langname2")), this.asSDFStartSymbols(new String[]{"Start", "Package"}), this.asEsvStartSymbols(new String[]{"Start", "Package"}));
        this.mSymTable.defineLanguageDescriptor(idm2, langDescriptor);
        LanguageDescriptor langDescriptor2 = this.mSymTable.getLangaugeDescriptor(idm2);
        langDescriptor2 = LanguageDescriptor.newInstance(factory, langDescriptor2);
        langDescriptor2.addLanguageNames(factory, factory.makeList(factory.makeString("langname3"), factory.makeString("langname4")));
        this.mSymTable.defineLanguageDescriptor(idm2, langDescriptor2);
        ArrayList actual = (ArrayList)this.mSymTable.getModuleIdsByLangaugeName("langname3");
        SpxLookupTableUnitTests.assertEquals(actual.size(), 1);
        SpxLookupTableUnitTests.assertEquals(idm2, actual.get(0));
    }

    public void testShouldThrowIllegalArgumentExceptionIfUnknownModuleId() throws IOException {
        this.mSymTable.clear();
        ITermFactory factory = this.termFactory();
        IStrategoList idM1 = factory.makeList(factory.makeString("test"), factory.makeString("p1"));
        LanguageDescriptor langDescriptor = LanguageDescriptor.newInstance(factory, idM1, factory.makeList(factory.makeString("id1lang"), factory.makeString("id2lang")), factory.makeList(factory.makeString("langname2"), factory.makeString("langname2")), this.asSDFStartSymbols(new String[]{"Start", "Package"}), this.asEsvStartSymbols(new String[]{"Start", "Package"}));
        try {
            this.mSymTable.defineLanguageDescriptor(idM1, langDescriptor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private IStrategoList asEsvStartSymbols(String[] esvStartSymbolsStrings) {
        ITermFactory factory = this.termFactory();
        IStrategoList list = factory.makeList();
        IStrategoConstructor sortCons = factory.makeConstructor("Sort", 1);
        String[] stringArray = esvStartSymbolsStrings;
        int n = esvStartSymbolsStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            IStrategoString esvStartSymbol = factory.makeString(s);
            IStrategoAppl sortAppl = factory.makeAppl(sortCons, esvStartSymbol);
            list = factory.makeListCons(sortAppl, list);
            ++n2;
        }
        return list;
    }

    private IStrategoList asSDFStartSymbols(String[] sdfStartSymbolsStrings) {
        ITermFactory factory = this.termFactory();
        IStrategoList list = factory.makeList();
        IStrategoConstructor sortCons = factory.makeConstructor("sort", 1);
        String[] stringArray = sdfStartSymbolsStrings;
        int n = sdfStartSymbolsStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            IStrategoString esvStartSymbol = factory.makeString(s);
            IStrategoAppl sortAppl = factory.makeAppl(sortCons, esvStartSymbol);
            list = factory.makeListCons(sortAppl, list);
            ++n2;
        }
        return list;
    }

    public void testModuleDefinitionDefineShouldPersists() throws IOException {
        ITermFactory f = this.termFactory();
        SpxModuleLookupTable lookupTable = this.mSymTable;
        IStrategoList pId = f.makeList(f.makeString("test"));
        IStrategoList idm1 = f.makeList(f.makeString("test"), f.makeString("m1"));
        ModuleDeclaration m1 = new ModuleDeclaration("c:/temp/test.spx", idm1, pId);
        lookupTable.define(this._facade, m1, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m1"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m1"));
        IStrategoList pId2 = f.makeList(f.makeString("test2"));
        IStrategoList idm2 = f.makeList(f.makeString("test"), f.makeString("m2"));
        ModuleDeclaration m2 = new ModuleDeclaration("c:/temp/test.spx", idm2, pId2);
        lookupTable.define(this._facade, m2, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m2"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m2"));
        IStrategoList idm3 = f.makeList(f.makeString("test"), f.makeString("m3"));
        ModuleDeclaration m3 = new ModuleDeclaration("c:/temp/test2.spx", idm3, pId);
        lookupTable.define(this._facade, m3, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m3"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m3"));
        SpxLookupTableUnitTests.assertEquals(3, lookupTable.size());
        this.manager.commit();
        ModuleDeclaration expected = m1;
        ModuleDeclaration actual = lookupTable.getModuleDeclaration(idm1);
        SpxLookupTableUnitTests.assertEquals(expected, actual);
    }

    public void testShouldReturnModuleByPackageId() throws IOException, SpxSymbolTableException {
        ITermFactory f = this.termFactory();
        SpxModuleLookupTable lookupTable = this.mSymTable;
        IStrategoList pId = f.makeList(f.makeString("test"));
        IStrategoList pId2 = f.makeList(f.makeString("test2"));
        IStrategoList idm1 = f.makeList(f.makeString("test"), f.makeString("m1"));
        ModuleDeclaration m1 = new ModuleDeclaration("c:/temp/test.spx", idm1, pId);
        lookupTable.define(this._facade, m1, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m1"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m1"));
        IStrategoList idm2 = f.makeList(f.makeString("test"), f.makeString("m2"));
        ModuleDeclaration m2 = new ModuleDeclaration("c:/temp/test.spx", idm2, pId2);
        lookupTable.define(this._facade, m2, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m2"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m2"));
        IStrategoList idm3 = f.makeList(f.makeString("test"), f.makeString("m3"));
        ModuleDeclaration m3 = new ModuleDeclaration("c:/temp/test2.spx", idm3, pId);
        lookupTable.define(this._facade, m3, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m3"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m3"));
        SpxLookupTableUnitTests.assertEquals(3, lookupTable.size());
        this.manager.commit();
        ArrayList modulesByPackageID = (ArrayList)lookupTable.getModuleDeclarationsByPackageId(pId);
        SpxLookupTableUnitTests.assertEquals(2, modulesByPackageID.size());
    }

    public void testShouldReturnModuleDeclarationByFilePath() throws IOException {
        ITermFactory f = this.termFactory();
        SpxModuleLookupTable lookupTable = this.mSymTable;
        IStrategoList pId = f.makeList(f.makeString("test"));
        IStrategoList pId2 = f.makeList(f.makeString("test2"));
        IStrategoList idm1 = f.makeList(f.makeString("test"), f.makeString("m1"));
        ModuleDeclaration m1 = new ModuleDeclaration("c:/temp/test.spx", idm1, pId);
        lookupTable.define(this._facade, m1, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m1"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m1"));
        IStrategoList idm2 = f.makeList(f.makeString("test"), f.makeString("m2"));
        ModuleDeclaration m2 = new ModuleDeclaration("c:/temp/test2.spx", idm2, pId2);
        lookupTable.define(this._facade, m2, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m2"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m2"));
        IStrategoList idm3 = f.makeList(f.makeString("test"), f.makeString("m3"));
        ModuleDeclaration m3 = new ModuleDeclaration("c:/temp/test2.spx", idm3, pId);
        lookupTable.define(this._facade, m3, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m3"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m3"));
        SpxLookupTableUnitTests.assertEquals(3, lookupTable.size());
        this.manager.commit();
        ArrayList modulesByFileUri = (ArrayList)lookupTable.getModuleDeclarationsByUri("c:/temp/test.spx");
        SpxLookupTableUnitTests.assertEquals(1, modulesByFileUri.size());
    }

    public void testShouldRemoveModuleDeclarationByFilePath() throws IOException {
        ITermFactory f = this.termFactory();
        SpxModuleLookupTable lookupTable = this.mSymTable;
        IStrategoList pId = f.makeList(f.makeString("test"));
        IStrategoList pId2 = f.makeList(f.makeString("test2"));
        IStrategoList idm1 = f.makeList(f.makeString("test"), f.makeString("m1"));
        ModuleDeclaration m1 = new ModuleDeclaration("c:/temp/test.spx", idm1, pId);
        lookupTable.define(this._facade, m1, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m1"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m1"));
        IStrategoList idm2 = f.makeList(f.makeString("test"), f.makeString("m2"));
        ModuleDeclaration m2 = new ModuleDeclaration("c:/temp/test2.spx", idm2, pId2);
        lookupTable.define(this._facade, m2, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m2"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m2"));
        IStrategoList idm3 = f.makeList(f.makeString("test"), f.makeString("m3"));
        ModuleDeclaration m3 = new ModuleDeclaration("c:/temp/test2.spx", idm3, pId);
        lookupTable.define(this._facade, m3, (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, "m3"), (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, "m3"));
        SpxLookupTableUnitTests.assertEquals(3, lookupTable.size());
        this.manager.commit();
        lookupTable.removeModuleDeclarationsByUri("c:/temp/test2.spx");
        SpxLookupTableUnitTests.assertEquals(1, lookupTable.size());
    }

    static IStrategoTerm getModuleDefinition(ITermFactory f, String moduleName) {
        String text = "Module(None(), SPXModuleName(\"" + moduleName + "\")" + ", [])";
        return f.parseFromString(text);
    }

    static IStrategoTerm getAnalyzedModuleDefinition(ITermFactory f, String moduleName) {
        return SpxLookupTableUnitTests.getModuleDefinition(f, moduleName);
    }
}

