/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.LanguageLibrary;
import org.spoofax.interpreter.library.language.spxlang.index.GlobalNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.INamespace;
import org.spoofax.interpreter.library.language.spxlang.index.PackageNamespace;
import org.spoofax.interpreter.library.language.spxlang.index.SpxPrimarySymbolTable;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacadeRegistry;
import org.spoofax.interpreter.library.language.spxlang.index.data.ModuleDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.NamespaceUri;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbol;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolKey;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.library.language.spxlang.index.tests.SpxIndexBaseTestCase;
import org.spoofax.interpreter.library.language.spxlang.index.tests.SpxLookupTableUnitTests;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class SpxPrimarySymbolTableTest
extends SpxIndexBaseTestCase {
    private final String _projectName = ".test-symbol-table_12";
    private IStrategoString projectNameTerm;
    private SpxSemanticIndexFacade _facade;
    private SpxPrimarySymbolTable symbol_table;
    private SpxSemanticIndexFacadeRegistry _registry;
    final String absPathString1 = "c:/temp/file1.spx";
    final String absPathString2 = "c:/temp/file2.spx";
    private PackageDeclaration packageDeclaration1;
    private PackageDeclaration packageDeclaration2;
    private PackageDeclaration packageDeclaration3;
    private ModuleDeclaration moduleDeclarationP1M1;
    private ModuleDeclaration moduleDeclarationP1M2;
    private ModuleDeclaration moduleDeclarationP2M1;
    private ModuleDeclaration moduleDeclarationP3M1;

    private Interpreter interpreter() {
        return this.itp;
    }

    private IOAgent ioAgent() {
        return this.itp.getIOAgent();
    }

    private ITermFactory termFactory() {
        return this.factory;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpreter().addOperatorRegistry(new LanguageLibrary());
        this._registry = new SpxSemanticIndexFacadeRegistry();
        this.projectNameTerm = this.termFactory().makeString(String.valueOf(System.getProperty("user.dir")) + "/" + ".test-symbol-table_12");
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        this._facade = this._registry.getFacade(this.projectNameTerm);
        this._facade.cleanIndexAndSymbolTable();
        this.symbol_table = this._facade.getPersistenceManager().spxSymbolTable();
    }

    protected void tearDown() throws Exception {
        this._facade.close(false);
    }

    private void indexCompilationUnit() throws IOException {
        ITermFactory f = this.termFactory();
        this._facade.indexCompilationUnit(f.makeString("c:/temp/file1.spx"), (IStrategoAppl)SpxPrimarySymbolTableTest.getCompilationUnit(f));
        this._facade.indexCompilationUnit(f.makeString("c:/temp/file2.spx"), (IStrategoAppl)SpxPrimarySymbolTableTest.getCompilationUnit(f));
    }

    private void setupScopeTree() throws IOException, SpxSymbolTableException {
        String packageName1 = "\"lang\", \"p1\"";
        String packageName2 = "\"lang\", \"p2\"";
        this.indexCompilationUnit();
        this.packageDeclaration1 = this.indexTestPackageDecl(packageName1, "c:/temp/file1.spx");
        this.packageDeclaration2 = this.indexTestPackageDecl(packageName2, "c:/temp/file2.spx");
        this.moduleDeclarationP1M1 = this.indexTestModuleDefs("p1m1", packageName1, "c:/temp/file1.spx");
        this.moduleDeclarationP1M2 = this.indexTestModuleDefs("p1m2", packageName1, "c:/temp/file1.spx");
        this.moduleDeclarationP2M1 = this.indexTestModuleDefs("p2m1", packageName2, "c:/temp/file2.spx");
    }

    public void testRemovingPackageDeclarationShouldAlsoRemoveNamespace() throws IOException, SpxSymbolTableException, URISyntaxException {
        this.setupScopeTree();
        INamespace ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace(this.packageDeclaration1.getId());
        SpxPrimarySymbolTableTest.assertNotNull(ns);
        IStrategoString uriTerm = this.termFactory().makeString("c:/temp/file1.spx");
        this._facade.getPersistenceManager().spxPackageTable().removePackageDeclarationLocation(this.packageDeclaration1.getId(), this._facade.toAbsulatePath(uriTerm));
        ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace(this.packageDeclaration1.getId());
        SpxPrimarySymbolTableTest.assertNull(ns);
    }

    public void testRemovingModuleDeclarationShouldAlsoRemoveNamespace() throws IOException, SpxSymbolTableException, URISyntaxException {
        this.setupScopeTree();
        INamespace ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace(this.moduleDeclarationP1M1.getId());
        SpxPrimarySymbolTableTest.assertNotNull(ns);
        this._facade.getPersistenceManager().spxModuleTable().remove(this.moduleDeclarationP1M1.getId());
        ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace(this.moduleDeclarationP1M1.getId());
        SpxPrimarySymbolTableTest.assertNull(ns);
    }

    public void testOnlyOneGlobalNamespaceExists() {
        SpxPrimarySymbolTableTest.assertEquals(1, this.noOfGlobalNamespaceInSymbolTable());
        this.symbol_table.addGlobalNamespace(this._facade);
        this.symbol_table.addGlobalNamespace(this._facade);
        this.symbol_table.addGlobalNamespace(this._facade);
        SpxPrimarySymbolTableTest.assertEquals(1, this.noOfGlobalNamespaceInSymbolTable());
    }

    public void testResolveNamespace() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        INamespace namespace = this.symbol_table.resolveNamespace(this.packageDeclaration1.getId());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(this.packageDeclaration1.getId()));
        NamespaceUri internalNamespaceUri = PackageNamespace.packageInternalNamespace(namespace.namespaceUri(), this._facade);
        namespace = this.symbol_table.resolveNamespace(internalNamespaceUri.id());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(internalNamespaceUri.id()));
        namespace = this.symbol_table.resolveNamespace(this.packageDeclaration1.getId());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(this.packageDeclaration1.getId()));
        internalNamespaceUri = PackageNamespace.packageInternalNamespace(namespace.namespaceUri(), this._facade);
        namespace = this.symbol_table.resolveNamespace(internalNamespaceUri.id());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(internalNamespaceUri.id()));
        namespace = this.symbol_table.resolveNamespace(this.packageDeclaration2.getId());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(this.packageDeclaration2.getId()));
        namespace = this.symbol_table.resolveNamespace(this.moduleDeclarationP1M1.getId());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(this.moduleDeclarationP1M1.getId()));
        namespace = this.symbol_table.resolveNamespace(this.moduleDeclarationP1M2.getId());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(this.moduleDeclarationP1M2.getId()));
        namespace = this.symbol_table.resolveNamespace(this.moduleDeclarationP2M1.getId());
        SpxPrimarySymbolTableTest.assertTrue(namespace.namespaceUri().id().equals(this.moduleDeclarationP2M1.getId()));
    }

    public void testNoOfNamespaceDefined() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        SpxPrimarySymbolTableTest.assertEquals(8, this.symbol_table.size());
    }

    public void testUnknownNamespaceShouldThrowRuntimeException() throws RuntimeException, SpxSymbolTableException, IOException {
        IStrategoAppl namespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoTuple symbolId = this.termFactory().makeTuple(namespaceAppl, this.termFactory().makeString("TestId"));
        IStrategoAppl typeAppl = namespaceAppl;
        IStrategoAppl pQnameUnknown = (IStrategoAppl)this.termFactory().parseFromString("Package(QName([\"lang\", \"unknown\"]))");
        try {
            this.setupScopeTree();
            this._facade.resolveSymbols(this.termFactory().makeTuple(pQnameUnknown, symbolId, typeAppl, this.termFactory().makeString("*")));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testDefiningGlobalSymbol() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl namespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoTuple symbolId = this.termFactory().makeTuple(namespaceAppl, this.termFactory().makeString("TestId"));
        IStrategoAppl data = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl = namespaceAppl;
        IStrategoAppl symbolDef = this.createEntry(namespaceAppl, symbolId, typeAppl, data);
        this._facade.indexSymbol(symbolDef);
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId, namespaceAppl.getConstructor(), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void testInvalidateGlobalCacheRemovesAllEntries() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl namespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoTuple symbolId = this.termFactory().makeTuple(namespaceAppl, this.termFactory().makeString("TestId"));
        IStrategoAppl data = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl = namespaceAppl;
        IStrategoAppl symbolDef = this.createEntry(namespaceAppl, symbolId, typeAppl, data);
        this._facade.indexSymbol(symbolDef);
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId, namespaceAppl.getConstructor(), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        this._facade.invalidateGlobalNamespace();
        resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId, namespaceAppl.getConstructor(), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
    }

    public void testUnknownConstructorInResolveSymbolShouldThrowException() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl namespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoTuple symbolId = this.termFactory().makeTuple(namespaceAppl, this.termFactory().makeString("TestId"));
        IStrategoAppl data = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl = namespaceAppl;
        IStrategoAppl symbolDef = this.createEntry(namespaceAppl, symbolId, typeAppl, data);
        this._facade.indexSymbol(symbolDef);
        try {
            this._facade.resolveSymbols(this.termFactory().makeTuple(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId, this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0])));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDefiningGlobalSymbols() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl namespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(namespaceAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        IStrategoTuple symbolId2 = symbolId1;
        IStrategoAppl data2 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl2 = this.termFactory().makeAppl(this.termFactory().makeConstructor("STRDef", 0), new IStrategoTerm[0]);
        IStrategoTuple symbolId3 = symbolId1;
        IStrategoAppl data3 = (IStrategoAppl)this.moduleDeclarationP1M2.toTerm(this._facade);
        IStrategoAppl typeAppl3 = typeAppl1;
        IStrategoAppl symbolDef1 = this.createEntry(namespaceAppl, symbolId1, typeAppl1, data1);
        IStrategoAppl symbolDef2 = this.createEntry(namespaceAppl, symbolId2, typeAppl2, data2);
        IStrategoAppl symbolDef3 = this.createEntry(namespaceAppl, symbolId3, typeAppl3, data3);
        this._facade.indexSymbol(symbolDef1);
        this._facade.indexSymbol(symbolDef2);
        this._facade.indexSymbol(symbolDef3);
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(2, resolvedSymbols.size());
        resolvedSymbols = this._facade.resolveSymbol(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId1, this._facade.getCons().getConstructor("STRDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void testUnknownSymbolResolveShouldReturnNull() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl currentAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2);
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(currentAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(currentAppl, symbolId1, typeAppl1, data1));
        IStrategoTuple symbolUnknownId = this.termFactory().makeTuple(currentAppl, this.termFactory().makeString("_"));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolUnknownId, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
    }

    public void testResolveModuleSymbols() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl currentAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2);
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(currentAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(currentAppl, symbolId1, typeAppl1, data1));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("SDFDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(currentAppl.getSubterm(0).getSubterm(0), actual.namespaceUri().id()));
    }

    public void testShouldNotResolveModuleSymbolsFromOtherPackage() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl currentAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2);
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(currentAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(currentAppl, symbolId1, typeAppl1, data1));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP2M1), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
    }

    public void test_ShouldFind_GlobalSymbol_from_InternalScope() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl namespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoTuple symbolId = this.termFactory().makeTuple(namespaceAppl, this.termFactory().makeString("TestId"));
        IStrategoAppl data = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl = namespaceAppl;
        IStrategoAppl symbolDef = this.createEntry(namespaceAppl, symbolId, typeAppl, data);
        this._facade.indexSymbol(symbolDef);
        IStrategoAppl internalModuleAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, PackageNamespace.packageInternalModuleId(this.packageDeclaration2.getId(), this._facade));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(internalModuleAppl, symbolId, namespaceAppl.getConstructor(), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void test_ShouldResolveModuleInternalSymbols_from_Module_in_same_Package() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl internalModuleAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, PackageNamespace.packageInternalModuleId(this.packageDeclaration2.getId(), this._facade));
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(internalModuleAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(internalModuleAppl, symbolId1, typeAppl1, data1));
        boolean returnDuplicates = false;
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP2M1.getId()), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, returnDuplicates);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void test_ShouldResolveModuleInternalSymbols_From_Internal_Module_of_same_Package() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl internalModuleAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, PackageNamespace.packageInternalModuleId(this.packageDeclaration2.getId(), this._facade));
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(internalModuleAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(internalModuleAppl, symbolId1, typeAppl1, data1));
        boolean returnDuplicates = false;
        Set resolvedSymbols = null;
        resolvedSymbols = (Set)this._facade.resolveSymbols(internalModuleAppl, symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, returnDuplicates);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void test_Should_NOT_ResolveModuleInternalSymbols_from_Other_Scope() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl internalModuleAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, PackageNamespace.packageInternalModuleId(this.packageDeclaration2.getId(), this._facade));
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(internalModuleAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(internalModuleAppl, symbolId1, typeAppl1, data1));
        boolean returnDuplicates = false;
        Set resolvedSymbols = null;
        resolvedSymbols = (Set)this._facade.resolveSymbols(PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration1.getId()), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, returnDuplicates);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
        resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2.getId()), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, returnDuplicates);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
        resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, PackageNamespace.packageInternalModuleId(this.packageDeclaration1.getId(), this._facade)), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, returnDuplicates);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
    }

    public void test_ShouldResolveModuleInternalSymbols_from_same_Package() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl internalModuleAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, PackageNamespace.packageInternalModuleId(this.packageDeclaration2.getId(), this._facade));
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(internalModuleAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(internalModuleAppl, symbolId1, typeAppl1, data1));
        boolean returnDuplicates = false;
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration2.getId()), symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, returnDuplicates);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void test_Should_ResolveModuleInternalSymbols_from_Module() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        IStrategoAppl internalModuleAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, PackageNamespace.packageInternalModuleId(this.packageDeclaration2.getId(), this._facade));
        IStrategoTuple symbolId1 = this.termFactory().makeTuple(internalModuleAppl, this.termFactory().makeString("1"));
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(internalModuleAppl, symbolId1, typeAppl1, data1));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(internalModuleAppl, symbolId1, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("SDFDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(internalModuleAppl.getSubterm(0).getSubterm(0), actual.namespaceUri().id()));
    }

    public void testShouldNotResolveSymbolFromImportedNamespaceInCyclicReference() throws IOException, SpxSymbolTableException {
        IStrategoAppl packageQNameAppl;
        this.setupScopeTree();
        this.indexImportRef(this.packageDeclaration1, this.packageDeclaration1);
        IStrategoAppl symbolId1 = packageQNameAppl = PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration2.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(packageQNameAppl, symbolId1, typeAppl1, data1));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration1.getId()), symbolId1, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
    }

    public void testShouldResolveSymbolFromImportedNamespace() throws IOException, SpxSymbolTableException {
        IStrategoAppl packageQNameAppl;
        this.createExtendedScopeTree();
        IStrategoAppl symbolId1 = packageQNameAppl = PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration2.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(packageQNameAppl, symbolId1, typeAppl1, data1));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration1.getId()), symbolId1, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void testShouldNotAllowTransitiveImports() throws IOException, SpxSymbolTableException {
        IStrategoAppl moduleQnameAppl;
        this.createExtendedScopeTree();
        String packageName3 = "\"lang\", \"p3\"";
        this.packageDeclaration3 = this.indexTestPackageDecl(packageName3, "c:/temp/file2.spx");
        this.moduleDeclarationP3M1 = this.indexTestModuleDefs("p3m1", packageName3, "c:/temp/file2.spx");
        IStrategoAppl symbolId1 = moduleQnameAppl = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP3M1.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl, symbolId1, typeAppl1, data1));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId()), symbolId1, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
        resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP2M1.getId()), symbolId1, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("ModuleDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(this.moduleDeclarationP3M1.getId(), actual.namespaceUri().id()));
    }

    public void testShouldNotRetrunTransitiveImportSymbols() throws IOException, SpxSymbolTableException {
        this.createExtendedScopeTree();
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl moduleQnameAppl3 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP3M1.getId());
        IStrategoAppl symbolId1 = moduleQnameAppl1;
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        IStrategoAppl symbolId3 = moduleQnameAppl1;
        IStrategoAppl data3 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl3 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl3, symbolId3, typeAppl3, data3));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId()), symbolId3, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("ModuleDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId3, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(this.moduleDeclarationP1M1.getId(), actual.namespaceUri().id()));
    }

    public void testShouldRetrunSymbolsFromImportedScope() throws IOException, SpxSymbolTableException {
        this.createExtendedScopeTree();
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl moduleQnameAppl3 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP3M1.getId());
        IStrategoAppl symbolId1 = moduleQnameAppl1;
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        IStrategoAppl symbolId3 = moduleQnameAppl1;
        IStrategoAppl data3 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl3 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl3, symbolId3, typeAppl3, data3));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP2M1.getId()), symbolId3, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("ModuleDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId3, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(this.moduleDeclarationP3M1.getId(), actual.namespaceUri().id()));
    }

    public void testShouldNotFailIncaseOfCyclicImports() throws Exception {
        this.createExtendedScopeTree();
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl moduleQnameAppl3 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP3M1.getId());
        IStrategoAppl symbolId1 = moduleQnameAppl1;
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        IStrategoAppl symbolId3 = moduleQnameAppl1;
        IStrategoAppl data3 = (IStrategoAppl)this.moduleDeclarationP3M1.toTerm(this._facade);
        IStrategoAppl typeAppl3 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl3, symbolId3, typeAppl3, data3));
        this._facade.commitChanges();
        this._registry.closePersistenceManager(this.projectNameTerm);
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        SpxSemanticIndexFacade tfacade = this._registry.getFacade(this.projectNameTerm);
        Set<SpxSymbol> resolvedSymbols = (Set<SpxSymbol>)tfacade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP3M1.getId()), symbolId3, tfacade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(2, resolvedSymbols.size());
        resolvedSymbols = tfacade.resolveSymbol(ModuleDeclaration.toModuleQNameAppl(tfacade, this.moduleDeclarationP3M1.getId()), symbolId3, tfacade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(this.moduleDeclarationP3M1.getId(), actual.namespaceUri().id()));
    }

    public void testAnonymousScopeCreation() throws IOException, SpxSymbolTableException {
        this.createExtendedScopeTree();
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl nsAppl = (IStrategoAppl)this._facade.insertNewScope(moduleQnameAppl1);
        SpxPrimarySymbolTableTest.assertEquals(this._facade.getCons().getLocalNamespaceTypeCon(), nsAppl.getConstructor());
        INamespace ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace((IStrategoList)nsAppl.getSubterm(0));
        SpxPrimarySymbolTableTest.assertNotNull(ns);
    }

    public void testDestroyAnonymousScope() throws IOException, SpxSymbolTableException {
        this.createExtendedScopeTree();
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl nsAppl = (IStrategoAppl)this._facade.insertNewScope(moduleQnameAppl1);
        SpxPrimarySymbolTableTest.assertEquals(this._facade.getCons().getLocalNamespaceTypeCon(), nsAppl.getConstructor());
        INamespace ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace((IStrategoList)nsAppl.getSubterm(0));
        SpxPrimarySymbolTableTest.assertNotNull(ns);
        try {
            nsAppl = (IStrategoAppl)this._facade.destroyScope(moduleQnameAppl1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        nsAppl = (IStrategoAppl)this._facade.destroyScope(nsAppl);
        SpxPrimarySymbolTableTest.assertNotNull(ns);
        ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace((IStrategoList)nsAppl.getSubterm(0));
        SpxPrimarySymbolTableTest.assertNull(ns);
    }

    public void testshouldReturnDuplicates() throws IOException, SpxSymbolTableException {
        IStrategoAppl moduleQnameAppl1;
        this.createExtendedScopeTree();
        IStrategoAppl moduleQnameAppl2 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2.getId());
        IStrategoAppl symbolId1 = moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl2, symbolId1, typeAppl1, data1));
        IStrategoAppl nsAppl = PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration1.getId());
        Collection<SpxSymbol> resolvedSymbols = this._facade.resolveSymbols(nsAppl, symbolId1, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, true);
        SpxPrimarySymbolTableTest.assertEquals(2, resolvedSymbols.size());
    }

    public void testResolveInAnonymousScopeShouldReturnEnclosingSymbols() throws IOException, SpxSymbolTableException {
        IStrategoAppl moduleQnameAppl1;
        this.createExtendedScopeTree();
        IStrategoAppl symbolId1 = moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        IStrategoAppl nsAppl = (IStrategoAppl)this._facade.insertNewScope(moduleQnameAppl1);
        SpxPrimarySymbolTableTest.assertEquals(this._facade.getCons().getLocalNamespaceTypeCon(), nsAppl.getConstructor());
        INamespace ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace((IStrategoList)nsAppl.getSubterm(0));
        SpxPrimarySymbolTableTest.assertNotNull(ns);
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(nsAppl, symbolId1, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("ModuleDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(this.moduleDeclarationP1M1.getId(), actual.namespaceUri().id()));
        IStrategoAppl globalNamespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoTuple symbolId2 = this.termFactory().makeTuple(globalNamespaceAppl, this.termFactory().makeString("1"));
        IStrategoAppl data2 = (IStrategoAppl)this.moduleDeclarationP1M2.toTerm(this._facade);
        IStrategoAppl typeAppl2 = this.termFactory().makeAppl(this.termFactory().makeConstructor("SDFDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(globalNamespaceAppl, symbolId2, typeAppl2, data2));
        resolvedSymbols = (Set)this._facade.resolveSymbols(nsAppl, symbolId2, this._facade.getCons().getConstructor("SDFDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("SDFDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId2, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(GlobalNamespace.getGlobalNamespaceId(this._facade), actual.namespaceUri().id()));
    }

    public void testResolveInAnonymousScope() throws IOException, SpxSymbolTableException {
        IStrategoAppl moduleQnameAppl1;
        this.createExtendedScopeTree();
        IStrategoAppl globalNsAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoAppl symbolId1 = moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        IStrategoAppl nsAppl = (IStrategoAppl)this._facade.insertNewScope(globalNsAppl);
        SpxPrimarySymbolTableTest.assertEquals(this._facade.getCons().getLocalNamespaceTypeCon(), nsAppl.getConstructor());
        INamespace ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace((IStrategoList)nsAppl.getSubterm(0));
        SpxPrimarySymbolTableTest.assertNotNull(ns);
        this._facade.indexSymbol(this.createEntry(nsAppl, symbolId1, typeAppl1, data1));
        Set resolvedSymbols = (Set)this._facade.resolveSymbols(nsAppl, symbolId1, this._facade.getCons().getConstructor("ModuleDef", 0), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        SpxSymbol actual = (SpxSymbol)resolvedSymbols.toArray()[0];
        SpxPrimarySymbolTableTest.assertEquals("ModuleDef", actual.getSignatureString());
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, actual.Id(this._facade.getTermFactory())));
        SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals((IStrategoList)nsAppl.getSubterm(0), actual.namespaceUri().id()));
        this._facade.destroyScope(nsAppl);
        ns = this._facade.getPersistenceManager().spxSymbolTable().resolveNamespace((IStrategoList)nsAppl.getSubterm(0));
        SpxPrimarySymbolTableTest.assertNull(ns);
    }

    public void testUndefineSymbols() throws Exception {
        IStrategoAppl moduleQnameAppl1;
        this.createExtendedScopeTree();
        IStrategoAppl symbolId1 = moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        IStrategoAppl symbolId2 = moduleQnameAppl1;
        IStrategoAppl data2 = (IStrategoAppl)this.moduleDeclarationP1M2.toTerm(this._facade);
        IStrategoAppl typeAppl2 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef__", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId2, typeAppl2, data2));
        IStrategoAppl symbolId3 = moduleQnameAppl1;
        IStrategoAppl data3 = (IStrategoAppl)this.moduleDeclarationP2M1.toTerm(this._facade);
        IStrategoAppl typeAppl3 = typeAppl1;
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId3, typeAppl3, data3));
        this._facade.commitChanges();
        this._registry.closePersistenceManager(this.projectNameTerm);
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        SpxSemanticIndexFacade tfacade = this._registry.getFacade(this.projectNameTerm);
        Set<SpxSymbol> resolvedSymbols = tfacade.getPersistenceManager().spxSymbolTable().undefineSymbols(this.moduleDeclarationP1M1.getId(), symbolId1, typeAppl1.getConstructor());
        SpxPrimarySymbolTableTest.assertEquals(2, resolvedSymbols.size());
        for (SpxSymbol sym : resolvedSymbols) {
            SpxPrimarySymbolTableTest.assertTrue(sym.equalSignature(typeAppl1.getConstructor()));
        }
        List<SpxSymbol> resolvedSymbols1 = tfacade.getPersistenceManager().spxSymbolTable().resolveNamespace(this.moduleDeclarationP1M1.getId()).getMembers().get(new SpxSymbolKey(symbolId1, typeAppl2.getConstructor()));
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols1.size());
        for (SpxSymbol sym : resolvedSymbols1) {
            SpxPrimarySymbolTableTest.assertTrue(sym.equalSignature(typeAppl2.getConstructor()));
        }
    }

    public void test_Resolve_Depth_Zero_ShouldOnlyResolve_LocalSymbol() throws Exception {
        boolean resolveDepth = false;
        this.createExtendedScopeTree();
        IStrategoAppl globalNamespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl moduleQnameAppl2 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2.getId());
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl symbolId2 = moduleQnameAppl2;
        IStrategoAppl typeAppl2 = typeAppl1;
        IStrategoAppl data2 = data1;
        IStrategoAppl symbolId3 = moduleQnameAppl1;
        IStrategoAppl data3 = data1;
        IStrategoAppl typeAppl3 = typeAppl1;
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl2, symbolId2, typeAppl2, data2));
        this._facade.indexSymbol(this.createEntry(globalNamespaceAppl, symbolId3, typeAppl3, data3));
        this._facade.commitChanges();
        this._registry.closePersistenceManager(this.projectNameTerm);
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        SpxSemanticIndexFacade tfacade = this._registry.getFacade(this.projectNameTerm);
        Set<SpxSymbol> resolvedSymbols = tfacade.resolveSymbol(moduleQnameAppl1, symbolId2, typeAppl1.getConstructor(), 0);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
        resolvedSymbols = tfacade.resolveSymbol(moduleQnameAppl1, symbolId2, typeAppl1.getConstructor(), Integer.MAX_VALUE);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
    }

    public void test_Resolve_Depth_Zero_ShouldOnlyResolve_LocalSymbols() throws Exception {
        boolean resolveDepth = false;
        this.createExtendedScopeTree();
        IStrategoAppl globalNamespaceAppl = this.termFactory().makeAppl(this._facade.getCons().getGlobalNamespaceTypeCon(), new IStrategoTerm[0]);
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl moduleQnameAppl2 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2.getId());
        IStrategoAppl moduleQnameAppl3 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP2M1.getId());
        IStrategoAppl symbolId1 = moduleQnameAppl1;
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl symbolId2 = moduleQnameAppl1;
        IStrategoAppl typeAppl2 = typeAppl1;
        IStrategoAppl data2 = data1;
        IStrategoAppl symbolId3 = moduleQnameAppl1;
        IStrategoAppl data3 = data1;
        IStrategoAppl typeAppl3 = typeAppl1;
        IStrategoAppl symbolId4 = moduleQnameAppl1;
        IStrategoAppl data4 = data1;
        IStrategoAppl typeAppl4 = typeAppl1;
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl2, symbolId2, typeAppl2, data2));
        this._facade.indexSymbol(this.createEntry(globalNamespaceAppl, symbolId3, typeAppl3, data3));
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl3, symbolId4, typeAppl4, data4));
        this._facade.commitChanges();
        this._registry.closePersistenceManager(this.projectNameTerm);
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        SpxSemanticIndexFacade tfacade = this._registry.getFacade(this.projectNameTerm);
        Set resolvedSymbols = (Set)tfacade.resolveSymbols(moduleQnameAppl1, symbolId1, typeAppl1.getConstructor(), 0, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        for (SpxSymbol sym : resolvedSymbols) {
            SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, sym.Id(this._facade.getTermFactory())));
            SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(this.moduleDeclarationP1M1.getId(), sym.namespaceUri().id()));
            SpxPrimarySymbolTableTest.assertTrue(sym.equalSignature(typeAppl1.getConstructor()));
        }
        resolvedSymbols = (Set)tfacade.resolveSymbols(PackageDeclaration.toPackageQNameAppl(this._facade, this.packageDeclaration1.getId()), symbolId1, typeAppl1.getConstructor(), 0, false);
        SpxPrimarySymbolTableTest.assertEquals(2, resolvedSymbols.size());
        for (SpxSymbol sym : resolvedSymbols) {
            SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, sym.Id(this._facade.getTermFactory())));
            SpxPrimarySymbolTableTest.assertTrue(sym.equalSignature(typeAppl1.getConstructor()));
        }
        resolvedSymbols = (Set)tfacade.resolveSymbols(moduleQnameAppl1, symbolId1, typeAppl1.getConstructor(), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(4, resolvedSymbols.size());
        for (SpxSymbol sym : resolvedSymbols) {
            SpxPrimarySymbolTableTest.assertTrue(SpxSymbol.verifyEquals(symbolId1, sym.Id(this._facade.getTermFactory())));
            SpxPrimarySymbolTableTest.assertTrue(sym.equalSignature(typeAppl1.getConstructor()));
        }
    }

    public void test_Resolve_Depth_Zero_ShouldOnlyResolve_LocalSymbols2() throws Exception {
        IStrategoAppl moduleQnameAppl1;
        boolean resolveDepth = false;
        this.createExtendedScopeTree();
        IStrategoAppl symbolId1 = moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        IStrategoAppl moduleQnameAppl2 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2.getId());
        IStrategoAppl symbolId2 = moduleQnameAppl1;
        IStrategoAppl data2 = (IStrategoAppl)this.moduleDeclarationP1M2.toTerm(this._facade);
        IStrategoAppl typeAppl2 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef__", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl2, symbolId2, typeAppl2, data2));
        this._facade.commitChanges();
        this._registry.closePersistenceManager(this.projectNameTerm);
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        SpxSemanticIndexFacade tfacade = this._registry.getFacade(this.projectNameTerm);
        Set resolvedSymbols = (Set)tfacade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP3M1.getId()), symbolId1, typeAppl1.getConstructor(), 0, false);
        SpxPrimarySymbolTableTest.assertEquals(0, resolvedSymbols.size());
    }

    public void testResolveShouldReturnAllSymbolsOfaType() throws Exception {
        this.createExtendedScopeTree();
        IStrategoAppl moduleQnameAppl1 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId());
        IStrategoAppl moduleQnameAppl2 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M2.getId());
        IStrategoAppl moduleQnameAppl3 = ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP2M1.getId());
        IStrategoAppl symbolId1 = moduleQnameAppl1;
        IStrategoAppl data1 = (IStrategoAppl)this.moduleDeclarationP1M1.toTerm(this._facade);
        IStrategoAppl typeAppl1 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl1, symbolId1, typeAppl1, data1));
        IStrategoAppl symbolId2 = moduleQnameAppl1;
        IStrategoAppl data2 = (IStrategoAppl)this.moduleDeclarationP1M2.toTerm(this._facade);
        IStrategoAppl typeAppl2 = this.termFactory().makeAppl(this.termFactory().makeConstructor("ModuleDef__", 0), new IStrategoTerm[0]);
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl2, symbolId2, typeAppl2, data2));
        IStrategoAppl symbolId3 = moduleQnameAppl1;
        IStrategoAppl data3 = (IStrategoAppl)this.moduleDeclarationP2M1.toTerm(this._facade);
        IStrategoAppl typeAppl3 = typeAppl1;
        this._facade.indexSymbol(this.createEntry(moduleQnameAppl3, symbolId3, typeAppl3, data3));
        this._facade.commitChanges();
        this._registry.closePersistenceManager(this.projectNameTerm);
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        SpxSemanticIndexFacade tfacade = this._registry.getFacade(this.projectNameTerm);
        Set resolvedSymbols = (Set)tfacade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP3M1.getId()), this.termFactory().makeString("*"), typeAppl1.getConstructor(), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(1, resolvedSymbols.size());
        for (SpxSymbol sym : resolvedSymbols) {
            SpxPrimarySymbolTableTest.assertTrue(sym.equalSignature(typeAppl1.getConstructor()));
        }
        resolvedSymbols = (Set)tfacade.resolveSymbols(ModuleDeclaration.toModuleQNameAppl(this._facade, this.moduleDeclarationP1M1.getId()), this.termFactory().makeString("*"), typeAppl1.getConstructor(), Integer.MAX_VALUE, false);
        SpxPrimarySymbolTableTest.assertEquals(2, resolvedSymbols.size());
        for (SpxSymbol sym : resolvedSymbols) {
            SpxPrimarySymbolTableTest.assertTrue(sym.equalSignature(typeAppl1.getConstructor()));
        }
    }

    private void indexImportRef(PackageDeclaration decl, PackageDeclaration importPackageDecl) throws SpxSymbolTableException {
        IStrategoConstructor importCtor = this._facade.getCons().getImportDeclCon();
        IStrategoAppl importDecl = this.termFactory().makeAppl(importCtor, PackageDeclaration.toPackageQNameAppl(this._facade, decl.getId()), this.termFactory().makeList(PackageDeclaration.toPackageQNameAppl(this._facade, importPackageDecl.getId())));
        this._facade.indexImportReferences(importDecl);
    }

    private void createExtendedScopeTree() throws IOException, SpxSymbolTableException {
        this.setupScopeTree();
        String packageName3 = "\"lang\", \"p3\"";
        this.packageDeclaration3 = this.indexTestPackageDecl(packageName3, "c:/temp/file2.spx");
        this.moduleDeclarationP3M1 = this.indexTestModuleDefs("p3m1", packageName3, "c:/temp/file2.spx");
        this.indexImportRef(this.packageDeclaration1, this.packageDeclaration2);
        this.indexImportRef(this.packageDeclaration2, this.packageDeclaration3);
        this.indexImportRef(this.packageDeclaration3, this.packageDeclaration1);
    }

    private IStrategoAppl createEntry(IStrategoAppl namespaceAppl, IStrategoTerm id, IStrategoAppl typeAppl, IStrategoTerm data) {
        IStrategoConstructor ctor = this._facade.getCons().getSymbolTableEntryDefCon();
        IStrategoAppl symbolEntryAppl = this.termFactory().makeAppl(ctor, namespaceAppl, id, typeAppl, data, this.termFactory().makeAppl(this._facade.getCons().getOverridableSymbolTypeCon(), new IStrategoTerm[0]));
        return symbolEntryAppl;
    }

    static IStrategoTerm getCompilationUnit(ITermFactory f) {
        String text = "CompilationUnit([], [ Package(      QName([\"languages\", \"entitylang\"])    , [ Module(          None()         , SPXModuleName(\"Entitylang-Descriptor\")        , [          ]        )      ]    )  ])";
        return f.parseFromString(text);
    }

    private IStrategoTerm getId(String idString) {
        return this.termFactory().parseFromString(idString);
    }

    private ModuleDeclaration indexTestModuleDefs(String moduleName, String packageQName, String filePath) throws SpxSymbolTableException, IOException {
        String moduleQName = String.valueOf(packageQName) + ", \"" + moduleName + "\"";
        IStrategoAppl pQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Package(QName([" + packageQName + "]))");
        IStrategoAppl mQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Module(QName([" + moduleQName + "]))");
        IStrategoAppl ast = (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(this.termFactory(), moduleName);
        IStrategoAppl analyzed_ast = (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(this.termFactory(), moduleName);
        this._facade.indexModuleDefinition(mQnameAppl, this.termFactory().makeString(filePath), pQnameAppl, ast, analyzed_ast);
        return this._facade.lookupModuleDecl(mQnameAppl);
    }

    private PackageDeclaration indexTestPackageDecl(String packageName, String fileName) throws SpxSymbolTableException {
        IStrategoAppl pQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Package(QName([" + packageName + "]))");
        this._facade.indexPackageDeclaration(pQnameAppl, this.termFactory().makeString(fileName));
        return this._facade.lookupPackageDecl(pQnameAppl);
    }

    private int noOfGlobalNamespaceInSymbolTable() {
        int noOfGlobalNamespace = 0;
        Set<NamespaceUri> uris = this.symbol_table.getAllNamespaces();
        for (NamespaceUri uri : uris) {
            if (!uri.equalSpoofaxId(GlobalNamespace.getGlobalNamespaceId(this._facade))) continue;
            ++noOfGlobalNamespace;
        }
        return noOfGlobalNamespace;
    }
}

