/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.tests;

import java.io.IOException;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.LanguageLibrary;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacadeRegistry;
import org.spoofax.interpreter.library.language.spxlang.index.data.PackageDeclaration;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableException;
import org.spoofax.interpreter.library.language.spxlang.index.tests.SpxIndexBaseTestCase;
import org.spoofax.interpreter.library.language.spxlang.index.tests.SpxLookupTableUnitTests;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class SpxSemanticIndexFacadeTest
extends SpxIndexBaseTestCase {
    private final String _projectName = "test-sybol-table_1";
    private IStrategoString projectNameTerm;
    private SpxSemanticIndexFacade _facade;
    private SpxSemanticIndexFacadeRegistry _registry;
    final String absPathString1 = "c:/temp/test1.spx";
    final String absPathString2 = "c:/temp/test2.spx";

    private Interpreter interpreter() {
        return this.itp;
    }

    private IOAgent ioAgent() {
        return this.itp.getIOAgent();
    }

    private ITermFactory termFactory() {
        return this.factory;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpreter().addOperatorRegistry(new LanguageLibrary());
        this._registry = new SpxSemanticIndexFacadeRegistry();
        this.projectNameTerm = this.termFactory().makeString(String.valueOf(System.getProperty("user.dir")) + "/" + "test-sybol-table_1");
        this._registry.initFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        this._facade = this._registry.getFacade(this.projectNameTerm);
        this._facade.cleanIndexAndSymbolTable();
        this.indexCompilationUnit();
    }

    protected void tearDown() throws Exception {
        this._facade.close(false);
    }

    public void testGetModuleDeclarationsByFileUri() throws IOException {
        String packageName1 = "\"languages\", \"entitylang\"";
        this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        this.indexTestModuleDefs("p1m1", packageName1, "c:/temp/test1.spx");
        this.indexTestModuleDefs("p1m2", packageName1, "c:/temp/test1.spx");
        String packageName2 = "\"languages\", \"entitylang2\"";
        this.indexTestPackageDecl(packageName2, "c:/temp/test1.spx");
        this.indexTestModuleDefs("p2m2", packageName2, "c:/temp/test1.spx");
        String packageName3 = "\"languages\", \"entitylang2\"";
        this.indexTestPackageDecl(packageName3, "c:/temp/test2.spx");
        this.indexTestModuleDefs("p3m2", packageName3, "c:/temp/test2.spx");
        IStrategoList actuals = null;
        actuals = this._facade.getModuleDeclarations(this.termFactory().makeString("c:/temp/test1.spx"));
        SpxSemanticIndexFacadeTest.assertEquals(3, actuals.getSubtermCount());
        actuals = this._facade.getModuleDeclarations(this.termFactory().makeString("c:/temp/test2.spx"));
        SpxSemanticIndexFacadeTest.assertEquals(1, actuals.getSubtermCount());
        this._facade.getPersistenceManager().spxSymbolTable().getAllNamespaces();
    }

    public void testGetModuleDeclarationsByPackageId() throws SpxSymbolTableException, IOException {
        String packageName1 = "\"languages\", \"entitylang\"";
        IStrategoAppl pQnameAppl = this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        this.indexTestModuleDefs("m1", packageName1, "c:/temp/test1.spx");
        this.indexTestModuleDefs("m2", packageName1, "c:/temp/test1.spx");
        String packageName2 = "\"languages\", \"entitylang2\"";
        IStrategoAppl pQnameAppl2 = this.indexTestPackageDecl(packageName2, "c:/temp/test1.spx");
        this.indexTestModuleDefs("m2", packageName2, "c:/temp/test1.spx");
        IStrategoList actuals = null;
        actuals = this._facade.getModuleDeclarations(pQnameAppl);
        SpxSemanticIndexFacadeTest.assertEquals(2, actuals.getSubtermCount());
        actuals = this._facade.getModuleDeclarations(pQnameAppl2);
        SpxSemanticIndexFacadeTest.assertEquals(1, actuals.getSubtermCount());
    }

    public void testGetModuleDeclarationsWithUnknownPackageID() throws SpxSymbolTableException, IOException {
        String packageName1 = "\"languages\", \"entitylang\"";
        this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        this.indexTestModuleDefs("m1", packageName1, "c:/temp/test1.spx");
        this.indexTestModuleDefs("m2", packageName1, "c:/temp/test1.spx");
        String packageName2 = "\"languages\", \"entitylang2\"";
        this.indexTestPackageDecl(packageName2, "c:/temp/test1.spx");
        this.indexTestModuleDefs("m2", packageName2, "c:/temp/test1.spx");
        String unknown = "\"languages\", \"unknown\"";
        IStrategoAppl pUnknownQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Package(QName([" + unknown + "]))");
        IStrategoList actuals = null;
        try {
            actuals = this._facade.getModuleDeclarations(pUnknownQnameAppl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetPackageDeclarationsByUri() throws IOException {
        String packageName1 = "\"languages\", \"entitylang\"";
        this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        String packageName2 = "\"languages\", \"entitylang2\"";
        this.indexTestPackageDecl(packageName2, "c:/temp/test1.spx");
        String packageName3 = "\"languages\", \"entitylang2\"";
        this.indexTestPackageDecl(packageName3, "c:/temp/test2.spx");
        IStrategoList actuals = null;
        actuals = this._facade.getPackageDeclarations(this.termFactory().makeString("c:/temp/test2.spx"));
        SpxSemanticIndexFacadeTest.assertEquals(1, actuals.getSubtermCount());
        actuals = this._facade.getPackageDeclarations(this.termFactory().makeString("c:/temp/test1.spx"));
        SpxSemanticIndexFacadeTest.assertEquals(2, actuals.getSubtermCount());
    }

    public void testIndexingImportReferences() throws SpxSymbolTableException, IOException {
        String packageName1 = "\"languages\", \"entitylang1\"";
        String packageName2 = "\"languages\", \"entitylang2\"";
        IStrategoAppl pQnameAppl1 = this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        IStrategoAppl pQnameAppl2 = this.indexTestPackageDecl(packageName2, "c:/temp/test1.spx");
        String packageName3 = "\"languages\", \"entitylang3\"";
        IStrategoAppl pQnameAppl3 = this.indexTestPackageDecl(packageName3, "c:/temp/test1.spx");
        IStrategoAppl mQnameAppl2 = this.indexTestModuleDefs("m2", packageName3, "c:/temp/test1.spx");
        IStrategoAppl importDecl1 = this.termFactory().makeAppl(this._facade.getCons().getImportDeclCon(), pQnameAppl3, this.termFactory().makeList(pQnameAppl1));
        this._facade.indexImportReferences(importDecl1);
        IStrategoAppl importDecl2 = this.termFactory().makeAppl(this._facade.getCons().getImportDeclCon(), mQnameAppl2, this.termFactory().makeList(pQnameAppl2));
        this._facade.indexImportReferences(importDecl2);
        IStrategoList actuals = null;
        actuals = (IStrategoList)this._facade.getImportReferences(pQnameAppl1);
        SpxSemanticIndexFacadeTest.assertEquals(0, actuals.size());
        actuals = (IStrategoList)this._facade.getImportReferences(mQnameAppl2);
        SpxSemanticIndexFacadeTest.assertEquals(2, actuals.size());
        actuals = (IStrategoList)this._facade.getImportReferences(pQnameAppl3);
        SpxSemanticIndexFacadeTest.assertEquals(2, actuals.size());
        PackageDeclaration decl = this._facade.lookupPackageDecl(pQnameAppl1);
        SpxSemanticIndexFacadeTest.assertEquals(1, this._facade.getPersistenceManager().spxPackageTable().getImportedToReferencesOf(decl.getId()).size());
    }

    public void testIndexingImportToReferences() throws SpxSymbolTableException, IOException {
        String packageName1 = "\"languages\", \"entitylang1\"";
        String packageName2 = "\"languages\", \"entitylang2\"";
        IStrategoAppl pQnameAppl1 = this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        IStrategoAppl pQnameAppl2 = this.indexTestPackageDecl(packageName2, "c:/temp/test1.spx");
        String packageName3 = "\"languages\", \"entitylang3\"";
        IStrategoAppl pQnameAppl3 = this.indexTestPackageDecl(packageName3, "c:/temp/test1.spx");
        IStrategoAppl importDecl1 = this.termFactory().makeAppl(this._facade.getCons().getImportDeclCon(), pQnameAppl3, this.termFactory().makeList(pQnameAppl1));
        this._facade.indexImportReferences(importDecl1);
        importDecl1 = this.termFactory().makeAppl(this._facade.getCons().getImportDeclCon(), pQnameAppl3, this.termFactory().makeList(pQnameAppl2));
        this._facade.indexImportReferences(importDecl1);
        IStrategoList actuals = null;
        actuals = (IStrategoList)this._facade.getImportReferences(pQnameAppl1);
        SpxSemanticIndexFacadeTest.assertEquals(0, actuals.size());
        actuals = (IStrategoList)this._facade.getImportReferences(pQnameAppl3);
        SpxSemanticIndexFacadeTest.assertEquals(2, actuals.size());
        PackageDeclaration decl = this._facade.lookupPackageDecl(pQnameAppl1);
        SpxSemanticIndexFacadeTest.assertEquals(1, this._facade.getPersistenceManager().spxPackageTable().getImportedToReferencesOf(decl.getId()).size());
        this._facade.removePackageDeclaration(this.termFactory().makeString("c:/temp/test1.spx"), pQnameAppl1);
        this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        decl = this._facade.lookupPackageDecl(pQnameAppl1);
        SpxSemanticIndexFacadeTest.assertEquals(1, this._facade.getPersistenceManager().spxPackageTable().getImportedToReferencesOf(decl.getId()).size());
    }

    public void testIndexModuleDeclaration() throws IllegalArgumentException, SpxSymbolTableException, IOException {
        ITermFactory f = this.termFactory();
        String moduleName = "m1";
        IStrategoAppl pQnameAppl = (IStrategoAppl)f.parseFromString("Package(QName([\"languages\", \"entitylang\"]))");
        IStrategoAppl mQnameAppl = (IStrategoAppl)f.parseFromString("Module(QName([\"languages\", \"entitylang\" , \"" + moduleName + "\"]))");
        IStrategoAppl ast = (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, moduleName);
        IStrategoAppl analyzed_ast = (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, moduleName);
        this._facade.indexPackageDeclaration(pQnameAppl, f.makeString("c:/temp/test1.spx"));
        this._facade.indexModuleDefinition(mQnameAppl, f.makeString("c:/temp/test1.spx"), pQnameAppl, ast, analyzed_ast);
        IStrategoAppl moduleDeclaration = (IStrategoAppl)this._facade.getModuleDeclaration(mQnameAppl);
        this._facade.verifyConstructor(moduleDeclaration.getConstructor(), this._facade.getCons().getModuleDeclCon(), "Wrong Module Declaration Constructs");
    }

    public void testIndexPackageDeclaration() throws SpxSymbolTableException {
        ITermFactory f = this.termFactory();
        String moduleName = "m1";
        IStrategoAppl pQnameAppl = (IStrategoAppl)f.parseFromString("Package(QName([\"languages\", \"entitylang\"]))");
        IStrategoAppl mQnameAppl = (IStrategoAppl)f.parseFromString("Module(QName([\"languages\", \"entitylang\" , \"" + moduleName + "\"]))");
        IStrategoAppl ast = (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, moduleName);
        IStrategoAppl analyzed_ast = (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, moduleName);
        this._facade.indexPackageDeclaration(pQnameAppl, f.makeString("c:/temp/test1.spx"));
        IStrategoAppl packageDeclaration = (IStrategoAppl)this._facade.getPackageDeclaration(pQnameAppl);
        this._facade.verifyConstructor(packageDeclaration.getConstructor(), this._facade.getCons().getPackageDeclCon(), "Wrong Package Declaration");
    }

    public void testIndexPackageDeclarationInMultipleFiles() throws SpxSymbolTableException {
        ITermFactory f = this.termFactory();
        String moduleName = "m1";
        IStrategoAppl pQnameAppl = (IStrategoAppl)f.parseFromString("Package(QName([\"languages\", \"entitylang\"]))");
        IStrategoAppl mQnameAppl = (IStrategoAppl)f.parseFromString("Module(QName([\"languages\", \"entitylang\" , \"" + moduleName + "\"]))");
        IStrategoAppl ast = (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, moduleName);
        IStrategoAppl analyzed_ast = (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, moduleName);
        this._facade.indexPackageDeclaration(pQnameAppl, f.makeString("c:/temp/test1.spx"));
        this._facade.indexPackageDeclaration(pQnameAppl, f.makeString("c:/temp/test2.spx"));
        IStrategoAppl packageDeclaration = (IStrategoAppl)this._facade.getPackageDeclaration(pQnameAppl);
        this._facade.verifyConstructor(packageDeclaration.getConstructor(), this._facade.getCons().getPackageDeclCon(), "Wrong Package Declaration");
        SpxSemanticIndexFacadeTest.assertEquals(2, ((IStrategoList)packageDeclaration.getSubterm(1)).getAllSubterms().length);
    }

    public void testIndexremovePackageDeclaredinMultipleFiles() throws SpxSymbolTableException, IOException {
        ITermFactory f = this.termFactory();
        String moduleName = "m1";
        IStrategoAppl pQnameAppl = (IStrategoAppl)f.parseFromString("Package(QName([\"languages\", \"entitylang\"]))");
        IStrategoAppl mQnameAppl = (IStrategoAppl)f.parseFromString("Module(QName([\"languages\", \"entitylang\" , \"" + moduleName + "\"]))");
        IStrategoAppl ast = (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, moduleName);
        IStrategoAppl analyzed_ast = (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, moduleName);
        this._facade.indexPackageDeclaration(pQnameAppl, f.makeString("c:/temp/test1.spx"));
        this._facade.indexPackageDeclaration(pQnameAppl, f.makeString("c:/temp/test2.spx"));
        this._facade.indexModuleDefinition(mQnameAppl, f.makeString("c:/temp/test2.spx"), pQnameAppl, ast, analyzed_ast);
        IStrategoAppl packageDeclaration = (IStrategoAppl)this._facade.getPackageDeclaration(pQnameAppl);
        this._facade.verifyConstructor(packageDeclaration.getConstructor(), this._facade.getCons().getPackageDeclCon(), "Wrong Package Declaration");
        SpxSemanticIndexFacadeTest.assertEquals(2, ((IStrategoList)packageDeclaration.getSubterm(1)).getAllSubterms().length);
        this._facade.removePackageDeclaration(f.makeString("c:/temp/test1.spx"), pQnameAppl);
        packageDeclaration = (IStrategoAppl)this._facade.getPackageDeclaration(pQnameAppl);
        SpxSemanticIndexFacadeTest.assertEquals(1, ((IStrategoList)packageDeclaration.getSubterm(1)).getAllSubterms().length);
        this._facade.removePackageDeclaration(f.makeString("c:/temp/test2.spx"), pQnameAppl);
        try {
            this._facade.getPackageDeclaration(pQnameAppl);
        }
        catch (SpxSymbolTableException spxSymbolTableException) {
            // empty catch block
        }
        try {
            this._facade.getModuleDeclaration(mQnameAppl);
        }
        catch (SpxSymbolTableException spxSymbolTableException) {
            // empty catch block
        }
    }

    public void indexCompilationUnit() throws IOException {
        ITermFactory f = this.termFactory();
        this._facade.indexCompilationUnit(f.makeString("c:/temp/test1.spx"), (IStrategoAppl)SpxSemanticIndexFacadeTest.getCompilationUnit(f));
        this._facade.indexCompilationUnit(f.makeString("c:/temp/test2.spx"), (IStrategoAppl)SpxSemanticIndexFacadeTest.getCompilationUnit(f));
    }

    static IStrategoTerm getCompilationUnit(ITermFactory f) {
        String text = "CompilationUnit([], [ Package(      QName([\"languages\", \"entitylang\"])    , [ Module(          None()         , SPXModuleName(\"Entitylang-Descriptor\")        , [          ]        )      ]    )  ])";
        return f.parseFromString(text);
    }

    public void testUnknownPackageNameThrowsIllegalArgumentException() throws IOException {
        ITermFactory f = this.termFactory();
        String moduleName = "m1";
        IStrategoAppl pQnameAppl = (IStrategoAppl)f.parseFromString("Package(QName([\"languages\", \"entitylang\"]))");
        IStrategoAppl mQnameAppl = (IStrategoAppl)f.parseFromString("Module(QName([\"languages\", \"entitylang\" , \"" + moduleName + "\"]))");
        IStrategoAppl ast = (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(f, moduleName);
        IStrategoAppl analyzed_ast = (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(f, moduleName);
        try {
            this._facade.indexModuleDefinition(mQnameAppl, f.makeString("c:/temp/test1.spx"), pQnameAppl, ast, analyzed_ast);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private IStrategoAppl indexTestModuleDefs(String moduleName, String packageQName, String filePath) throws IOException {
        String moduleQName = String.valueOf(packageQName) + ", \"" + moduleName + "\"";
        IStrategoAppl pQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Package(QName([" + packageQName + "]))");
        IStrategoAppl mQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Module(QName([" + moduleQName + "]))");
        IStrategoAppl ast = (IStrategoAppl)SpxLookupTableUnitTests.getModuleDefinition(this.termFactory(), moduleName);
        IStrategoAppl analyzed_ast = (IStrategoAppl)SpxLookupTableUnitTests.getAnalyzedModuleDefinition(this.termFactory(), moduleName);
        this._facade.indexModuleDefinition(mQnameAppl, this.termFactory().makeString(filePath), pQnameAppl, ast, analyzed_ast);
        return mQnameAppl;
    }

    private IStrategoAppl indexTestPackageDecl(String packageName, String fileName) {
        IStrategoAppl pQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Package(QName([" + packageName + "]))");
        this._facade.indexPackageDeclaration(pQnameAppl, this.termFactory().makeString(fileName));
        return pQnameAppl;
    }
}

