/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language.spxlang.index.tests;

import java.io.IOException;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.LanguageLibrary;
import org.spoofax.interpreter.library.language.spxlang.index.SpxSemanticIndexFacade;
import org.spoofax.interpreter.library.language.spxlang.index.data.SpxSymbolTableEntry;
import org.spoofax.interpreter.library.language.spxlang.index.tests.SpxIndexBaseTestCase;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class SpxSymbolTableEntryTests
extends SpxIndexBaseTestCase {
    private final String _projectName = "test-sybol-table";
    private IStrategoString projectNameTerm;
    private SpxSemanticIndexFacade _facade;
    final String absPathString1 = "c:/temp/test1.spx";
    final String absPathString2 = "c:/temp/test2.spx";

    private Interpreter interpreter() {
        return this.itp;
    }

    private IOAgent ioAgent() {
        return this.itp.getIOAgent();
    }

    private ITermFactory termFactory() {
        return this.factory;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.interpreter().addOperatorRegistry(new LanguageLibrary());
        this.projectNameTerm = this.termFactory().makeString("test-sybol-table");
        this._facade = new SpxSemanticIndexFacade(this.projectNameTerm, this.termFactory(), this.ioAgent());
        this._facade.cleanIndexAndSymbolTable();
    }

    public void testSpoofaxSymbolTableEntryBuilder() throws IOException {
        String packageName1 = "\"languages\", \"entitylang\"";
        IStrategoAppl data = this.indexTestPackageDecl(packageName1, "c:/temp/test1.spx");
        IStrategoTerm id = this.termFactory().parseFromString(packageName1);
        SpxSymbolTableEntry entry = SpxSymbolTableEntry.newEntry().with(id).instanceOf(this._facade.getCons().getGlobalNamespaceTypeCon()).uses(this._facade.getTermAttachmentSerializer()).data(data).build();
        SpxSymbolTableEntryTests.assertTrue(entry.value != null);
        SpxSymbolTableEntryTests.assertTrue(entry.value.namespaceUri() == null);
        SpxSymbolTableEntryTests.assertEquals(this._facade.getCons().getGlobalNamespaceTypeCon().getName(), entry.value.getSignatureString());
        SpxSymbolTableEntryTests.assertEquals(this._facade.getCons().getGlobalNamespaceTypeCon(), entry.value.typeCons(this._facade));
        SpxSymbolTableEntryTests.assertTrue(entry.key != null);
    }

    private IStrategoAppl indexTestPackageDecl(String packageName, String fileName) {
        IStrategoAppl pQnameAppl = (IStrategoAppl)this.termFactory().parseFromString("Package(QName([" + packageName + "]))");
        return pQnameAppl;
    }
}

