/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.xml.StrategoTermBuilder;
import org.spoofax.interpreter.library.xml.XMLAbstractPrimitive;
import org.spoofax.interpreter.library.xml.XMLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XML_parse_base
extends XMLAbstractPrimitive {
    public XML_parse_base(XMLLibrary library, String name) {
        super(library, name, 0, 1);
    }

    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        if (tvars[0].getTermType() != 5) {
            return false;
        }
        this.library.clearErrors();
        String input = ((IStrategoString)tvars[0]).stringValue();
        InputStream in = this.makeInputStream(env, input);
        if (in == null) {
            return false;
        }
        IStrategoTerm result = this.parse(env, in);
        if (result == null) {
            return false;
        }
        env.setCurrent(result);
        return true;
    }

    protected abstract InputStream makeInputStream(IContext var1, String var2);

    protected IStrategoTerm parse(IContext env, InputStream in) {
        SAXParser parser = this.library.obtainParser();
        if (parser == null) {
            return null;
        }
        StrategoTermBuilder builder = new StrategoTermBuilder(env.getFactory(), this.library);
        IStrategoTerm result = null;
        try {
            parser.getXMLReader().setErrorHandler(builder);
            parser.parse(in, (DefaultHandler)builder);
            result = builder.getRootElement();
        }
        catch (SAXException e) {
            this.library.setLastException(e);
        }
        catch (IOException e) {
            this.library.setLastException(e);
        }
        this.library.setLastErrors(builder.getErrors());
        return result;
    }
}

