/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.IOException;
import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.IndentationHandler;
import org.spoofax.jsglr.client.ParseException;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.shared.ArrayDeque;

public class IndentTokenizer {
    private static final char INDENT_TOK = '\u00f4';
    private static final char DEDENT_TOK = '\u00f5';
    private final ArrayDeque<Integer> indentStack = new ArrayDeque();
    private final boolean strictMode;
    private final IndentationHandler myIndentHandler;
    private int dedentCount;
    private boolean indentShift;

    public IndentTokenizer(IndentationHandler indentInfo, boolean isStrictMode) {
        this.strictMode = isStrictMode;
        this.myIndentHandler = indentInfo;
        this.initEvaluationVariables();
    }

    private void initEvaluationVariables() {
        this.myIndentHandler.initEvaluationVariables();
        this.indentStack.clear();
        this.indentStack.push(0);
        this.resetForNextLine();
    }

    private void resetForNextLine() {
        this.indentShift = false;
        this.dedentCount = 0;
    }

    private void updateIndentFields() {
        int diff = this.myIndentHandler.getIndentValue() - this.indentStack.peek();
        while (diff < 0) {
            this.indentStack.pop();
            ++this.dedentCount;
            diff = this.myIndentHandler.getIndentValue() - this.indentStack.peek();
        }
        if (diff > 0) {
            this.indentStack.push(diff);
            this.indentShift = true;
        }
    }

    public void handleIndentShifts(SGLR parser) throws IOException, ParseException {
        int curTok = parser.getCurrentToken();
        if (this.myIndentHandler.lineMarginEnded()) {
            this.updateIndentFields();
            this.parseIndentation(parser);
            this.resetForNextLine();
            parser.setCurrentToken(curTok);
        }
    }

    private void parseIndentation(SGLR parser) throws ParseException, IOException {
        ArrayDeque<Frame> oldActiveStacks = parser.activeStacks;
        if (this.dedentCount > 0 && this.indentShift && this.strictMode) {
            throw new ParseException(parser, "Indentation inconsistent");
        }
        int i = 0;
        while (i < this.dedentCount) {
            parser.setCurrentToken(245);
            parser.doParseStep();
            ++i;
        }
        if (this.indentShift) {
            parser.setCurrentToken(244);
            parser.doParseStep();
        }
        if (parser.activeStacks.size() == 0) {
            parser.activeStacks.addAll(oldActiveStacks);
        }
    }
}

