/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

public class IndentationHandler {
    private boolean isInLeftMargin;
    private int indentValue;
    private boolean lineMarginFound;
    private boolean emptyLineFound;

    public void setInLeftMargin(boolean isInLeftMargin) {
        this.isInLeftMargin = isInLeftMargin;
    }

    public boolean isInLeftMargin() {
        return this.isInLeftMargin;
    }

    public int getIndentValue() {
        return this.indentValue;
    }

    public void setIndentValue(int startIndent) {
        this.indentValue = startIndent;
    }

    public boolean emptyLineParsed() {
        return this.emptyLineFound;
    }

    public boolean lineMarginEnded() {
        return this.lineMarginFound;
    }

    public IndentationHandler() {
        this.initEvaluationVariables();
    }

    void initEvaluationVariables() {
        this.indentValue = 0;
        this.setInLeftMargin(true);
        this.lineMarginFound = false;
        this.emptyLineFound = false;
    }

    public void updateIndentation(int curTok) {
        boolean oldLeftMargin = this.isInLeftMargin();
        this.updateLeftMargeFields(curTok);
        this.lineMarginFound = oldLeftMargin && !this.isInLeftMargin();
        this.emptyLineFound = oldLeftMargin && curTok == 10;
    }

    private void updateLeftMargeFields(int charValue) {
        switch (charValue) {
            case 10: {
                this.indentValue = 0;
                this.setInLeftMargin(true);
                break;
            }
            case 32: {
                if (!this.isInLeftMargin()) break;
                ++this.indentValue;
                break;
            }
            case 9: {
                if (!this.isInLeftMargin()) break;
                this.indentValue += 4;
                break;
            }
            case 256: {
                break;
            }
            default: {
                this.setInLeftMargin(false);
            }
        }
    }
}

