/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.Serializable;
import java.util.Arrays;

public class RangeList
implements Serializable {
    private static final long serialVersionUID = 16593569L;
    public static final int NONE = -1;
    private final int[] ranges;
    private final int singularRange;

    public RangeList(int[] ranges) {
        if (ranges.length == 1) {
            this.ranges = null;
            this.singularRange = ranges[0];
        } else {
            this.ranges = ranges;
            this.singularRange = -1;
        }
    }

    public final boolean within(int c) {
        if (this.singularRange != -1) {
            return c == this.singularRange;
        }
        int i = 0;
        while (i < this.ranges.length) {
            int low = this.ranges[i];
            if (low <= c) {
                int high = this.ranges[i + 1];
                if (c <= high) {
                    return true;
                }
            } else {
                return false;
            }
            i += 2;
        }
        return false;
    }

    public int getSingularRange() {
        return this.singularRange;
    }

    public int getFirstRangeElement() {
        return this.singularRange == -1 ? this.ranges[0] : this.singularRange;
    }

    public int getLastRangeElement() {
        return this.singularRange == -1 ? this.ranges[this.ranges.length - 1] : this.singularRange;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangeList)) {
            return false;
        }
        if (this.singularRange == -1) {
            return Arrays.equals(((RangeList)obj).ranges, this.ranges);
        }
        return this.singularRange == ((RangeList)obj).singularRange;
    }

    public int hashCode() {
        return this.singularRange == -1 ? Arrays.hashCode(this.ranges) : this.singularRange;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.singularRange != -1) {
            sb.append(this.singularRange);
        } else {
            sb.append('[');
            int i = 0;
            int end = this.ranges.length - 1;
            while (i < end) {
                int low = this.ranges[i];
                int high = this.ranges[i + 1];
                sb.append(low);
                if (low != high) {
                    sb.append('-');
                    sb.append(high);
                }
                sb.append(',');
                ++i;
            }
            sb.replace(sb.length() - 1, sb.length(), "]");
        }
        return sb.toString();
    }
}

