/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.spoofax.PushbackStringIterator;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.Action;
import org.spoofax.jsglr.client.ActionItem;
import org.spoofax.jsglr.client.ActionState;
import org.spoofax.jsglr.client.AmbiguityManager;
import org.spoofax.jsglr.client.Asfix2TreeBuilder;
import org.spoofax.jsglr.client.Disambiguator;
import org.spoofax.jsglr.client.FineGrainedSetting;
import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.ITreeBuilder;
import org.spoofax.jsglr.client.IntegratedRecoverySettings;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.Measures;
import org.spoofax.jsglr.client.MultiBadTokenException;
import org.spoofax.jsglr.client.NullTreeBuilder;
import org.spoofax.jsglr.client.ParseException;
import org.spoofax.jsglr.client.ParseNode;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.ParseTimeoutException;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.Path;
import org.spoofax.jsglr.client.PathListPool;
import org.spoofax.jsglr.client.PooledPathList;
import org.spoofax.jsglr.client.Production;
import org.spoofax.jsglr.client.RangeList;
import org.spoofax.jsglr.client.RecoveryConnector;
import org.spoofax.jsglr.client.RecoveryPerformance;
import org.spoofax.jsglr.client.Reduce;
import org.spoofax.jsglr.client.ReduceLookahead;
import org.spoofax.jsglr.client.Shift;
import org.spoofax.jsglr.client.State;
import org.spoofax.jsglr.client.TaskCancellationException;
import org.spoofax.jsglr.shared.ArrayDeque;
import org.spoofax.jsglr.shared.BadTokenException;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.TokenExpectedException;
import org.spoofax.jsglr.shared.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGLR {
    private static final int COMPLETION_REGION_SIZE = 1000;
    private RecoveryPerformance performanceMeasuring;
    private final Set<BadTokenException> collectedErrors = new LinkedHashSet<BadTokenException>();
    public static final int EOF = 256;
    static final int TAB_SIZE = 4;
    protected static boolean WORK_AROUND_MULTIPLE_LOOKAHEAD;
    private static long parseTime;
    private static int parseCount;
    protected Frame startFrame;
    private long startTime;
    protected volatile boolean asyncAborted;
    protected Frame acceptingStack;
    protected final ArrayDeque<Frame> activeStacks;
    private ParseTable parseTable;
    private int currentToken;
    private int tokensSeen;
    protected int lineNumber;
    protected int columnNumber;
    private int startOffset;
    private final ArrayDeque<ActionState> forShifter;
    private ArrayDeque<Frame> forActor;
    private ArrayDeque<Frame> forActorDelayed;
    private int maxBranches;
    private int maxToken;
    private int maxLine;
    private int maxColumn;
    private int maxTokenNumber;
    private AmbiguityManager ambiguityManager;
    protected Disambiguator disambiguator;
    private int rejectCount;
    private int reductionCount;
    protected PushbackStringIterator currentInputStream;
    private PathListPool pathCache = PathListPool.getInstance();
    private ArrayDeque<Frame> activeStacksWorkQueue = new ArrayDeque();
    private ArrayDeque<Frame> recoverStacks;
    private ParserHistory history;
    private RecoveryConnector recoverIntegrator;
    private ITreeBuilder treeBuilder;
    protected boolean useIntegratedRecovery;
    private boolean isCompletionMode;
    private boolean isFineGrainedMode;
    private int fineGrainedStartLocation;
    private int fineGrainedRecoverMax;
    private int cursorLocation;
    private static int traceCallCount;

    static {
        parseTime = 0L;
        parseCount = 0;
        traceCallCount = 0;
    }

    public void setUseStructureRecovery(boolean useRecovery) {
        this.useIntegratedRecovery = useRecovery;
        this.recoverIntegrator = new RecoveryConnector(this);
    }

    public void setUseStructureRecovery(boolean useRecovery, IntegratedRecoverySettings settings, FineGrainedSetting fgSettings) {
        this.useIntegratedRecovery = useRecovery;
        this.recoverIntegrator = new RecoveryConnector(this, settings, fgSettings);
    }

    public ParserHistory getHistory() {
        return this.history;
    }

    public int getParserLocation() {
        return this.getHistory().getTokenIndex();
    }

    public int getCursorLocation() {
        return this.cursorLocation;
    }

    public boolean isSetCursorLocation() {
        return this.cursorLocation > 0 && this.cursorLocation != Integer.MAX_VALUE;
    }

    private void setCompletionParse(boolean isCompletionMode, int cursorLocation) {
        this.isCompletionMode = isCompletionMode;
        this.cursorLocation = cursorLocation;
    }

    protected ArrayDeque<Frame> getRecoverStacks() {
        return this.recoverStacks;
    }

    public Set<BadTokenException> getCollectedErrors() {
        return this.collectedErrors;
    }

    public void setTimeout(int timeout) {
        throw new UnsupportedOperationException("Use org.spoofax.jsglr.io.SGLR for setting a timeout");
    }

    protected void initParseTimer() {
    }

    @Deprecated
    public SGLR(ITermFactory pf, ParseTable parseTable) {
        this(new Asfix2TreeBuilder(pf), parseTable);
    }

    @Deprecated
    public SGLR(ParseTable parseTable) {
        this(new Asfix2TreeBuilder(), parseTable);
    }

    public SGLR(ITreeBuilder treeBuilder, ParseTable parseTable) {
        assert (parseTable != null);
        this.parseTable = parseTable;
        this.activeStacks = new ArrayDeque();
        this.forActor = new ArrayDeque();
        this.forActorDelayed = new ArrayDeque();
        this.forShifter = new ArrayDeque();
        this.disambiguator = new Disambiguator();
        this.useIntegratedRecovery = false;
        this.setUseStructureRecovery(false);
        this.history = new ParserHistory();
        this.setCompletionParse(false, Integer.MAX_VALUE);
        this.setTreeBuilder(treeBuilder);
    }

    protected void setFinegrainedRecoverMode(boolean fineGrainedMode) {
        this.isFineGrainedMode = fineGrainedMode;
        this.recoverStacks = new ArrayDeque();
    }

    protected void setFineGrainedStartLocation(int fineGrainedStartLocation) {
        this.fineGrainedStartLocation = fineGrainedStartLocation;
    }

    protected void setFineGrainedRecoverMax(int fineGrainedRecoverMax) {
        this.fineGrainedRecoverMax = fineGrainedRecoverMax;
    }

    public RecoveryPerformance getPerformanceMeasuring() {
        return this.performanceMeasuring;
    }

    @Deprecated
    public void asyncAbort() {
        this.asyncCancel();
    }

    public void asyncCancel() {
        this.asyncAborted = true;
    }

    public void asyncCancelReset() {
        this.asyncAborted = false;
    }

    @Deprecated
    public static boolean isDebugging() {
        return false;
    }

    public static boolean isLogging() {
        return Tools.logging;
    }

    private Frame initActiveStacks() {
        this.activeStacks.clear();
        Frame st0 = this.newStack(this.parseTable.getInitialState());
        this.addStack(st0);
        return st0;
    }

    @Deprecated
    public Object parse(String input) throws BadTokenException, TokenExpectedException, ParseException, SGLRException {
        return this.parse(input, null, null);
    }

    @Deprecated
    public final Object parse(String input, String filename) throws BadTokenException, TokenExpectedException, ParseException, SGLRException {
        return this.parse(input, filename, null);
    }

    public Object parse(String input, String filename, String startSymbol, boolean completionMode, int cursorLocation) throws BadTokenException, TokenExpectedException, ParseException, SGLRException {
        this.setCompletionParse(completionMode, cursorLocation);
        Object parseResult = this.parse(input, filename, startSymbol);
        this.setCompletionParse(false, Integer.MAX_VALUE);
        return parseResult;
    }

    public Object parse(String input, String filename, String startSymbol) throws BadTokenException, TokenExpectedException, ParseException, SGLRException {
        this.logBeforeParsing();
        this.initParseVariables(input, filename);
        this.startTime = System.currentTimeMillis();
        this.initParseTimer();
        this.getPerformanceMeasuring().startParse();
        Object result = this.sglrParse(startSymbol);
        return result;
    }

    private Object sglrParse(String startSymbol) throws BadTokenException, TokenExpectedException, ParseException, SGLRException {
        try {
            do {
                this.readNextToken();
                this.history.keepTokenAndState(this);
                this.doParseStep();
            } while (this.getCurrentToken() != 256 && this.activeStacks.size() > 0);
            if (this.acceptingStack == null) {
                this.collectedErrors.add(this.createBadTokenException());
            }
            if (this.useIntegratedRecovery && this.acceptingStack == null) {
                this.recoverIntegrator.recover();
                if (this.acceptingStack == null && this.activeStacks.size() > 0) {
                    Object object = this.sglrParse(startSymbol);
                    return object;
                }
            }
            try {
                this.getPerformanceMeasuring().endParse(this.acceptingStack != null);
            }
            catch (TaskCancellationException e) {
                throw new ParseTimeoutException(this, this.getCurrentToken(), this.tokensSeen - 1, this.lineNumber, this.columnNumber, this.collectedErrors);
            }
        }
        finally {
            this.activeStacks.clear();
            this.activeStacksWorkQueue.clear();
            this.forShifter.clear();
            this.history.clear();
            if (this.recoverStacks != null) {
                this.recoverStacks.clear();
            }
        }
        this.logAfterParsing();
        Link s = this.acceptingStack.findDirectLink(this.startFrame);
        if (s == null) {
            throw new ParseException(this, "Accepting stack has no link");
        }
        assert (s.recoverCount <= s.recoverWeight);
        this.performanceMeasuring.setRecoverCount(s.recoverCount);
        this.logParseResult(s);
        Tools.debug("recoveries: ", s.recoverCount);
        if (this.getTreeBuilder() instanceof NullTreeBuilder) {
            return null;
        }
        return this.disambiguator.applyFilters(this, s.label, startSymbol, this.tokensSeen);
    }

    void readNextToken() {
        this.logCurrentToken();
        this.setCurrentToken(this.getNextToken());
    }

    protected void doParseStep() {
        this.logBeforeParseCharacter();
        this.parseCharacter();
        this.shifter();
    }

    private void initParseVariables(String input, String filename) {
        this.forActor.clear();
        this.forActorDelayed.clear();
        this.forShifter.clear();
        this.history.clear();
        this.startFrame = this.initActiveStacks();
        this.tokensSeen = 0;
        this.currentInputStream = new PushbackStringIterator(input);
        this.acceptingStack = null;
        this.collectedErrors.clear();
        this.history = new ParserHistory();
        this.performanceMeasuring = new RecoveryPerformance();
        this.getTreeBuilder().initializeInput(input, filename);
        PooledPathList.resetPerformanceCounters();
        PathListPool.resetPerformanceCounters();
        this.ambiguityManager = new AmbiguityManager(input.length());
        if (this.getTreeBuilder().getTokenizer() != null) {
            this.lineNumber = this.getTreeBuilder().getTokenizer().getEndLine();
            this.columnNumber = this.getTreeBuilder().getTokenizer().getEndColumn();
            this.startOffset = this.getTreeBuilder().getTokenizer().getStartOffset();
        } else {
            this.lineNumber = 1;
            this.columnNumber = 0;
        }
    }

    private BadTokenException createBadTokenException() {
        Action action;
        Frame singlePreviousStack;
        Frame frame = singlePreviousStack = this.activeStacks.size() == 1 ? this.activeStacks.get(0) : null;
        if (singlePreviousStack != null && (action = singlePreviousStack.peek().getSingularAction()) != null && action.getActionItems().length == 1) {
            int token;
            StringBuilder expected = new StringBuilder();
            while ((token = action.getSingularRange()) != -1) {
                expected.append((char)token);
                ActionItem[] items = action.getActionItems();
                if (items.length != 1 || items[0].type != 2) break;
                Shift shift = (Shift)items[0];
                action = this.parseTable.getState(shift.nextState).getSingularAction();
                if (action != null) continue;
            }
            if (expected.length() > 0) {
                return new TokenExpectedException(this, expected.toString(), this.getCurrentToken(), this.tokensSeen + this.startOffset - 1, this.lineNumber, this.columnNumber);
            }
        }
        return new BadTokenException(this, this.getCurrentToken(), this.tokensSeen + this.startOffset - 1, this.lineNumber, this.columnNumber);
    }

    private void shifter() {
        this.logBeforeShifter();
        this.activeStacks.clear();
        AbstractParseNode prod = this.parseTable.lookupProduction(this.getCurrentToken());
        while (this.forShifter.size() > 0) {
            ActionState as = this.forShifter.remove();
            if (!this.parseTable.hasRejects() || !as.st.allLinksRejected()) {
                Frame st1 = this.findStack(this.activeStacks, as.s);
                if (st1 == null) {
                    st1 = this.newStack(as.s);
                    this.addStack(st1);
                }
                st1.addLink(as.st, prod, 1);
                continue;
            }
            if (!Tools.logging) continue;
            Tools.logger("Shifter: skipping rejected stack with state ", as.st.state.stateNumber);
        }
        this.logAfterShifter();
    }

    protected void addStack(Frame st1) {
        this.activeStacks.addFirst(st1);
    }

    private void parseCharacter() {
        this.logBeforeParseCharacter();
        this.activeStacksWorkQueue.clear();
        this.activeStacksWorkQueue.addAll(this.activeStacks);
        this.forActorDelayed.clear();
        this.forShifter.clear();
        while (this.activeStacksWorkQueue.size() > 0 || this.forActor.size() > 0) {
            Frame st = this.pickStackNodeFromActivesOrForActor(this.activeStacksWorkQueue);
            if (!st.allLinksRejected()) {
                this.actor(st);
            }
            if (this.activeStacksWorkQueue.size() != 0 || this.forActor.size() != 0) continue;
            this.fillForActorWithDelayedFrames();
        }
    }

    private void fillForActorWithDelayedFrames() {
        ArrayDeque<Frame> empty = this.forActor;
        this.forActor = this.forActorDelayed;
        empty.clear();
        this.forActorDelayed = empty;
    }

    private Frame pickStackNodeFromActivesOrForActor(ArrayDeque<Frame> actives) {
        Frame st = actives.size() > 0 ? actives.remove() : this.forActor.remove();
        return st;
    }

    private void actor(Frame st) {
        State s = st.peek();
        this.logBeforeActor(st, s);
        Action[] actionArray = s.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            if (action.accepts(this.getCurrentToken())) {
                ActionItem[] actionItemArray = action.getActionItems();
                int n3 = actionItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ActionItem ai = actionItemArray[n4];
                    switch (ai.type) {
                        case 2: {
                            Shift sh = (Shift)ai;
                            ActionState actState = new ActionState(st, this.parseTable.getState(sh.nextState));
                            actState.currentToken = this.getCurrentToken();
                            this.addShiftPair(actState);
                            this.statsRecordParsers();
                            break;
                        }
                        case 1: {
                            ActionItem red = (Reduce)ai;
                            this.doReductions(st, red.production);
                            break;
                        }
                        case 4: {
                            ActionItem red = (ReduceLookahead)ai;
                            if (!this.checkLookahead((ReduceLookahead)red)) break;
                            this.doReductions(st, ((ReduceLookahead)red).production);
                            break;
                        }
                        case 3: {
                            if (st.allLinksRejected()) break;
                            this.acceptingStack = st;
                            if (!Tools.logging) break;
                            Tools.logger("Reached the accept state");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown action type: " + ai.type);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private boolean checkLookahead(ReduceLookahead red) {
        return this.doCheckLookahead(red, red.getCharRanges(), 0);
    }

    private boolean doCheckLookahead(ReduceLookahead red, RangeList[] charClass, int pos) {
        int c = this.currentInputStream.read();
        if (c == -1) {
            return true;
        }
        boolean permit = true;
        if (pos < charClass.length) {
            permit = charClass[pos].within(c) ? false : this.doCheckLookahead(red, charClass, pos + 1);
        }
        this.currentInputStream.unread(c);
        return permit;
    }

    private void addShiftPair(ActionState state) {
        this.forShifter.add(state);
    }

    private void statsRecordParsers() {
        if (this.forShifter.size() > this.maxBranches) {
            this.maxBranches = this.forShifter.size();
            this.maxToken = this.getCurrentToken();
            this.maxColumn = this.columnNumber;
            this.maxLine = this.lineNumber;
            this.maxTokenNumber = this.tokensSeen;
        }
    }

    private void doReductions(Frame st, Production prod) {
        if (!this.recoverModeOk(st, prod)) {
            return;
        }
        PooledPathList paths = this.pathCache.create();
        try {
            st.findAllPaths(paths, prod.arity);
            this.logBeforeDoReductions(st, prod, paths.size());
            this.reduceAllPaths(prod, paths);
            this.logAfterDoReductions();
        }
        finally {
            this.pathCache.endCreate(paths);
        }
    }

    private boolean recoverModeOk(Frame st, Production prod) {
        if (!prod.isCompletionProduction()) {
            return !prod.isRecoverProduction() || this.isFineGrainedMode;
        }
        return this.inCompletionMode(prod);
    }

    private boolean inCompletionMode(Production prod) {
        if (!prod.isCompletionStartProduction()) {
            return this.isCompletionMode && this.cursorLocation <= this.getParserLocation() && this.getParserLocation() <= this.cursorLocation + 1000;
        }
        return this.isCompletionMode && this.cursorLocation - 1000 <= this.getParserLocation() && this.getParserLocation() <= this.cursorLocation;
    }

    private void doLimitedReductions(Frame st, Production prod, Link l) {
        if (!this.recoverModeOk(st, prod)) {
            return;
        }
        PooledPathList limitedPool = this.pathCache.create();
        try {
            st.findLimitedPaths(limitedPool, prod.arity, l);
            this.logBeforeLimitedReductions(st, prod, l, limitedPool);
            this.reduceAllPaths(prod, limitedPool);
        }
        finally {
            this.pathCache.endCreate(limitedPool);
        }
    }

    private void reduceAllPaths(Production prod, PooledPathList paths) {
        int i = 0;
        while (i < paths.size()) {
            Path path = paths.get(i);
            AbstractParseNode[] kids = path.getParseNodes();
            Frame st0 = path.getEnd();
            State next = this.parseTable.go(st0.state, prod.label);
            this.logReductionPath(prod, path, st0, next);
            if ((!prod.isCompletionProduction() || this.isReductionOverCursorLocation(path)) && this.checkMaxRecoverCount(prod, path)) {
                if (!prod.isRecoverProduction()) {
                    this.reducer(st0, next, prod, kids, path);
                } else {
                    this.reducerRecoverProduction(st0, next, prod, kids, path);
                }
            }
            ++i;
        }
        if (this.asyncAborted) {
            throw new TaskCancellationException("Long-running parse job aborted");
        }
    }

    private boolean checkMaxRecoverCount(Production prod, Path path) {
        return this.checkRecoverCountLocal(prod, path) && this.checkRecoverCountGlobal(prod, path);
    }

    private boolean checkRecoverCountLocal(Production prod, Path path) {
        return !this.isFineGrainedMode || this.calcRecoverCount(prod, path) <= this.fineGrainedRecoverMax || this.getHistory().getTokenIndex() - path.getLength() < this.fineGrainedStartLocation;
    }

    private boolean checkRecoverCountGlobal(Production prod, Path path) {
        return this.calcRecoverCount(prod, path) <= this.recoverIntegrator.getMaxNumberOfRecoverApplicationsGlobal();
    }

    private boolean isReductionOverCursorLocation(Path path) {
        return this.getParserLocation() - path.getLength() < this.cursorLocation;
    }

    private void reducer(Frame st0, State s, Production prod, AbstractParseNode[] kids, Path path) {
        assert (!prod.isRecoverProduction());
        this.logBeforeReducer(s, prod, path.getLength());
        this.increaseReductionCount();
        int length = path.getLength();
        int numberOfRecoveries = this.calcRecoverCount(prod, path);
        int recoverWeight = this.calcRecoverWeight(prod, path);
        AbstractParseNode t = prod.apply(kids);
        Frame st1 = this.findStack(this.activeStacks, s);
        if (st1 == null) {
            this.addNewStack(st0, s, prod, length, numberOfRecoveries, recoverWeight, t);
        } else {
            Link nl = st1.findDirectLink(st0);
            if (nl != null) {
                this.logAmbiguity(st0, prod, st1, nl);
                if (prod.isRejectProduction()) {
                    nl.reject();
                }
                if (recoverWeight == 0 && nl.recoverWeight == 0 || nl.isRejected()) {
                    this.createAmbNode(t, nl);
                } else if (recoverWeight < nl.recoverWeight) {
                    nl.label = t;
                    nl.recoverCount = numberOfRecoveries;
                    nl.recoverWeight = recoverWeight;
                    this.actorOnActiveStacksOverNewLink(nl);
                } else if (recoverWeight == nl.recoverWeight) {
                    nl.label = t;
                }
            } else {
                nl = st1.addLink(st0, t, length);
                nl.recoverWeight = recoverWeight;
                nl.recoverCount = numberOfRecoveries;
                if (prod.isRejectProduction()) {
                    nl.reject();
                    this.increaseRejectCount();
                }
                this.logAddedLink(st0, st1, nl);
                this.actorOnActiveStacksOverNewLink(nl);
            }
        }
    }

    private void reducerRecoverProduction(Frame st0, State s, Production prod, AbstractParseNode[] kids, Path path) {
        Link lnActive;
        assert (prod.isRecoverProduction());
        int length = path.getLength();
        int numberOfRecoveries = this.calcRecoverCount(prod, path);
        int recoverWeight = this.calcRecoverWeight(prod, path);
        AbstractParseNode t = prod.apply(kids);
        Frame stActive = this.findStack(this.activeStacks, s);
        if (stActive != null && (lnActive = stActive.findDirectLink(st0)) != null) {
            return;
        }
        Frame stRecover = this.findStack(this.recoverStacks, s);
        if (stRecover != null) {
            Link nlRecover = stRecover.findDirectLink(st0);
            if (nlRecover != null) {
                return;
            }
            nlRecover = stRecover.addLink(st0, t, length);
            nlRecover.recoverCount = numberOfRecoveries;
            nlRecover.recoverWeight = recoverWeight;
            return;
        }
        this.addNewRecoverStack(st0, s, prod, length, numberOfRecoveries, recoverWeight, t);
    }

    private void createAmbNode(AbstractParseNode t, Link nl) {
        nl.addAmbiguity(t, this.tokensSeen);
        this.ambiguityManager.increaseAmbiguityCalls();
    }

    private void addNewStack(Frame st0, State s, Production prod, int length, int numberOfRecoveries, int recoverWeight, AbstractParseNode t) {
        Frame st1 = this.newStack(s);
        Link nl = st1.addLink(st0, t, length);
        nl.recoverCount = numberOfRecoveries;
        nl.recoverWeight = recoverWeight;
        this.addStack(st1);
        this.forActorDelayed.addFirst(st1);
        if (prod.isRejectProduction()) {
            if (Tools.logging) {
                Tools.logger("Reject [new]");
            }
            nl.reject();
            this.increaseRejectCount();
        }
    }

    private void addNewRecoverStack(Frame st0, State s, Production prod, int length, int numberOfRecoveries, int recoverWeight, AbstractParseNode t) {
        if (!this.isFineGrainedMode || prod.isRejectProduction()) {
            return;
        }
        Frame st1 = this.newStack(s);
        Link nl = st1.addLink(st0, t, length);
        nl.recoverCount = numberOfRecoveries;
        nl.recoverWeight = recoverWeight;
        this.recoverStacks.addFirst(st1);
    }

    private void actorOnActiveStacksOverNewLink(Link nl) {
        int sz = this.activeStacks.size();
        int i = 0;
        while (i < sz) {
            int pos = this.activeStacks.size() - sz + i;
            Frame st2 = this.activeStacks.get(pos);
            if (!(st2.allLinksRejected() || this.inReduceStacks(this.forActor, st2) || this.inReduceStacks(this.forActorDelayed, st2))) {
                Action[] actionArray = st2.peek().getActions();
                int n = actionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Action action = actionArray[n2];
                    if (action.accepts(this.getCurrentToken())) {
                        ActionItem[] actionItemArray = action.getActionItems();
                        int n3 = actionItemArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ActionItem ai = actionItemArray[n4];
                            switch (ai.type) {
                                case 1: {
                                    Reduce red = (Reduce)ai;
                                    this.doLimitedReductions(st2, red.production, nl);
                                    break;
                                }
                                case 4: {
                                    ReduceLookahead red2 = (ReduceLookahead)ai;
                                    if (!this.checkLookahead(red2)) break;
                                    this.doLimitedReductions(st2, red2.production, nl);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            ++i;
        }
    }

    private int calcRecoverCount(Production prod, Path path) {
        int result = path.getRecoverCount();
        if (prod.isRecoverProduction() || prod.isCompletionProduction()) {
            ++result;
        }
        return result;
    }

    private int calcRecoverWeight(Production prod, Path path) {
        int result = path.getRecoverWeight();
        if (prod.isRecoverProduction() || prod.isCompletionProduction()) {
            ++result;
            if (path.getLength() > 0 && !prod.isCompletionProduction()) {
                ++result;
            }
        }
        return result;
    }

    private boolean inReduceStacks(Queue<Frame> q, Frame frame) {
        return q.contains(frame);
    }

    protected Frame newStack(State s) {
        return new Frame(s);
    }

    private void increaseReductionCount() {
        ++this.reductionCount;
    }

    protected void increaseRejectCount() {
        ++this.rejectCount;
    }

    protected int getRejectCount() {
        return this.rejectCount;
    }

    Frame findStack(ArrayDeque<Frame> stacks, State s) {
        int desiredState = s.stateNumber;
        int size = stacks.size();
        int i = 0;
        while (i < size) {
            Frame stack = stacks.get(i);
            if (stack.state.stateNumber == desiredState) {
                return stack;
            }
            ++i;
        }
        return null;
    }

    private int getNextToken() {
        int ch = this.currentInputStream.read();
        this.updateLineAndColumnInfo(ch);
        if (ch == -1) {
            return 256;
        }
        return ch;
    }

    protected void updateLineAndColumnInfo(int ch) {
        ++this.tokensSeen;
        switch (ch) {
            case 10: {
                ++this.lineNumber;
                this.columnNumber = 0;
                break;
            }
            case 9: {
                this.columnNumber = (this.columnNumber / 4 + 1) * 4;
                break;
            }
            case -1: {
                break;
            }
            default: {
                ++this.columnNumber;
            }
        }
    }

    public ParseTable getParseTable() {
        return this.parseTable;
    }

    public void setTreeBuilder(ITreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
        this.parseTable.initializeTreeBuilder(treeBuilder);
    }

    public ITreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    AmbiguityManager getAmbiguityManager() {
        return this.ambiguityManager;
    }

    public Disambiguator getDisambiguator() {
        return this.disambiguator;
    }

    public void setDisambiguator(Disambiguator disambiguator) {
        this.disambiguator = disambiguator;
    }

    @Deprecated
    public ITermFactory getFactory() {
        return this.parseTable.getFactory();
    }

    protected int getReductionCount() {
        return this.reductionCount;
    }

    protected int getRejectionCount() {
        return this.rejectCount;
    }

    static void TRACE(String string) {
        System.err.println("[" + traceCallCount + "] " + string);
        ++traceCallCount;
    }

    private String dumpActiveStacks() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        if (this.activeStacks == null) {
            sb.append(" GSS unitialized");
        } else {
            sb.append("{").append(this.activeStacks.size()).append("} ");
            for (Frame f : this.activeStacks) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(f.dumpStack());
                first = false;
            }
        }
        return sb.toString();
    }

    private void logParseResult(Link s) {
        if (Tools.measuring) {
            Measures m = new Measures();
            m.setTime(System.currentTimeMillis() - this.startTime);
            m.setReductionCount(this.reductionCount);
            m.setFramesCreated(Frame.framesCreated);
            m.setLinkedCreated(Link.linksCreated);
            m.setAvoidCount(s.recoverCount);
            m.setParseTime(parseTime);
            Measures.setParseCount(++parseCount);
            m.setAverageParseTime((int)parseTime / parseCount);
            m.setRecoverTime(-1L);
            Tools.setMeasures(m);
        }
    }

    private void logBeforeParsing() {
    }

    private void logAfterParsing() throws BadTokenException, TokenExpectedException {
        if (SGLR.isLogging()) {
            Tools.logger("Number of lines: ", this.lineNumber);
            Tools.logger("Maximum ", this.maxBranches, " parse branches reached at token ", this.logCharify(this.maxToken), ", line ", this.maxLine, ", column ", this.maxColumn, " (token #", this.maxTokenNumber, ")");
            long elapsed = System.currentTimeMillis() - this.startTime;
            Tools.logger("Parse time: " + (float)elapsed / 1000.0f + "s");
        }
        if (this.acceptingStack == null) {
            BadTokenException bad = this.createBadTokenException();
            if (this.collectedErrors.isEmpty()) {
                throw bad;
            }
            this.collectedErrors.add(bad);
            throw new MultiBadTokenException(this, this.collectedErrors);
        }
    }

    private void logCurrentToken() {
        if (SGLR.isLogging()) {
            Tools.logger("Current token (#", this.tokensSeen, "): ", this.logCharify(this.getCurrentToken()));
        }
    }

    private void logAfterShifter() {
    }

    private void logBeforeShifter() {
        if (Tools.logging) {
            Tools.logger("#", this.tokensSeen, ": shifting ", this.forShifter.size(), " parser(s) -- token ", this.logCharify(this.getCurrentToken()), ", line ", this.lineNumber, ", column ", this.columnNumber);
        }
    }

    private void logBeforeParseCharacter() {
    }

    private String logCharify(int currentToken) {
        switch (currentToken) {
            case 32: {
                return "\\32";
            }
            case 256: {
                return "EOF";
            }
            case 10: {
                return "\\n";
            }
            case 0: {
                return "\\0";
            }
        }
        return "" + (char)currentToken;
    }

    private void logBeforeActor(Frame st, State s) {
        Object actionItems = null;
    }

    private void logAfterDoReductions() {
    }

    private void logReductionPath(Production prod, Path path, Frame st0, State next) {
        if (Tools.logging) {
            Tools.logger("Goto(", st0.peek().stateNumber, ",", String.valueOf(prod.label) + ") == ", next.stateNumber);
        }
    }

    private void logBeforeDoReductions(Frame st, Production prod, int pathsCount) {
    }

    private void logBeforeLimitedReductions(Frame st, Production prod, Link l, PooledPathList paths) {
    }

    private void logReductionInfo(Frame st, Production prod) {
        Tools.debug(" state : ", st.peek().stateNumber);
        Tools.debug(" token : ", this.getCurrentToken());
        Tools.debug(" label : ", prod.label);
        Tools.debug(" arity : ", prod.arity);
        Tools.debug(" stack : ", st.dumpStack());
    }

    private void logAddedLink(Frame st0, Frame st1, Link nl) {
    }

    private void logBeforeReducer(State s, Production prod, int length) {
        if (Tools.logging) {
            Tools.logger("Reducing; state ", s.stateNumber, ", token: ", this.logCharify(this.getCurrentToken()), ", production: ", prod.label);
        }
    }

    private void TRACE_ActiveStacks() {
        SGLR.TRACE("SG_ - active stacks: " + this.activeStacks.size());
        SGLR.TRACE("SG_ - for_actor stacks: " + this.forActor.size());
        SGLR.TRACE("SG_ - for_actor_delayed stacks: " + this.forActorDelayed.size());
    }

    private void logAmbiguity(Frame st0, Production prod, Frame st1, Link nl) {
        if (Tools.logging) {
            Tools.logger("Ambiguity: direct link ", st0.state.stateNumber, " -> ", st1.state.stateNumber, " ", prod.isRejectProduction() ? "{reject}" : "");
            if (nl.label.isParseNode()) {
                Tools.logger("nl is ", nl.isRejected() ? "{reject}" : "", " for ", ((ParseNode)nl.label).getLabel());
            }
        }
    }

    protected void setCurrentToken(int currentToken) {
        this.currentToken = currentToken;
        if (currentToken == -1) {
            this.currentToken = 256;
        }
    }

    protected int getCurrentToken() {
        assert (this.currentToken >= 0);
        return this.currentToken;
    }
}

